/*
 * Decompiled with CFR 0.152.
 */
package com.ForgeEssentials.client.util;

import com.ForgeEssentials.client.util.ClientPoint;
import com.ForgeEssentials.client.util.ClientSelection;
import com.ForgeEssentials.client.util.SaveableObject;

@SaveableObject
public abstract class ClientAreaBase {
    @SaveableObject.SaveableField
    private ClientPoint high;
    @SaveableObject.SaveableField
    private ClientPoint low;

    public ClientAreaBase(ClientPoint start, ClientPoint end) {
        ClientPoint[] points = ClientAreaBase.getAlignedPoints(start, end);
        this.low = points[0];
        this.high = points[1];
    }

    public int getXLength() {
        return (int)(this.high.x - this.low.x + 1.0);
    }

    public int getYLength() {
        return (int)(this.high.y - this.low.y + 1.0);
    }

    public int getZLength() {
        return (int)(this.high.z - this.low.z + 1.0);
    }

    public ClientPoint getHighPoint() {
        return this.high;
    }

    public ClientPoint getLowPoint() {
        return this.low;
    }

    public static ClientPoint[] getAlignedPoints(ClientPoint p1, ClientPoint p2) {
        int diffx = p1.getX() - p2.getX();
        int diffy = p1.getY() - p2.getY();
        int diffz = p1.getZ() - p2.getZ();
        int newX1 = p2.getX();
        int newX2 = p1.getX();
        int newY1 = p2.getY();
        int newY2 = p1.getY();
        int newZ1 = p2.getZ();
        int newZ2 = p1.getZ();
        if (diffx < 0) {
            newX1 = p1.getX();
            newX2 = p2.getX();
        }
        if (diffy < 0) {
            newY1 = p1.getY();
            newY2 = p2.getY();
        }
        if (diffz < 0) {
            newZ1 = p1.getZ();
            newZ2 = p2.getZ();
        }
        return new ClientPoint[]{new ClientPoint(newX1, newY1, newZ1), new ClientPoint(newX2, newY2, newZ2)};
    }

    public boolean contains(ClientPoint p) {
        return this.high.compareTo(p) >= 0 && this.low.compareTo(p) <= 0;
    }

    public boolean contains(ClientAreaBase area) {
        return this.contains(area.high) && this.contains(area.low);
    }

    public boolean intersectsWith(ClientAreaBase area) {
        return this.contains(area.high) || this.contains(area.low);
    }

    public ClientAreaBase getIntersection(ClientAreaBase area) {
        if (this.intersectsWith(area)) {
            return null;
        }
        if (this.contains(area)) {
            return area;
        }
        ClientPoint iLow = ClientAreaBase.getAlignedPoints(this.low, area.low)[1];
        ClientPoint iHigh = ClientAreaBase.getAlignedPoints(this.high, area.high)[0];
        return new ClientSelection(iLow, iHigh);
    }

    public boolean makesCuboidWith(ClientAreaBase area) {
        boolean alignX = this.low.x == area.low.x && this.high.x == area.high.x;
        boolean alignY = this.low.y == area.low.y && this.high.y == area.high.y;
        boolean alignZ = this.low.z == area.low.z && this.high.z == area.high.z;
        return alignX || alignY || alignZ;
    }

    public ClientAreaBase getUnity(ClientAreaBase area) {
        if (!this.makesCuboidWith(area)) {
            return null;
        }
        ClientPoint iLow = ClientAreaBase.getAlignedPoints(this.low, area.low)[0];
        ClientPoint iHigh = ClientAreaBase.getAlignedPoints(this.high, area.high)[1];
        return new ClientSelection(iLow, iHigh);
    }

    public void redefine(ClientPoint p1, ClientPoint p2) {
        ClientPoint[] points = ClientAreaBase.getAlignedPoints(p1, p2);
        this.low = points[0];
        this.high = points[1];
    }

    public ClientAreaBase copy() {
        return new ClientSelection(this.low, this.high);
    }
}

