/*
 * Decompiled with CFR 0.152.
 */
package com.ForgeEssentials.client;

import com.ForgeEssentials.client.ClientConnectionHandler;
import com.ForgeEssentials.client.PlayerInfoClient;
import com.ForgeEssentials.client.cui.CUIPlayerLogger;
import com.ForgeEssentials.client.cui.CUIRenderrer;
import com.ForgeEssentials.client.cui.CUIRollback;
import com.ForgeEssentials.client.gui.FEKeyBinding;
import com.ForgeEssentials.client.network.PacketHandler;
import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.logging.Logger;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;

@NetworkMod(clientSideRequired=false, serverSideRequired=false, clientPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"ForgeEssentials"}, packetHandler=PacketHandler.class))
@Mod(modid="ForgeEssentialsClient", name="Forge Essentials Client Addon", version="@VERSION@")
public class ForgeEssentialsClient {
    private boolean allowCUI;
    public static Logger feclientlog;
    @SideOnly(value=Side.CLIENT)
    private static PlayerInfoClient info;

    private boolean getDevOverride() {
        String prop = System.getProperty("forgeessentials.client.developermode");
        if (prop != null && prop.equals("true")) {
            feclientlog.severe("Developer mode has been enabled, things may break.");
            return true;
        }
        return false;
    }

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent e) {
        feclientlog = e.getModLog();
        if (FMLCommonHandler.instance().getSide().isServer() && !this.getDevOverride()) {
            throw new RuntimeException("ForgeEssentialsClient should not be installed on a server!");
        }
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.config(new Configuration(e.getSuggestedConfigurationFile()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void config(Configuration config) {
        config.load();
        config.addCustomCategoryComment("Core", "Configure ForgeEssentials .");
        Property prop = config.get("Core", "allowCUI", true);
        prop.comment = "Set to false to disable graphical selections.";
        this.allowCUI = prop.getBoolean(true);
        prop = config.get("Core", "keybinding", 88);
        prop.comment = "Minecraft key code for activating the FE GUI. Defaults to F12 (88)";
        FEKeyBinding.fekeycode = prop.getInt(88);
        config.save();
    }

    @SideOnly(value=Side.CLIENT)
    @Mod.Init
    public void load(FMLInitializationEvent e) {
        NetworkRegistry.instance().registerConnectionHandler((IConnectionHandler)new ClientConnectionHandler());
        if (this.allowCUI) {
            MinecraftForge.EVENT_BUS.register((Object)new CUIRenderrer());
            MinecraftForge.EVENT_BUS.register((Object)new CUIPlayerLogger());
            MinecraftForge.EVENT_BUS.register((Object)new CUIRollback());
        }
        KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)new FEKeyBinding(new KeyBinding[]{new KeyBinding("ForgeEssentials Menu", 88)}));
    }

    @SideOnly(value=Side.CLIENT)
    public static PlayerInfoClient getInfo() {
        if (info == null) {
            info = new PlayerInfoClient();
        }
        return info;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setInfo(PlayerInfoClient info) {
        ForgeEssentialsClient.info = info;
    }
}

