/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.core.vec.BlockCoord;
import codechicken.core.vec.Cuboid6;
import codechicken.core.vec.Vector3;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.TickScheduler;
import codechicken.multipart.minecraft.McBlockPart;
import codechicken.multipart.minecraft.McSidedMetaPart;
import net.minecraftforge.common.ForgeDirection;

public class ButtonPart
extends McSidedMetaPart
implements IRedstonePart {
    public static ali stoneButton = (ali)apa.aV;
    public static ali woodenButton = (ali)apa.cj;
    public static int[] metaSideMap = new int[]{-1, 4, 5, 2, 3};
    public static int[] sideMetaMap = new int[]{-1, -1, 3, 4, 1, 2};

    public static ali getButton(int meta) {
        return (meta & 0x10) > 0 ? woodenButton : stoneButton;
    }

    public ButtonPart() {
    }

    public ButtonPart(int meta) {
        super(meta);
    }

    @Override
    public int sideForMeta(int meta) {
        return metaSideMap[meta & 7];
    }

    @Override
    public apa getBlock() {
        return ButtonPart.getButton(this.meta);
    }

    @Override
    public String getType() {
        return "mc_button";
    }

    public int delay() {
        return this.sensitive() ? 30 : 20;
    }

    public boolean sensitive() {
        return (this.meta & 0x10) > 0;
    }

    @Override
    public Cuboid6 getBounds() {
        double d;
        int m = this.meta & 7;
        double d2 = d = this.pressed() ? 0.0625 : 0.125;
        if (m == 1) {
            return new Cuboid6(0.0, 0.375, 0.3125, d, 0.625, 0.6875);
        }
        if (m == 2) {
            return new Cuboid6(1.0 - d, 0.375, 0.3125, 1.0, 0.625, 0.6875);
        }
        if (m == 3) {
            return new Cuboid6(0.3125, 0.375, 0.0, 0.6875, 0.625, d);
        }
        if (m == 4) {
            return new Cuboid6(0.3125, 0.375, 1.0 - d, 0.6875, 0.625, 1.0);
        }
        return null;
    }

    public static McBlockPart placement(aab world, BlockCoord pos, int side, int type) {
        if (side == 0 || side == 1) {
            return null;
        }
        pos = pos.copy().offset(side ^ 1);
        if (!world.isBlockSolidOnSide(pos.x, pos.y, pos.z, ForgeDirection.getOrientation((int)side))) {
            return null;
        }
        return new ButtonPart(sideMetaMap[side ^ 1] | type << 4);
    }

    @Override
    public boolean activate(sq player, ara part, wm item) {
        if (this.pressed()) {
            return false;
        }
        if (!this.world().I) {
            this.toggle();
        }
        return true;
    }

    @Override
    public void scheduledTick() {
        if (this.pressed()) {
            this.updateState();
        }
    }

    public boolean pressed() {
        return (this.meta & 8) > 0;
    }

    @Override
    public void onEntityCollision(mp entity) {
        if (!this.pressed() && !this.world().I && entity instanceof ss) {
            this.updateState();
        }
    }

    private void toggle() {
        boolean in = !this.pressed();
        this.meta = (byte)(this.meta ^ 8);
        this.world().a((double)this.x() + 0.5, (double)this.y() + 0.5, (double)this.z() + 0.5, "random.click", 0.3f, in ? 0.6f : 0.5f);
        if (in) {
            TickScheduler.scheduleTick(this, this.delay());
        }
        this.sendDescUpdate();
        this.tile().notifyPartChange();
        this.tile().notifyNeighborChange(metaSideMap[this.meta & 7]);
        this.tile().markDirty();
    }

    private void updateState() {
        boolean pressed;
        boolean arrows = this.sensitive() && !this.world().a(ss.class, this.getBounds().add(Vector3.fromTileEntity((aqp)this.getTile())).toAABB()).isEmpty();
        if (arrows != (pressed = this.pressed())) {
            this.toggle();
        }
        if (arrows && pressed) {
            TickScheduler.scheduleTick(this, this.delay());
        }
    }

    @Override
    public void onRemoved() {
        if (this.pressed()) {
            this.tile().notifyNeighborChange(metaSideMap[this.meta & 7]);
        }
    }

    @Override
    public int weakPowerLevel(int side) {
        return this.pressed() ? 15 : 0;
    }

    @Override
    public int strongPowerLevel(int side) {
        return this.pressed() && side == metaSideMap[this.meta & 7] ? 15 : 0;
    }

    @Override
    public boolean canConnectRedstone(int side) {
        return true;
    }
}

