/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart;

import codechicken.core.data.MCDataInput;
import codechicken.core.packet.PacketCustom;
import codechicken.core.vec.BlockCoord;
import codechicken.core.vec.Cuboid6;
import codechicken.core.vec.Vector3;
import codechicken.multipart.BlockMultipart$;
import codechicken.multipart.MultiPartRegistry$;
import codechicken.multipart.MultipartGenerator$;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

public final class TileMultipart$ {
    public static final TileMultipart$ MODULE$;
    private int renderID;
    private final TileMultipart.OperationSynchroniser operationSync;

    static {
        new TileMultipart$();
    }

    public int renderID() {
        return this.renderID;
    }

    public void renderID_$eq(int x$1) {
        this.renderID = x$1;
    }

    private TileMultipart.OperationSynchroniser operationSync() {
        return this.operationSync;
    }

    public void startOperation(TileMultipart tile) {
        if (!tile.k.I) {
            this.operationSync().startOperation(tile);
        }
    }

    public void finishOperation(TileMultipart tile) {
        if (!tile.k.I) {
            this.operationSync().finishOperation(tile);
        }
    }

    public boolean queueRemoval(TileMultipart tile, TMultiPart part) {
        return this.operationSync().queueRemoval(tile, part);
    }

    public boolean queueAddition(aab world, BlockCoord pos, TMultiPart part) {
        return this.operationSync().queueAddition(world, pos, part);
    }

    public TileMultipart getOrConvertTile(aab world, BlockCoord pos) {
        return (TileMultipart)((Object)this.getOrConvertTile2(world, pos)._1());
    }

    public Tuple2<TileMultipart, Object> getOrConvertTile2(aab world, BlockCoord pos) {
        aqp t = world.r(pos.x, pos.y, pos.z);
        if (t instanceof TileMultipart) {
            return new Tuple2((Object)((TileMultipart)t), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        int id = world.a(pos.x, pos.y, pos.z);
        TMultiPart p = MultiPartRegistry$.MODULE$.convertBlock(world, pos, id);
        if (p == null) {
            return new Tuple2(null, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        TileMultipart t2 = MultipartGenerator$.MODULE$.generateCompositeTile(null, (Seq<TMultiPart>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TMultiPart[]{p}))), world.I);
        t2.l = pos.x;
        t2.m = pos.y;
        t2.n = pos.z;
        t2.b(world);
        t2.addPart_do(p);
        return new Tuple2((Object)t2, (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public TileMultipart getTile(aab world, BlockCoord pos) {
        aqp t = world.r(pos.x, pos.y, pos.z);
        if (t instanceof TileMultipart) {
            return (TileMultipart)t;
        }
        return null;
    }

    public boolean canPlacePart(aab world, BlockCoord pos, TMultiPart part) {
        Object object = new Object();
        try {
            JavaConversions$.MODULE$.iterableAsScalaIterable(part.getCollisionBoxes()).foreach((Function1)new Serializable(world, pos, object){
                public static final long serialVersionUID = 0L;
                private final aab world$1;
                private final BlockCoord pos$1;
                private final Object nonLocalReturnKey1$1;

                public final void apply(Cuboid6 b) {
                    if (this.world$1.b(b.toAABB().d((double)this.pos$1.x, (double)this.pos$1.y, (double)this.pos$1.z))) {
                        return;
                    }
                    throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, false);
                }
                {
                    this.world$1 = world$1;
                    this.pos$1 = pos$1;
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            });
            TileMultipart t = this.getOrConvertTile(world, pos);
            if (t == null) {
                return this.replaceable(world, pos);
            }
            return t.canAddPart(part);
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return nonLocalReturnControl.value$mcZ$sp();
            }
            throw nonLocalReturnControl;
        }
    }

    public boolean replaceable(aab world, BlockCoord pos) {
        apa block = apa.r[world.a(pos.x, pos.y, pos.z)];
        return block == null || block.isAirBlock(world, pos.x, pos.y, pos.z) || block.isBlockReplaceable(world, pos.x, pos.y, pos.z);
    }

    public TileMultipart addPart(aab world, BlockCoord pos, TMultiPart part) {
        Predef$.MODULE$.assert(!world.I, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cannot add multi parts to a client tile.";
            }
        });
        if (this.queueAddition(world, pos, part)) {
            return null;
        }
        return MultipartGenerator$.MODULE$.addPart(world, pos, part);
    }

    public void handleDescPacket(aab world, BlockCoord pos, PacketCustom packet) {
        TileMultipart tilemp;
        int nparts = packet.readUnsignedByte();
        ListBuffer parts = new ListBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nparts).foreach((Function1)new Serializable(packet, parts){
            public static final long serialVersionUID = 0L;
            private final PacketCustom packet$2;
            private final ListBuffer parts$1;

            public final ListBuffer<TMultiPart> apply(int i) {
                TMultiPart part = MultiPartRegistry$.MODULE$.readPart((MCDataInput)this.packet$2);
                part.readDesc((MCDataInput)this.packet$2);
                return this.parts$1.$plus$eq((Object)part);
            }
            {
                this.packet$2 = packet$2;
                this.parts$1 = parts$1;
            }
        });
        if (parts.size() == 0) {
            return;
        }
        aqp t = world.r(pos.x, pos.y, pos.z);
        TileMultipart tileMultipart = tilemp = MultipartGenerator$.MODULE$.generateCompositeTile(t, (Seq<TMultiPart>)parts, true);
        aqp aqp2 = t;
        if (tileMultipart == null ? aqp2 != null : !((Object)((Object)tileMultipart)).equals(aqp2)) {
            world.a(pos.x, pos.y, pos.z, (aqp)tilemp);
        }
        tilemp.loadParts((ListBuffer<TMultiPart>)parts);
        tilemp.markRender();
    }

    public void handlePacket(BlockCoord pos, aab world, int i, PacketCustom packet) {
        TileMultipart tilemp = BlockMultipart$.MODULE$.getTile((aak)world, pos.x, pos.y, pos.z);
        int n = i;
        switch (n) {
            default: {
                if (tilemp == null) break;
                ((TMultiPart)tilemp.partList().apply(i)).read((MCDataInput)packet);
                break;
            }
            case 254: {
                if (tilemp == null) break;
                tilemp.remPart_impl((TMultiPart)tilemp.partList().apply(packet.readUnsignedByte()));
                break;
            }
            case 253: {
                TMultiPart part = MultiPartRegistry$.MODULE$.readPart((MCDataInput)packet);
                part.readDesc((MCDataInput)packet);
                MultipartGenerator$.MODULE$.addPart(world, pos, part);
            }
        }
    }

    public TileMultipart createFromNBT(bs tag) {
        String superID = tag.i("superID");
        ca partList = tag.m("parts");
        ListBuffer parts = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partList.c()).foreach((Function1)new Serializable(partList, parts){
            public static final long serialVersionUID = 0L;
            private final ca partList$1;
            private final ListBuffer parts$2;

            public final Object apply(int i) {
                BoxedUnit boxedUnit;
                bs partTag = (bs)this.partList$1.b(i);
                String partID = partTag.i("id");
                TMultiPart part = MultiPartRegistry$.MODULE$.createPart(partID, false);
                if (part == null) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    part.load(partTag);
                    boxedUnit = this.parts$2.$plus$eq((Object)part);
                }
                return boxedUnit;
            }
            {
                this.partList$1 = partList$1;
                this.parts$2 = parts$2;
            }
        });
        if (parts.size() == 0) {
            return null;
        }
        TileMultipart tmb = MultipartGenerator$.MODULE$.generateCompositeTile(null, (Seq<TMultiPart>)parts, false);
        tmb.a(tag);
        tmb.loadParts((ListBuffer<TMultiPart>)parts);
        return tmb;
    }

    public void dropItem(wm stack, aab world, Vector3 pos) {
        rh item = new rh(world, pos.x, pos.y, pos.z, stack);
        item.x = world.s.nextGaussian() * 0.05;
        item.y = world.s.nextGaussian() * 0.05 + (double)0.2f;
        item.z = world.s.nextGaussian() * 0.05;
        world.d((mp)item);
    }

    private TileMultipart$() {
        MODULE$ = this;
        this.renderID = -1;
        this.operationSync = new TileMultipart.OperationSynchroniser();
    }
}

