/*
 * Decompiled with CFR 0.152.
 */
package eplus.network.packets;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.relauncher.Side;
import eplus.EnchantingPlus;
import eplus.lib.ConfigurationSettings;
import eplus.network.packets.BasePacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class GuiPacket
extends BasePacket {
    private String username;
    private int guiId;
    private int xPos;
    private int yPos;
    private int zPos;

    public GuiPacket() {
    }

    public GuiPacket(String username, int guiId, int xPos, int yPos, int zPos) {
        this.username = username;
        this.guiId = guiId;
        this.xPos = xPos;
        this.yPos = yPos;
        this.zPos = zPos;
    }

    @Override
    public void execute(EntityPlayer player, Side side) {
        if (side == Side.SERVER) {
            NBTTagCompound tag = player.getEntityData();
            switch (this.guiId) {
                case 0: {
                    if (!tag.func_74767_n("eplus:useMod") || !ConfigurationSettings.useMod) break;
                    player.openGui((Object)EnchantingPlus.INSTANCE, this.guiId, player.field_70170_p, this.xPos, this.yPos, this.zPos);
                    break;
                }
                case 1: {
                    player.openGui((Object)EnchantingPlus.INSTANCE, this.guiId, player.field_70170_p, this.xPos, this.yPos, this.zPos);
                }
            }
        }
    }

    @Override
    public void read(ByteArrayDataInput input) {
        this.username = input.readUTF();
        this.guiId = input.readInt();
        this.xPos = input.readInt();
        this.yPos = input.readInt();
        this.zPos = input.readInt();
    }

    @Override
    protected void write(ByteArrayDataOutput output) {
        output.writeUTF(this.username);
        output.writeInt(this.guiId);
        output.writeInt(this.xPos);
        output.writeInt(this.yPos);
        output.writeInt(this.zPos);
    }
}

