/*
 * Decompiled with CFR 0.152.
 */
package eplus.network.packets;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import eplus.network.packets.ConfigPacket;
import eplus.network.packets.DisenchantErrorPacket;
import eplus.network.packets.EnchantPacket;
import eplus.network.packets.EnchantmentAllowedPacket;
import eplus.network.packets.GuiPacket;
import eplus.network.packets.ReConfigPacket;
import eplus.network.packets.RepairPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;

public abstract class BasePacket {
    public static final String CHANNEL = "eplus";
    private static final BiMap<Integer, Class<? extends BasePacket>> idMap;

    public static BasePacket constructPacket(int packetId) throws ProtocolException, IllegalAccessException, InstantiationException {
        Class clazz = (Class)idMap.get((Object)packetId);
        if (clazz == null) {
            throw new ProtocolException("Unknown Packet Id!");
        }
        return (BasePacket)clazz.newInstance();
    }

    public abstract void execute(EntityPlayer var1, Side var2);

    final int getPacketId() {
        if (idMap.inverse().containsKey(this.getClass())) {
            return (Integer)idMap.inverse().get(this.getClass());
        }
        throw new RuntimeException("Packet " + this.getClass().getSimpleName() + " is missing a mapping!");
    }

    public final Packet makePacket() {
        ByteArrayDataOutput output = ByteStreams.newDataOutput();
        output.writeByte(this.getPacketId());
        this.write(output);
        return PacketDispatcher.getPacket((String)CHANNEL, (byte[])output.toByteArray());
    }

    public abstract void read(ByteArrayDataInput var1);

    protected abstract void write(ByteArrayDataOutput var1);

    static {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.put((Object)0, EnchantPacket.class);
        builder.put((Object)1, ConfigPacket.class);
        builder.put((Object)2, ReConfigPacket.class);
        builder.put((Object)3, GuiPacket.class);
        builder.put((Object)4, RepairPacket.class);
        builder.put((Object)5, EnchantmentAllowedPacket.class);
        builder.put((Object)6, DisenchantErrorPacket.class);
        idMap = builder.build();
    }

    public static class ProtocolException
    extends Exception {
        private static final long serialVersionUID = 4024261898937341903L;

        public ProtocolException() {
        }

        public ProtocolException(String message) {
            super(message);
        }

        public ProtocolException(String message, Throwable cause) {
            super(message, cause);
        }

        public ProtocolException(Throwable cause) {
            super(cause);
        }
    }
}

