/*
 * Decompiled with CFR 0.152.
 */
package eplus.gui;

import cpw.mods.fml.common.network.PacketDispatcher;
import eplus.EnchantingPlus;
import eplus.helper.EnchantHelper;
import eplus.helper.MathHelper;
import eplus.inventory.ContainerEnchantTable;
import eplus.inventory.TileEnchantTable;
import eplus.lib.ConfigurationSettings;
import eplus.lib.EnchantmentHelp;
import eplus.lib.Strings;
import eplus.network.packets.EnchantPacket;
import eplus.network.packets.GuiPacket;
import eplus.network.packets.RepairPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.network.packet.Packet;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiModTable
extends GuiContainer {
    private static boolean TMInagged = false;
    private final EntityPlayer player;
    private final ContainerEnchantTable container;
    private final int xPos;
    private final int yPos;
    private final int zPos;
    private ArrayList<GuiItem> enchantmentArray = new ArrayList();
    private double sliderIndex = 0.0;
    private double enchantingPages = 0.0;
    private double sliderY = 0.0;
    private Map<Integer, Integer> enchantments;
    private boolean clicked = false;
    private boolean sliding = false;
    private int totalCost = 0;
    private int repairAmount = 0;
    private boolean dirty = false;
    private final String texture = "/assets/eplus/textures/gui/enchant.png";
    public String error = "";
    private static int guiOffset = 26;

    public GuiModTable(InventoryPlayer inventory, World world, int x, int y, int z, TileEnchantTable tileEntity) {
        super((Container)new ContainerEnchantTable(inventory, world, x, y, z, tileEntity));
        this.player = inventory.field_70458_d;
        this.container = (ContainerEnchantTable)this.field_74193_d;
        this.xPos = x;
        this.yPos = y;
        this.zPos = z;
        this.field_74194_b = 235;
        this.field_74195_c = 182;
    }

    protected void func_73875_a(GuiButton par1GuiButton) {
        HashMap<Integer, Integer> enchants = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> levels = new HashMap<Integer, Integer>();
        for (GuiItem item : this.enchantmentArray) {
            Integer id = this.enchantments.get(((GuiItem)item).enchantment.field_77352_x);
            if (item.enchantmentLevel == id || item.disabled) continue;
            enchants.put(((GuiItem)item).enchantment.field_77352_x, item.enchantmentLevel);
            levels.put(((GuiItem)item).enchantment.field_77352_x, item.privateLevel);
        }
        switch (par1GuiButton.field_73741_f) {
            case 0: {
                if (enchants.size() > 0) {
                    PacketDispatcher.sendPacketToServer((Packet)new EnchantPacket(enchants, levels, this.totalCost).makePacket());
                }
                return;
            }
            case 1: {
                if (enchants.size() == 0 && ConfigurationSettings.AllowRepair) {
                    PacketDispatcher.sendPacketToServer((Packet)new RepairPacket(this.totalCost, this.repairAmount).makePacket());
                }
                return;
            }
            case 2: {
                PacketDispatcher.sendPacketToServer((Packet)new GuiPacket(this.player.field_71092_bJ, 1, this.xPos, this.yPos, this.zPos).makePacket());
            }
        }
    }

    private ArrayList<GuiItem> convertMapToGuiItems(Map<Integer, Integer> map, int x, int y) {
        ArrayList<GuiItem> temp = new ArrayList<GuiItem>();
        if (map == null) {
            return temp;
        }
        int i = 0;
        int yPos = y;
        Iterator<Integer> i$ = map.keySet().iterator();
        while (i$.hasNext()) {
            Integer obj;
            Integer enchantmentId = obj = i$.next();
            Integer enchantmentLevel = map.get(obj);
            temp.add(new GuiItem(enchantmentId, enchantmentLevel, x, yPos));
            yPos = y + ++i * 18;
        }
        return temp;
    }

    protected void func_74185_a(float f, int i, int j) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b("/assets/eplus/textures/gui/enchant.png");
        this.func_73729_b(this.field_74198_m, this.field_74197_n, 0, 0, this.field_74194_b, this.field_74195_c);
        for (GuiItem item : this.enchantmentArray) {
            if (item.yPos < this.field_74197_n + 15 || item.yPos >= this.field_74197_n + 87) {
                item.show(false);
            } else {
                item.show(true);
            }
            item.draw();
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        block27: {
            StringBuilder sb;
            super.func_73863_a(par1, par2, par3);
            int adjustedMouseX = par1 - this.field_74198_m;
            int adjustedMouseY = par2 - this.field_74197_n;
            this.field_73882_e.field_71446_o.func_98187_b("/assets/eplus/textures/gui/enchant.png");
            int tempY = adjustedMouseY - 16;
            if (tempY <= 0) {
                tempY = 0;
            }
            if (tempY >= 57) {
                tempY = 57;
            }
            double d = this.sliderIndex = this.sliding ? MathHelper.round((double)tempY / 57.0 * this.enchantingPages, 0.25) : this.sliderIndex;
            if (this.sliderIndex >= this.enchantingPages) {
                this.sliderIndex = this.enchantingPages;
            }
            this.sliderY = this.sliding ? (double)tempY : 57.0 * (this.sliderIndex / this.enchantingPages);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_74198_m + guiOffset + 180, this.field_74197_n + 16 + (int)this.sliderY, 0, 182, 12, 15);
            if (!this.clicked && Mouse.isButtonDown((int)0)) {
                for (GuiItem item : this.enchantmentArray) {
                    if (this.getItemFromPos(par1, par2) != item || item.disabled || item.locked) continue;
                    item.dragging = true;
                }
                if (adjustedMouseX <= 191 + guiOffset && adjustedMouseX >= 180 + guiOffset && this.enchantingPages != 0.0) {
                    this.sliding = true;
                }
            }
            for (GuiItem item : this.enchantmentArray) {
                if (!item.dragging || this.getItemFromPos(par1, par2) == item) continue;
                item.dragging = false;
            }
            if (!Mouse.isButtonDown((int)0)) {
                for (GuiItem item : this.enchantmentArray) {
                    if (this.getItemFromPos(par1, par2) != item) continue;
                    item.dragging = false;
                }
                if (adjustedMouseX <= 191 + guiOffset && adjustedMouseX >= 180 + guiOffset) {
                    this.sliding = false;
                }
            }
            this.clicked = Mouse.isButtonDown((int)0);
            for (GuiItem item : this.enchantmentArray) {
                if (!item.dragging) continue;
                item.scroll(adjustedMouseX - 36);
            }
            if (EnchantingPlus.Debug) {
                this.field_73886_k.func_78276_b(String.format("%s: %s", "Error", this.error), 5, 5, -5588054);
            }
            int maxWidth = this.field_74198_m - 20;
            ArrayList<List> information = new ArrayList<List>();
            information.add(this.field_73886_k.func_78271_c(String.format("%s: %s", Strings.playerLevel, this.player.field_71068_ca), maxWidth));
            if (this.container.tableInventory.func_70301_a(0) == null || this.levelChanged() || !this.levelChanged() && !this.container.tableInventory.func_70301_a(0).func_77951_h()) {
                information.add(this.field_73886_k.func_78271_c(String.format("%s: %s", Strings.enchantingCost, this.totalCost), maxWidth));
            } else if (ConfigurationSettings.AllowRepair && !this.levelChanged() && this.container.tableInventory.func_70301_a(0).func_77951_h()) {
                information.add(this.field_73886_k.func_78271_c(String.format("%s: %s", Strings.repairCost, this.totalCost), maxWidth));
            }
            information.add(this.field_73886_k.func_78271_c(String.format("%s: %s", Strings.maxEnchantLevel, Float.valueOf(this.container.bookCases())), maxWidth));
            for (List display : information) {
                int height;
                int n = height = information.indexOf(display) == 0 ? this.field_74197_n + this.field_73886_k.field_78288_b + 8 : this.field_74197_n + (this.field_73886_k.field_78288_b + 8) * (information.indexOf(display) + 1);
                if (information.indexOf(display) > 0) {
                    for (int i = information.indexOf(display) - 1; i >= 0; --i) {
                        height += (this.field_73886_k.field_78288_b + 3) * (((List)information.get(i)).size() - 1);
                    }
                }
                try {
                    this.drawHoveringText(display, this.field_74198_m - 20 - maxWidth, height, this.field_73886_k);
                }
                catch (NoSuchMethodError e) {
                    sb = new StringBuilder();
                    for (String text : display) {
                        sb.append(text);
                        sb.append(" ");
                    }
                    this.func_74190_a(sb.toString(), this.field_74198_m - 20 - maxWidth, height);
                    if (TMInagged) continue;
                    EnchantingPlus.log.severe("Please update or remove NEI / TMI. It is causing issues.");
                    TMInagged = true;
                }
            }
            if (GuiModTable.func_73877_p() && this.getItemFromPos(par1, par2) != null) {
                String name = "\u00a7l" + this.getItemFromPos(par1, par2).getTranslatedName();
                String info = EnchantmentHelp.getToolTip(this.getItemFromPos(par1, par2).enchantment);
                if (info.isEmpty()) {
                    info = "\u00a74" + String.format("%s ", Strings.errorToolTip) + this.getItemFromPos(par1, par2).enchantment.func_77320_a();
                }
                info = "\u00a75" + info;
                ArrayList<String> display = new ArrayList<String>();
                display.add(name);
                display.addAll(this.field_73886_k.func_78271_c(info, 150));
                try {
                    this.drawHoveringText(display, par1, par2, this.field_73886_k);
                }
                catch (NoSuchMethodError e) {
                    sb = new StringBuilder();
                    for (String text : display) {
                        sb.append(text);
                        sb.append(" ");
                    }
                    this.func_74190_a(sb.toString(), this.field_74198_m - 20 - maxWidth, this.field_73881_g);
                    if (TMInagged) break block27;
                    EnchantingPlus.log.severe("Please update or remove NEI / TMI. It is causing issues.");
                    TMInagged = true;
                }
            }
        }
        if (!this.error.isEmpty()) {
            this.func_74190_a(this.error, (this.field_74194_b + this.field_74198_m) / 2 - this.field_73886_k.func_78256_a(this.error) / 4, this.field_74197_n - this.field_73886_k.field_78288_b);
        }
    }

    private GuiItem getItemFromPos(int x, int y) {
        if (x < this.field_74198_m + guiOffset + 35 || x > this.field_74198_m + this.field_74194_b - 32) {
            return null;
        }
        for (GuiItem item : this.enchantmentArray) {
            if (!item.show || y < item.yPos || y > item.yPos + item.height) continue;
            return item;
        }
        return null;
    }

    public void func_73867_d() {
        super.func_73867_d();
        int eventDWheel = Mouse.getEventDWheel();
        int mouseX = Mouse.getEventX() * this.field_73880_f / this.field_73882_e.field_71443_c - this.field_74198_m;
        int mouseY = this.field_73881_g - Mouse.getEventY() * this.field_73881_g / this.field_73882_e.field_71440_d - 1 - this.field_74197_n;
        if (eventDWheel != 0 && (mouseX >= 35 + guiOffset && mouseX <= this.field_74194_b + guiOffset - 32 || mouseX >= 180 + guiOffset && mouseX <= 192 + guiOffset) && mouseY >= 15 && mouseY <= 87) {
            if (eventDWheel < 0) {
                this.sliderIndex += 0.25;
                if (this.sliderIndex >= this.enchantingPages) {
                    this.sliderIndex = this.enchantingPages;
                }
            } else {
                this.sliderIndex -= 0.25;
                if (this.sliderIndex <= 0.0) {
                    this.sliderIndex = 0.0;
                }
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_73887_h.add(new GuiIcon(0, this.field_74198_m + guiOffset + 9, this.field_74197_n + 40, "E").customTexture(0));
        this.field_73887_h.add(new GuiIcon(1, this.field_74198_m + guiOffset + 9, this.field_74197_n + 60, "R").customTexture(0));
        String s = "Vanilla";
        this.field_73887_h.add(new GuiButton(2, this.field_74198_m + this.field_74194_b + 10, this.field_74197_n + 5, this.field_73886_k.func_78256_a("Vanilla") + 10, 20, "Vanilla"));
        this.dirty = true;
    }

    protected boolean levelChanged() {
        for (GuiItem item : this.enchantmentArray) {
            if (item.enchantmentLevel == item.privateLevel) continue;
            return true;
        }
        return false;
    }

    protected void func_73864_a(int x, int y, int par3) {
        super.func_73864_a(x, y, par3);
        GuiItem itemFromPos = this.getItemFromPos(x, y);
        if (itemFromPos != null) {
            for (GuiItem item : this.enchantmentArray) {
                if (item != itemFromPos) continue;
                itemFromPos.handleClick(par3);
            }
        }
    }

    public void func_73876_c() {
        block19: {
            block18: {
                int i;
                GuiItem item2;
                super.func_73876_c();
                Map<Integer, Integer> enchantments = this.container.getEnchantments();
                if (this.enchantments != enchantments) {
                    this.enchantments = enchantments;
                    this.enchantmentArray = this.convertMapToGuiItems(enchantments, 35 + guiOffset + this.field_74198_m, 15 + this.field_74197_n);
                    this.enchantingPages = 0.0;
                    this.sliderIndex = 0.0;
                    this.sliding = false;
                    this.clicked = false;
                    this.error = "";
                }
                if (this.dirty) {
                    ArrayList<GuiItem> temp = this.convertMapToGuiItems(enchantments, 35 + guiOffset + this.field_74198_m, 15 + this.field_74197_n);
                    for (GuiItem item2 : this.enchantmentArray) {
                        for (GuiItem tempItem : temp) {
                            if (item2.enchantment != tempItem.enchantment) continue;
                            item2.startingXPos = item2.xPos = tempItem.xPos;
                            item2.startingYPos = item2.yPos = tempItem.yPos;
                        }
                    }
                    this.dirty = false;
                }
                boolean[] enabled = new boolean[this.enchantmentArray.size()];
                for (i = 0; i < enabled.length; ++i) {
                    enabled[i] = false;
                }
                for (i = 0; i < this.enchantmentArray.size(); ++i) {
                    item2 = this.enchantmentArray.get(i);
                    if (item2.enchantmentLevel == 0) continue;
                    for (int i1 = 0; i1 < this.enchantmentArray.size(); ++i1) {
                        GuiItem item2 = this.enchantmentArray.get(i1);
                        if (item2 == item2) continue;
                        enabled[i1] = enabled[i1] || i != i1 && (!item2.enchantment.func_77326_a(item2.enchantment) || !item2.enchantment.func_77326_a(item2.enchantment));
                    }
                }
                for (i = 0; i < this.enchantmentArray.size(); ++i) {
                    item2 = this.enchantmentArray.get(i);
                    item2.disabled = enabled[i];
                }
                this.enchantingPages = (double)this.enchantmentArray.size() / 4.0 > 1.0 ? (double)this.enchantmentArray.size() / 4.0 - 1.0 : 0.0;
                this.totalCost = 0;
                this.repairAmount = 0;
                if (this.enchantmentArray.isEmpty() || !this.levelChanged()) break block18;
                for (GuiItem item2 : this.enchantmentArray) {
                    item2.yPos = item2.startingYPos - (int)(72.0 * this.sliderIndex);
                    Integer level = enchantments.get(((GuiItem)item2).enchantment.field_77352_x);
                    if (item2.enchantmentLevel > level && !item2.disabled) {
                        int temp;
                        block17: {
                            temp = this.totalCost + this.container.enchantmentCost(((GuiItem)item2).enchantment.field_77352_x, item2.enchantmentLevel, level);
                            try {
                                if (!this.container.canPurchase(this.player, temp)) break block17;
                                item2.locked = false;
                            }
                            catch (Exception e) {
                                item2.locked = true;
                                this.error = e.getMessage();
                                while (item2.locked && item2.enchantmentLevel > 0) {
                                    item2.dragging = false;
                                    item2.enchantmentLevel--;
                                    temp = this.totalCost + this.container.enchantmentCost(((GuiItem)item2).enchantment.field_77352_x, item2.enchantmentLevel, level);
                                    try {
                                        if (!this.container.canPurchase(this.player, temp)) continue;
                                        item2.locked = false;
                                    }
                                    catch (Exception ex) {}
                                }
                            }
                        }
                        this.totalCost = temp;
                        continue;
                    }
                    if (item2.enchantmentLevel >= level || item2.disabled) continue;
                    if (EnchantHelper.containsKey(this.container.tableInventory.func_70301_a(0).func_77978_p().func_74761_m("restrictions"), ((GuiItem)item2).enchantment.field_77352_x, item2.enchantmentLevel) || ConfigurationSettings.allowDisenUnowned) {
                        this.totalCost += this.container.disenchantmentCost(((GuiItem)item2).enchantment.field_77352_x, item2.enchantmentLevel, level);
                        continue;
                    }
                    item2.enchantmentLevel++;
                    this.error = "Can not disenchant level not placed by yourself via eplus";
                }
                break block19;
            }
            if (!ConfigurationSettings.AllowRepair || this.levelChanged()) break block19;
            this.totalCost += this.container.repairCostMax(this.player);
            int itemDamage = this.container.tableInventory.func_70301_a(0) != null ? this.container.tableInventory.func_70301_a(0).func_77960_j() : 0;
            int playerLevel = this.player.field_71068_ca;
            this.repairAmount = itemDamage > playerLevel ? playerLevel : itemDamage;
            for (GuiItem item : this.enchantmentArray) {
                item.yPos = item.startingYPos - (int)(72.0 * this.sliderIndex);
            }
        }
    }

    class GuiItem
    extends Gui {
        private final Enchantment enchantment;
        private final int height;
        private final int width;
        private final int privateLevel;
        public int startingXPos;
        public int startingYPos;
        public int yPos;
        public boolean locked = false;
        private int xPos;
        private int enchantmentLevel;
        private boolean show = true;
        private float index;
        private boolean dragging = false;
        private int sliderX;
        private boolean disabled;

        public GuiItem(int id, int level, int x, int y) {
            this.enchantment = Enchantment.field_77331_b[id];
            this.enchantmentLevel = level;
            this.privateLevel = level;
            this.xPos = this.startingXPos = x;
            this.yPos = this.startingYPos = y;
            this.sliderX = this.xPos + 1;
            this.height = 18;
            this.width = 143;
        }

        public void draw() {
            if (!this.show) {
                return;
            }
            int indexX = this.dragging ? this.sliderX : (this.enchantmentLevel <= this.enchantment.func_77325_b() ? (int)((double)(this.xPos + 1) + (double)(this.width - 6) * ((double)this.enchantmentLevel / (double)this.enchantment.func_77325_b())) : this.xPos + 1 + this.width - 6);
            GuiItem.func_73734_a((int)indexX, (int)(this.yPos + 1), (int)(indexX + 5), (int)(this.yPos - 1 + this.height), (int)-16777216);
            GuiModTable.this.field_73886_k.func_78276_b(this.getTranslatedName(), this.xPos + 5, this.yPos + this.height / 4, 1437269760);
            if (this.disabled) {
                GuiItem.func_73734_a((int)this.xPos, (int)(this.yPos + 1), (int)(this.xPos + this.width), (int)(this.yPos - 1 + this.height), (int)0x44AAFFFF);
            } else if (this.locked) {
                GuiItem.func_73734_a((int)this.xPos, (int)(this.yPos + 1), (int)(this.xPos + this.width), (int)(this.yPos - 1 + this.height), (int)0x44FF0000);
            } else {
                GuiItem.func_73734_a((int)this.xPos, (int)(this.yPos + 1), (int)(this.xPos + this.width), (int)(this.yPos - 1 + this.height), (int)1152013823);
            }
        }

        public String getTranslatedName() {
            String name = this.enchantment.func_77316_c(this.enchantmentLevel);
            if (this.enchantmentLevel == 0) {
                name = name.lastIndexOf(" ") == -1 ? this.enchantment.func_77320_a() : name.substring(0, name.lastIndexOf(" "));
            }
            return name;
        }

        public void handleClick(int mouseButton) {
        }

        public void scroll(int xPos) {
            int start = guiOffset + GuiModTable.this.field_74198_m + 10;
            if (this.disabled) {
                return;
            }
            this.sliderX = start + xPos;
            if (this.sliderX <= start) {
                this.sliderX = start;
            }
            if (this.sliderX >= start + this.width + 20) {
                this.sliderX = start + this.width + 20;
            }
            this.index = (float)xPos / (float)(this.width + 10);
            int tempLevel = (int)Math.floor(this.privateLevel > this.enchantment.func_77325_b() ? (double)((float)this.privateLevel * this.index) : (double)((float)this.enchantment.func_77325_b() * this.index));
            if (this.locked) {
                if (tempLevel < this.enchantmentLevel && (!((GuiModTable)GuiModTable.this).container.tableInventory.func_70301_a(0).func_77951_h() || ConfigurationSettings.AllowEnchantDamaged)) {
                    this.enchantmentLevel = tempLevel;
                    this.locked = false;
                }
            } else if (tempLevel >= this.privateLevel || ConfigurationSettings.AllowDisenchanting && !((GuiModTable)GuiModTable.this).container.tableInventory.func_70301_a(0).func_77951_h() || ConfigurationSettings.AllowEnchantDamaged) {
                this.enchantmentLevel = tempLevel;
            }
            if (this.enchantmentLevel <= 0) {
                this.enchantmentLevel = 0;
            }
        }

        public void show(boolean b) {
            this.show = b;
        }
    }

    class GuiIcon
    extends GuiButton {
        private boolean customTexture;
        private int textureIndex;

        public GuiIcon(int id, int x, int y, int width, int height, String caption) {
            super(id, x, y, width, height, caption);
        }

        public GuiIcon(int id, int x, int y, String caption) {
            this(id, x, y, 16, 16, caption);
        }

        public GuiIcon customTexture(int texture) {
            this.textureIndex = texture;
            boolean bl = this.customTexture = texture != 0;
            if (!this.customTexture) {
                this.field_73747_a = 20;
                this.field_73745_b = 20;
            }
            return this;
        }

        public void func_73737_a(Minecraft mc, int x, int y) {
            if (!this.customTexture) {
                super.func_73737_a(mc, x, y);
            } else {
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.field_71446_o.func_98187_b("/assets/eplus/textures/gui/enchant.png");
                this.func_73729_b(this.field_73746_c, this.field_73743_d, 8 + this.textureIndex * 16, 182, this.field_73747_a, this.field_73745_b);
            }
        }

        public GuiIcon enabled(boolean enabled) {
            this.field_73742_g = enabled;
            return this;
        }
    }
}

