/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.worldgen;

import java.util.Random;
import mods.tinker.tconstruct.common.TContent;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;

public class SlimeTreeGen
extends WorldGenerator {
    public final int minTreeHeight;
    public final int treeHeightRange;
    public final int metaWood;
    public final int metaLeaves;
    public final boolean seekHeight;

    public SlimeTreeGen(boolean notify, int treeHeight, int treeRange, int woodMeta, int leavesMeta) {
        super(notify);
        this.minTreeHeight = treeHeight;
        this.treeHeightRange = treeRange;
        this.metaWood = woodMeta;
        this.metaLeaves = leavesMeta;
        this.seekHeight = !notify;
    }

    public boolean func_76484_a(World world, Random random, int xPos, int yPos, int zPos) {
        int height = random.nextInt(this.treeHeightRange) + this.minTreeHeight;
        boolean flag = true;
        if (this.seekHeight && (yPos = this.findGround(world, xPos, yPos, zPos)) == -1) {
            return false;
        }
        if (yPos >= 1 && yPos + height + 1 <= 256) {
            boolean isSoil;
            Block soil = Block.field_71973_m[world.func_72798_a(xPos, yPos - 1, zPos)];
            boolean bl = isSoil = soil != null && soil.canSustainPlant(world, xPos, yPos - 1, zPos, ForgeDirection.UP, (IPlantable)TContent.slimeSapling);
            if (isSoil) {
                if (!this.checkClear(world, xPos, yPos, zPos, height)) {
                    return false;
                }
                soil.onPlantGrow(world, xPos, yPos - 1, zPos, xPos, yPos, zPos);
                this.placeCanopy(world, random, xPos, yPos, zPos, height);
                this.placeTrunk(world, xPos, yPos, zPos, height);
                return true;
            }
        }
        return false;
    }

    boolean checkClear(World world, int x, int y, int z, int treeHeight) {
        for (int yPos = 0; yPos < treeHeight + 1; ++yPos) {
            int range = 1;
            if (yPos == 0) {
                range = 0;
            } else if (yPos >= treeHeight - 1) {
                range = 2;
            }
            for (int xPos = range; xPos <= range; ++xPos) {
                for (int zPos = range; zPos <= range; ++zPos) {
                    int blockID = world.func_72798_a(x + xPos, y + yPos, z + zPos);
                    Block block = Block.field_71973_m[blockID];
                    if (block == null || blockID == TContent.slimeSapling.field_71990_ca || block.isLeaves(world, x + xPos, y + yPos, z + zPos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    int findGround(World world, int x, int y, int z) {
        int ret = -1;
        int height = y;
        do {
            int heightID;
            if ((heightID = world.func_72798_a(x, height, z)) != TContent.craftedSoil.field_71990_ca && heightID != TContent.slimeGrass.field_71990_ca || Block.field_71970_n[world.func_72798_a(x, height + 1, z)]) continue;
            ret = height + 1;
            break;
        } while (--height > 0);
        return ret;
    }

    void placeCanopy(World world, Random random, int xPos, int yPos, int zPos, int height) {
        for (int i = 0; i < 4; ++i) {
            this.placeDiamondLayer(world, xPos, yPos + height - i, zPos, i + 1);
        }
        this.func_76485_a(world, xPos + 4, yPos + height - 3, zPos, 0, 0);
        this.func_76485_a(world, xPos - 4, yPos + height - 3, zPos, 0, 0);
        this.func_76485_a(world, xPos, yPos + height - 3, zPos + 4, 0, 0);
        this.func_76485_a(world, xPos, yPos + height - 3, zPos - 4, 0, 0);
        this.func_76485_a(world, xPos + 1, yPos + height - 3, zPos + 1, 0, 0);
        this.func_76485_a(world, xPos + 1, yPos + height - 3, zPos - 1, 0, 0);
        this.func_76485_a(world, xPos - 1, yPos + height - 3, zPos + 1, 0, 0);
        this.func_76485_a(world, xPos - 1, yPos + height - 3, zPos - 1, 0, 0);
        this.func_76485_a(world, xPos + 3, yPos + height - 4, zPos, TContent.slimeLeaves.field_71990_ca, this.metaLeaves);
        this.func_76485_a(world, xPos - 3, yPos + height - 4, zPos, TContent.slimeLeaves.field_71990_ca, this.metaLeaves);
        this.func_76485_a(world, xPos, yPos + height - 4, zPos - 3, TContent.slimeLeaves.field_71990_ca, this.metaLeaves);
        this.func_76485_a(world, xPos, yPos + height - 4, zPos + 3, TContent.slimeLeaves.field_71990_ca, this.metaLeaves);
        this.func_76485_a(world, xPos + 2, yPos + height - 4, zPos + 2, TContent.slimeLeaves.field_71990_ca, this.metaLeaves);
        this.func_76485_a(world, xPos + 2, yPos + height - 4, zPos - 2, TContent.slimeLeaves.field_71990_ca, this.metaLeaves);
        this.func_76485_a(world, xPos - 2, yPos + height - 4, zPos + 2, TContent.slimeLeaves.field_71990_ca, this.metaLeaves);
        this.func_76485_a(world, xPos - 2, yPos + height - 4, zPos - 2, TContent.slimeLeaves.field_71990_ca, this.metaLeaves);
        this.func_76485_a(world, xPos + 3, yPos + height - 5, zPos, TContent.slimeLeaves.field_71990_ca, this.metaLeaves);
        this.func_76485_a(world, xPos - 3, yPos + height - 5, zPos, TContent.slimeLeaves.field_71990_ca, this.metaLeaves);
        this.func_76485_a(world, xPos, yPos + height - 5, zPos - 3, TContent.slimeLeaves.field_71990_ca, this.metaLeaves);
        this.func_76485_a(world, xPos, yPos + height - 5, zPos + 3, TContent.slimeLeaves.field_71990_ca, this.metaLeaves);
        this.func_76485_a(world, xPos + 2, yPos + height - 5, zPos + 2, TContent.slimeLeaves.field_71990_ca, this.metaLeaves);
        this.func_76485_a(world, xPos + 2, yPos + height - 5, zPos - 2, TContent.slimeLeaves.field_71990_ca, this.metaLeaves);
        this.func_76485_a(world, xPos - 2, yPos + height - 5, zPos + 2, TContent.slimeLeaves.field_71990_ca, this.metaLeaves);
        this.func_76485_a(world, xPos - 2, yPos + height - 5, zPos - 2, TContent.slimeLeaves.field_71990_ca, this.metaLeaves);
    }

    void placeDiamondLayer(World world, int xPos, int yPos, int zPos, int range) {
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (Math.abs(x) + Math.abs(z) > range) continue;
                this.func_76485_a(world, x + xPos, yPos, z + zPos, TContent.slimeLeaves.field_71990_ca, this.metaLeaves);
            }
        }
    }

    void placeTrunk(World world, int xPos, int yPos, int zPos, int height) {
        for (int localHeight = 0; localHeight < height; ++localHeight) {
            int blockID = world.func_72798_a(xPos, yPos + localHeight, zPos);
            Block block = Block.field_71973_m[blockID];
            if (blockID != 0 && block != null && !block.isLeaves(world, xPos, yPos + localHeight, zPos)) continue;
            this.func_76485_a(world, xPos, yPos + localHeight, zPos, TContent.slimeGel.field_71990_ca, this.metaWood);
        }
    }
}

