/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.awt.geom.Ellipse2D;
import java.util.Random;
import mods.tinker.tconstruct.common.TContent;
import mods.tinker.tconstruct.util.PHConstruct;
import mods.tinker.tconstruct.worldgen.PlantGen;
import mods.tinker.tconstruct.worldgen.SlimeTreeGen;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenerator;

public class SlimeIslandGen
extends WorldGenerator
implements IWorldGenerator {
    private int liquidBlock;
    private int gelMeta;
    int randomness = 2;
    Random random = new Random();
    int baseID;
    int topID;
    SlimeTreeGen trees;

    public SlimeIslandGen(int id, int meta) {
        this.baseID = TContent.craftedSoil.field_71990_ca;
        this.topID = TContent.slimeGrass.field_71990_ca;
        this.trees = new SlimeTreeGen(false, 5, 4, 1, 0);
        this.liquidBlock = id;
        this.gelMeta = meta;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if ((world.field_73011_w.field_76574_g == 0 || world.field_73011_w.field_76574_g >= 2) && random.nextInt(PHConstruct.islandRarity) == 0) {
            this.generateIsland(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    public void generateIsland(World world, Random rand, int xChunk, int zChunk) {
        int zPos;
        int yPos;
        int xPos;
        int y;
        int z;
        int x;
        int height;
        int xRange = this.random.nextInt(13) + 20;
        int yCenter = 100 + this.random.nextInt(41);
        int zRange = this.random.nextInt(13) + 20;
        int initialHeight = height = 12;
        Ellipse2D.Double ellipse = new Ellipse2D.Double(0.0, 0.0, xRange, zRange);
        for (x = 0; x <= xRange; ++x) {
            for (z = 0; z <= zRange; ++z) {
                for (y = 0; y <= height; ++y) {
                    if (!ellipse.contains(x, z)) continue;
                    world.func_72832_d(x + xChunk, y + yCenter, z + zChunk, this.baseID, 5, 0);
                }
            }
        }
        height = 8;
        for (x = 0; x <= xRange; ++x) {
            for (z = 0; z <= zRange; ++z) {
                for (y = 0; y >= -height; --y) {
                    xPos = x + xChunk;
                    yPos = y + yCenter + height;
                    zPos = z + zChunk;
                    if (world.func_72798_a(xPos - 1, yPos + 1, zPos) == this.baseID && world.func_72798_a(xPos + 1, yPos + 1, zPos) == this.baseID && world.func_72798_a(xPos, yPos + 1, zPos - 1) == this.baseID && world.func_72798_a(xPos - 1, yPos + 1, zPos + 1) == this.baseID && this.random.nextInt(100) > this.randomness) continue;
                    world.func_72832_d(xPos, yPos, zPos, 0, 0, 0);
                }
            }
        }
        height = 3;
        for (x = 0; x <= xRange; ++x) {
            for (z = 0; z <= zRange; ++z) {
                for (y = 1; y <= height; ++y) {
                    xPos = x + xChunk;
                    yPos = y + yCenter + initialHeight - height + 1;
                    zPos = z + zChunk;
                    if (world.func_72798_a(xPos - 1, yPos - 1, zPos) == this.baseID && world.func_72798_a(xPos + 1, yPos - 1, zPos) == this.baseID && world.func_72798_a(xPos, yPos - 1, zPos - 1) == this.baseID && world.func_72798_a(xPos - 1, yPos - 1, zPos + 1) == this.baseID) continue;
                    world.func_72832_d(xPos, yPos, zPos, 0, 0, 0);
                }
            }
        }
        for (x = 0; x <= xRange; ++x) {
            for (z = 0; z <= zRange; ++z) {
                for (y = 0; y <= height; ++y) {
                    Block block;
                    xPos = x + xChunk;
                    yPos = y + yCenter + initialHeight - height;
                    zPos = z + zChunk;
                    if (world.func_72798_a(xPos, yPos, zPos) != this.baseID || (block = Block.field_71973_m[world.func_72798_a(xPos, yPos + 1, zPos)]) != null && !block.isAirBlock(world, xPos, yPos + 1, zPos)) continue;
                    world.func_72832_d(xPos, yPos, zPos, this.topID, 0, 0);
                }
            }
        }
        this.generateSlimePool(world, rand, xChunk + xRange / 2, yCenter + initialHeight, zChunk + zRange / 2);
        PlantGen tallGrass = new PlantGen(TContent.slimeTallGrass.field_71990_ca, 0, 128, xRange, 1, zRange, false);
        tallGrass.func_76484_a(world, rand, xChunk, yCenter + initialHeight + 1, zChunk);
        for (int i = 0; i < 3; ++i) {
            this.trees.func_76484_a(world, this.random, xChunk + this.random.nextInt(xRange), yCenter + initialHeight + 3, zChunk + this.random.nextInt(zRange));
        }
    }

    public void generateSlimePool(World world, Random rand, int x, int y, int z) {
        this.func_76484_a(world, rand, x, y, z);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int zPos;
        int xPos;
        x -= 8;
        z -= 8;
        y -= 4;
        boolean[] validLocations = new boolean[2048];
        int var7 = rand.nextInt(4) + 4;
        for (xPos = 0; xPos < var7; ++xPos) {
            double noise1 = rand.nextDouble() * 6.0 + 3.0;
            double noise2 = rand.nextDouble() * 4.0 + 2.0;
            double noise3 = rand.nextDouble() * 6.0 + 3.0;
            double noise4 = rand.nextDouble() * (16.0 - noise1 - 2.0) + 1.0 + noise1 / 2.0;
            double noise5 = rand.nextDouble() * (8.0 - noise2 - 4.0) + 2.0 + noise2 / 2.0;
            double noise6 = rand.nextDouble() * (16.0 - noise3 - 2.0) + 1.0 + noise3 / 2.0;
            for (int xIter = 1; xIter < 15; ++xIter) {
                for (int zIter = 1; zIter < 15; ++zIter) {
                    for (int yIter = 1; yIter < 7; ++yIter) {
                        double var24 = ((double)xIter - noise4) / (noise1 / 2.0);
                        double var26 = ((double)yIter - noise5) / (noise2 / 2.0);
                        double var28 = ((double)zIter - noise6) / (noise3 / 2.0);
                        double validSpot = var24 * var24 + var26 * var26 + var28 * var28;
                        if (!(validSpot < 1.0)) continue;
                        validLocations[(xIter * 16 + zIter) * 8 + yIter] = true;
                    }
                }
            }
        }
        for (xPos = 0; xPos < 16; ++xPos) {
            for (zPos = 0; zPos < 16; ++zPos) {
                for (int yPos = 0; yPos < 8; ++yPos) {
                    boolean var33;
                    boolean bl = var33 = !validLocations[(xPos * 16 + zPos) * 8 + yPos] && (xPos < 15 && validLocations[((xPos + 1) * 16 + zPos) * 8 + yPos] || xPos > 0 && validLocations[((xPos - 1) * 16 + zPos) * 8 + yPos] || zPos < 15 && validLocations[(xPos * 16 + zPos + 1) * 8 + yPos] || zPos > 0 && validLocations[(xPos * 16 + (zPos - 1)) * 8 + yPos] || yPos < 7 && validLocations[(xPos * 16 + zPos) * 8 + yPos + 1] || yPos > 0 && validLocations[(xPos * 16 + zPos) * 8 + (yPos - 1)]);
                    if (!var33) continue;
                    Material var12 = world.func_72803_f(x + xPos, y + yPos, z + zPos);
                    if (yPos >= 4 && var12.func_76224_d()) {
                        return false;
                    }
                    if (yPos >= 4 || var12.func_76220_a() || world.func_72798_a(x + xPos, y + yPos, z + zPos) == this.liquidBlock) continue;
                    return false;
                }
            }
        }
        for (xPos = 0; xPos < 16; ++xPos) {
            for (zPos = 0; zPos < 16; ++zPos) {
                for (int yPos = 0; yPos < 8; ++yPos) {
                    if (!validLocations[(xPos * 16 + zPos) * 8 + yPos]) continue;
                    world.func_94575_c(x + xPos, y + yPos, z + zPos, yPos >= 4 ? 0 : this.liquidBlock);
                }
            }
        }
        for (xPos = 0; xPos < 16; ++xPos) {
            for (zPos = 0; zPos < 16; ++zPos) {
                for (int yPos = 4; yPos < 8; ++yPos) {
                    if (!validLocations[(xPos * 16 + zPos) * 8 + yPos] || world.func_72798_a(x + xPos, y + yPos - 1, z + zPos) != this.baseID || world.func_72972_b(EnumSkyBlock.Sky, x + xPos, y + yPos, z + zPos) <= 0) continue;
                    world.func_72832_d(x + xPos, y + yPos - 1, z + zPos, this.topID, 0, 0);
                }
            }
        }
        if (Block.field_71973_m[this.liquidBlock].field_72018_cp == Material.field_76244_g) {
            for (xPos = 0; xPos < 16; ++xPos) {
                for (zPos = 0; zPos < 16; ++zPos) {
                    for (int yPos = 0; yPos < 8; ++yPos) {
                        boolean var33;
                        boolean bl = var33 = !validLocations[(xPos * 16 + zPos) * 8 + yPos] && (xPos < 15 && validLocations[((xPos + 1) * 16 + zPos) * 8 + yPos] || xPos > 0 && validLocations[((xPos - 1) * 16 + zPos) * 8 + yPos] || zPos < 15 && validLocations[(xPos * 16 + zPos + 1) * 8 + yPos] || zPos > 0 && validLocations[(xPos * 16 + (zPos - 1)) * 8 + yPos] || yPos < 7 && validLocations[(xPos * 16 + zPos) * 8 + yPos + 1] || yPos > 0 && validLocations[(xPos * 16 + zPos) * 8 + (yPos - 1)]);
                        if (!var33 || yPos >= 4 && rand.nextInt(2) == 0 || !world.func_72803_f(x + xPos, y + yPos, z + zPos).func_76220_a() || world.func_72803_f(x + xPos, y + yPos + 1, z + zPos) == Material.field_76244_g) continue;
                        world.func_72832_d(x + xPos, y + yPos, z + zPos, TContent.slimeGel.field_71990_ca, this.gelMeta, 2);
                    }
                }
            }
        }
        return true;
    }
}

