/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class OreberryBushGen
extends WorldGenerator {
    private int blockID;
    private int metadata;
    int chance;
    private int[] replaceBlocks;

    public OreberryBushGen(Block block, int meta, int chance) {
        this(block.field_71990_ca, meta, chance, Block.field_71981_t.field_71990_ca, Block.field_71980_u.field_71990_ca, Block.field_71979_v.field_71990_ca, Block.field_71943_B.field_71990_ca, Block.field_71939_E.field_71990_ca, Block.field_71940_F.field_71990_ca, Block.field_72037_aS.field_71990_ca);
    }

    public OreberryBushGen(int blockID, int meta, int chance, int ... target) {
        this.blockID = blockID;
        this.metadata = meta;
        this.chance = chance;
        this.replaceBlocks = target;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        int type = random.nextInt(this.chance);
        if (type == 11) {
            this.generateMediumNode(world, random, x, y, z);
        } else if (type >= 5) {
            this.generateSmallNode(world, random, x, y, z);
        } else {
            this.generateTinyNode(world, random, x, y, z);
        }
        return true;
    }

    public void generateMediumNode(World world, Random random, int x, int y, int z) {
        for (int xPos = -1; xPos <= 1; ++xPos) {
            for (int yPos = -1; yPos <= 1; ++yPos) {
                for (int zPos = -1; zPos <= 1; ++zPos) {
                    if (random.nextInt(4) != 0) continue;
                    this.generateBerryBlock(world, x + xPos, y + yPos, z + zPos, random);
                }
            }
        }
        this.generateSmallNode(world, random, x, y, z);
    }

    public void generateSmallNode(World world, Random random, int x, int y, int z) {
        this.generateBerryBlock(world, x, y, z, random);
        if (random.nextBoolean()) {
            this.generateBerryBlock(world, x + 1, y, z, random);
        }
        if (random.nextBoolean()) {
            this.generateBerryBlock(world, x - 1, y, z, random);
        }
        if (random.nextBoolean()) {
            this.generateBerryBlock(world, x, y, z + 1, random);
        }
        if (random.nextBoolean()) {
            this.generateBerryBlock(world, x, y, z - 1, random);
        }
        if (random.nextBoolean()) {
            this.generateBerryBlock(world, x, y + 1, z, random);
        }
        if (random.nextBoolean()) {
            this.generateBerryBlock(world, x, y + 1, z, random);
        }
    }

    public void generateTinyNode(World world, Random random, int x, int y, int z) {
        this.generateBerryBlock(world, x, y, z, random);
        if (random.nextInt(4) == 0) {
            this.generateBerryBlock(world, x + 1, y, z, random);
        }
        if (random.nextInt(4) == 0) {
            this.generateBerryBlock(world, x - 1, y, z, random);
        }
        if (random.nextInt(4) == 0) {
            this.generateBerryBlock(world, x, y, z + 1, random);
        }
        if (random.nextInt(4) == 0) {
            this.generateBerryBlock(world, x, y, z - 1, random);
        }
        if (random.nextInt(4) == 0) {
            this.generateBerryBlock(world, x, y + 1, z, random);
        }
        if (random.nextInt(4) == 0) {
            this.generateBerryBlock(world, x, y + 1, z, random);
        }
    }

    void generateBerryBlock(World world, int x, int y, int z, Random random) {
        Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        if (block == null || block != Block.field_72104_bI && !Block.field_71970_n[world.func_72798_a(x, y, z)]) {
            world.func_72832_d(x, y, z, this.blockID, this.metadata, 2);
        } else {
            for (int iter = 0; iter < this.replaceBlocks.length; ++iter) {
                if (!block.isGenMineableReplaceable(world, x, y, z, this.replaceBlocks[iter])) continue;
                world.func_72832_d(x, y, z, this.blockID, this.metadata, 2);
                break;
            }
        }
    }
}

