/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.items.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mods.tinker.tconstruct.common.TContent;
import mods.tinker.tconstruct.entity.projectile.ArrowEntity;
import mods.tinker.tconstruct.library.crafting.ToolBuilder;
import mods.tinker.tconstruct.library.tools.AbilityHelper;
import mods.tinker.tconstruct.library.tools.ToolCore;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;

public abstract class BowBase
extends ToolCore {
    public Icon arrow1;
    public Icon arrow2;
    public Icon arrow3;
    public HashMap headIcons1 = new HashMap();
    public HashMap handleIcons1 = new HashMap();
    public HashMap accessoryIcons1 = new HashMap();
    public HashMap extraIcons1 = new HashMap();
    public HashMap effectIcons1 = new HashMap();
    public HashMap headIcons2 = new HashMap();
    public HashMap handleIcons2 = new HashMap();
    public HashMap accessoryIcons2 = new HashMap();
    public HashMap extraIcons2 = new HashMap();
    public HashMap effectIcons2 = new HashMap();
    public HashMap headIcons3 = new HashMap();
    public HashMap handleIcons3 = new HashMap();
    public HashMap accessoryIcons3 = new HashMap();
    public HashMap extraIcons3 = new HashMap();
    public HashMap effectIcons3 = new HashMap();

    public BowBase(int itemID) {
        super(itemID, 0);
    }

    @Override
    public int durabilityTypeAccessory() {
        return 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 10;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int useRemaining) {
        int time = this.func_77626_a(stack) - useRemaining;
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, time);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        time = event.charge;
        boolean creative = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)stack) > 0;
        int slotID = this.getInventorySlotContainItem(TContent.arrow.field_77779_bT, player.field_71071_by);
        int arrowID = this.getInventorySlotContainItem(Item.field_77704_l.field_77779_bT, player.field_71071_by);
        boolean arrowState = false;
        ItemStack tinkerArrow = null;
        if (slotID != -1) {
            tinkerArrow = player.field_71071_by.func_70301_a(slotID);
        }
        if (creative || tinkerArrow != null || arrowID != -1) {
            int var9;
            NBTTagCompound toolTag = stack.func_77978_p().func_74775_l("InfiTool");
            float drawTime = toolTag.func_74762_e("DrawSpeed");
            float flightSpeed = toolTag.func_74760_g("FlightSpeed");
            float speedBase = (float)time / drawTime;
            if ((double)(speedBase = (speedBase * speedBase + speedBase * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (speedBase > flightSpeed) {
                speedBase = flightSpeed;
            }
            EntityArrow arrowEntity = null;
            if (slotID != -1 && (arrowID == -1 || slotID < arrowID)) {
                ItemStack arrowStack = tinkerArrow.func_77946_l();
                arrowStack.field_77994_a = 1;
                arrowEntity = new ArrowEntity(world, (EntityLiving)player, speedBase * 2.0f, arrowStack);
            } else {
                arrowEntity = new EntityArrow(world, (EntityLiving)player, speedBase * 2.0f);
            }
            if (speedBase >= 1.0f) {
                arrowEntity.func_70243_d(true);
            }
            if ((var9 = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack)) > 0) {
                arrowEntity.func_70239_b(arrowEntity.func_70242_d() + (double)var9 * 0.5 + 0.5);
            }
            int var10 = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)stack);
            if (slotID != -1 && (arrowID == -1 || slotID < arrowID)) {
                ((ArrowEntity)arrowEntity).setKnockbackModStrength(toolTag.func_74760_g("Knockback"));
            }
            if (var10 > 0) {
                arrowEntity.func_70240_a(var10);
            }
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)stack) > 0) {
                arrowEntity.func_70015_d(100);
            }
            int reinforced = 0;
            if (toolTag.func_74764_b("Unbreaking")) {
                reinforced = toolTag.func_74762_e("Unbreaking");
            }
            if (this.random.nextInt(10) < 10 - reinforced) {
                AbilityHelper.damageTool(stack, 1, (EntityLiving)player, false);
            }
            world.func_72956_a((Entity)player, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + speedBase * 0.5f);
            if (creative) {
                arrowEntity.field_70251_a = 2;
            } else if (slotID != -1 && (arrowID == -1 || slotID < arrowID)) {
                player.field_71071_by.func_70435_d(TContent.arrow.field_77779_bT);
            } else {
                player.field_71071_by.func_70435_d(Item.field_77704_l.field_77779_bT);
            }
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)arrowEntity);
            }
        }
    }

    int getInventorySlotContainItem(int itemID, InventoryPlayer inventory) {
        for (int j = 0; j < inventory.field_70462_a.length; ++j) {
            if (inventory.field_70462_a[j] == null || inventory.field_70462_a[j].field_77993_c != itemID) continue;
            return j;
        }
        return -1;
    }

    public ItemStack onFoodEaten(ItemStack stack, World par2World, EntityPlayer par3EntityPlayer) {
        return stack;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    public ItemStack func_77659_a(ItemStack stack, World par2World, EntityPlayer player) {
        NBTTagCompound toolTag;
        if (stack.func_77942_o() && !(toolTag = stack.func_77978_p().func_74775_l("InfiTool")).func_74767_n("Broken")) {
            ArrowNockEvent event = new ArrowNockEvent(player, stack);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return event.result;
            }
            if (player.field_71075_bZ.field_75098_d || player.field_71071_by.func_70450_e(Item.field_77704_l.field_77779_bT) || player.field_71071_by.func_70450_e(TContent.arrow.field_77779_bT)) {
                player.func_71008_a(stack, this.func_77626_a(stack));
            }
        }
        return stack;
    }

    @Override
    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float clickX, float clickY, float clickZ) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return false;
    }

    @Override
    public void func_94581_a(IconRegister iconRegister) {
        super.func_94581_a(iconRegister);
        this.headIcons1.clear();
        this.handleIcons1.clear();
        this.accessoryIcons1.clear();
        this.extraIcons1.clear();
        this.effectIcons1.clear();
        for (Map.Entry pairs : this.headStrings.entrySet()) {
            this.headIcons1.put((Integer)pairs.getKey(), iconRegister.func_94245_a((String)pairs.getValue() + "_1"));
        }
        for (Map.Entry pairs : this.handleStrings.entrySet()) {
            this.handleIcons1.put((Integer)pairs.getKey(), iconRegister.func_94245_a((String)pairs.getValue() + "_1"));
        }
        if (this.getPartAmount() > 2) {
            for (Map.Entry pairs : this.accessoryStrings.entrySet()) {
                this.accessoryIcons1.put((Integer)pairs.getKey(), iconRegister.func_94245_a((String)pairs.getValue() + "_1"));
            }
        }
        if (this.getPartAmount() > 3) {
            for (Map.Entry pairs : this.extraStrings.entrySet()) {
                this.extraIcons1.put((Integer)pairs.getKey(), iconRegister.func_94245_a((String)pairs.getValue() + "_1"));
            }
        }
        for (Map.Entry pairs : this.effectStrings.entrySet()) {
            this.effectIcons1.put((Integer)pairs.getKey(), iconRegister.func_94245_a((String)pairs.getValue() + "_1"));
        }
        this.headIcons2.clear();
        this.handleIcons2.clear();
        this.accessoryIcons2.clear();
        this.extraIcons2.clear();
        this.effectIcons2.clear();
        for (Map.Entry pairs : this.headStrings.entrySet()) {
            this.headIcons2.put((Integer)pairs.getKey(), iconRegister.func_94245_a((String)pairs.getValue() + "_2"));
        }
        for (Map.Entry pairs : this.handleStrings.entrySet()) {
            this.handleIcons2.put((Integer)pairs.getKey(), iconRegister.func_94245_a((String)pairs.getValue() + "_2"));
        }
        if (this.getPartAmount() > 2) {
            for (Map.Entry pairs : this.accessoryStrings.entrySet()) {
                this.accessoryIcons2.put((Integer)pairs.getKey(), iconRegister.func_94245_a((String)pairs.getValue() + "_2"));
            }
        }
        if (this.getPartAmount() > 3) {
            for (Map.Entry pairs : this.extraStrings.entrySet()) {
                this.extraIcons2.put((Integer)pairs.getKey(), iconRegister.func_94245_a((String)pairs.getValue() + "_2"));
            }
        }
        for (Map.Entry pairs : this.effectStrings.entrySet()) {
            this.effectIcons2.put((Integer)pairs.getKey(), iconRegister.func_94245_a((String)pairs.getValue() + "_2"));
        }
        this.headIcons3.clear();
        this.handleIcons3.clear();
        this.accessoryIcons3.clear();
        this.extraIcons3.clear();
        this.effectIcons3.clear();
        for (Map.Entry pairs : this.headStrings.entrySet()) {
            this.headIcons3.put((Integer)pairs.getKey(), iconRegister.func_94245_a((String)pairs.getValue() + "_3"));
        }
        for (Map.Entry pairs : this.handleStrings.entrySet()) {
            this.handleIcons3.put((Integer)pairs.getKey(), iconRegister.func_94245_a((String)pairs.getValue() + "_3"));
        }
        if (this.getPartAmount() > 2) {
            for (Map.Entry pairs : this.accessoryStrings.entrySet()) {
                this.accessoryIcons3.put((Integer)pairs.getKey(), iconRegister.func_94245_a((String)pairs.getValue() + "_3"));
            }
        }
        if (this.getPartAmount() > 3) {
            for (Map.Entry pairs : this.extraStrings.entrySet()) {
                this.extraIcons3.put((Integer)pairs.getKey(), iconRegister.func_94245_a((String)pairs.getValue() + "_3"));
            }
        }
        for (Map.Entry pairs : this.effectStrings.entrySet()) {
            this.effectIcons3.put((Integer)pairs.getKey(), iconRegister.func_94245_a((String)pairs.getValue() + "_3"));
        }
        this.registerArrows(iconRegister);
    }

    void registerArrows(IconRegister iconRegister) {
        this.arrow1 = iconRegister.func_94245_a("tinker:" + this.getDefaultFolder() + "/arrow_1");
        this.arrow2 = iconRegister.func_94245_a("tinker:" + this.getDefaultFolder() + "/arrow_2");
        this.arrow3 = iconRegister.func_94245_a("tinker:" + this.getDefaultFolder() + "/arrow_3");
    }

    @Override
    public Icon getIcon(ItemStack stack, int renderPass) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            tags = stack.func_77978_p().func_74775_l("InfiTool");
            if (renderPass < this.getPartAmount()) {
                if (renderPass == 0) {
                    if (tags.func_74767_n("Broken")) {
                        return (Icon)this.brokenIcons.get(tags.func_74762_e("RenderHandle"));
                    }
                    return (Icon)this.handleIcons.get(tags.func_74762_e("RenderHandle"));
                }
                if (renderPass == 1) {
                    return (Icon)this.headIcons.get(tags.func_74762_e("RenderHead"));
                }
                if (renderPass == 2) {
                    return (Icon)this.accessoryIcons.get(tags.func_74762_e("RenderAccessory"));
                }
                if (renderPass == 3) {
                    return (Icon)this.extraIcons.get(tags.func_74762_e("RenderExtra"));
                }
            } else if (renderPass == this.getPartAmount()) {
                if (tags.func_74764_b("Effect1")) {
                    return (Icon)this.effectIcons.get(tags.func_74762_e("Effect1"));
                }
            } else if (renderPass == this.getPartAmount() + 1) {
                if (tags.func_74764_b("Effect2")) {
                    return (Icon)this.effectIcons.get(tags.func_74762_e("Effect2"));
                }
            } else if (renderPass == this.getPartAmount() + 2) {
                if (tags.func_74764_b("Effect3")) {
                    return (Icon)this.effectIcons.get(tags.func_74762_e("Effect3"));
                }
            } else if (renderPass == this.getPartAmount() + 3) {
                if (tags.func_74764_b("Effect4")) {
                    return (Icon)this.effectIcons.get(tags.func_74762_e("Effect4"));
                }
            } else if (renderPass == this.getPartAmount() + 4) {
                if (tags.func_74764_b("Effect5")) {
                    return (Icon)this.effectIcons.get(tags.func_74762_e("Effect5"));
                }
            } else if (renderPass == this.getPartAmount() + 5 && tags.func_74764_b("Effect6")) {
                return (Icon)this.effectIcons.get(tags.func_74762_e("Effect6"));
            }
            return blankSprite;
        }
        return emptyIcon;
    }

    @Override
    public void registerPartPaths(int index, String[] location) {
        this.headStrings.put(index, location[0]);
        if (location.length > 3) {
            this.accessoryStrings.put(index, location[3]);
        }
        if (location.length > 4) {
            this.extraStrings.put(index, location[4]);
        }
    }

    @Override
    public void registerAlternatePartPaths(int index, String[] location) {
        this.brokenPartStrings.put(index, location[1]);
        this.handleStrings.put(index, location[2]);
    }

    public Icon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        int useTime = stack.func_77988_m() - useRemaining;
        if (!stack.func_77942_o()) {
            return emptyIcon;
        }
        NBTTagCompound toolTag = stack.func_77978_p().func_74775_l("InfiTool");
        int drawTime = toolTag.func_74762_e("DrawSpeed");
        float flightSpeed = toolTag.func_74760_g("FlightSpeed");
        if (useTime >= (drawTime = (int)((float)drawTime * flightSpeed)) - 2) {
            return this.getIcon3(stack, renderPass);
        }
        if (useTime >= drawTime * 2 / 3) {
            return this.getIcon2(stack, renderPass);
        }
        return this.getIcon1(stack, renderPass);
    }

    public Icon getIcon1(ItemStack stack, int renderPass) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            tags = stack.func_77978_p().func_74775_l("InfiTool");
            if (renderPass < this.getPartAmount()) {
                if (renderPass == 0) {
                    return (Icon)this.handleIcons1.get(tags.func_74762_e("RenderHandle"));
                }
                if (renderPass == 1) {
                    return (Icon)this.headIcons1.get(tags.func_74762_e("RenderHead"));
                }
                if (renderPass == 2) {
                    return (Icon)this.accessoryIcons1.get(tags.func_74762_e("RenderAccessory"));
                }
                if (renderPass == 3) {
                    return (Icon)this.extraIcons1.get(tags.func_74762_e("RenderExtra"));
                }
            } else if (renderPass == this.getPartAmount()) {
                if (tags.func_74764_b("Effect1")) {
                    return (Icon)this.effectIcons1.get(tags.func_74762_e("Effect1"));
                }
            } else if (renderPass == this.getPartAmount() + 1) {
                if (tags.func_74764_b("Effect2")) {
                    return (Icon)this.effectIcons1.get(tags.func_74762_e("Effect2"));
                }
            } else if (renderPass == this.getPartAmount() + 2) {
                if (tags.func_74764_b("Effect3")) {
                    return (Icon)this.effectIcons1.get(tags.func_74762_e("Effect3"));
                }
            } else if (renderPass == this.getPartAmount() + 3) {
                if (tags.func_74764_b("Effect4")) {
                    return (Icon)this.effectIcons1.get(tags.func_74762_e("Effect4"));
                }
            } else if (renderPass == this.getPartAmount() + 4) {
                if (tags.func_74764_b("Effect5")) {
                    return (Icon)this.effectIcons1.get(tags.func_74762_e("Effect5"));
                }
            } else if (renderPass == this.getPartAmount() + 5) {
                if (tags.func_74764_b("Effect6")) {
                    return (Icon)this.effectIcons1.get(tags.func_74762_e("Effect6"));
                }
            } else {
                return this.arrow1;
            }
            return blankSprite;
        }
        return emptyIcon;
    }

    public Icon getIcon2(ItemStack stack, int renderPass) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            tags = stack.func_77978_p().func_74775_l("InfiTool");
            if (renderPass < this.getPartAmount()) {
                if (renderPass == 0) {
                    return (Icon)this.handleIcons2.get(tags.func_74762_e("RenderHandle"));
                }
                if (renderPass == 1) {
                    return (Icon)this.headIcons2.get(tags.func_74762_e("RenderHead"));
                }
                if (renderPass == 2) {
                    return (Icon)this.accessoryIcons2.get(tags.func_74762_e("RenderAccessory"));
                }
                if (renderPass == 3) {
                    return (Icon)this.extraIcons2.get(tags.func_74762_e("RenderExtra"));
                }
            } else if (renderPass == this.getPartAmount()) {
                if (tags.func_74764_b("Effect1")) {
                    return (Icon)this.effectIcons2.get(tags.func_74762_e("Effect1"));
                }
            } else if (renderPass == this.getPartAmount() + 1) {
                if (tags.func_74764_b("Effect2")) {
                    return (Icon)this.effectIcons2.get(tags.func_74762_e("Effect2"));
                }
            } else if (renderPass == this.getPartAmount() + 2) {
                if (tags.func_74764_b("Effect3")) {
                    return (Icon)this.effectIcons2.get(tags.func_74762_e("Effect3"));
                }
            } else if (renderPass == this.getPartAmount() + 3) {
                if (tags.func_74764_b("Effect4")) {
                    return (Icon)this.effectIcons2.get(tags.func_74762_e("Effect4"));
                }
            } else if (renderPass == this.getPartAmount() + 4) {
                if (tags.func_74764_b("Effect5")) {
                    return (Icon)this.effectIcons2.get(tags.func_74762_e("Effect5"));
                }
            } else if (renderPass == this.getPartAmount() + 5) {
                if (tags.func_74764_b("Effect6")) {
                    return (Icon)this.effectIcons2.get(tags.func_74762_e("Effect6"));
                }
            } else {
                return this.arrow2;
            }
            return blankSprite;
        }
        return emptyIcon;
    }

    public Icon getIcon3(ItemStack stack, int renderPass) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            tags = stack.func_77978_p().func_74775_l("InfiTool");
            if (renderPass < this.getPartAmount()) {
                if (renderPass == 0) {
                    return (Icon)this.handleIcons3.get(tags.func_74762_e("RenderHandle"));
                }
                if (renderPass == 1) {
                    return (Icon)this.headIcons3.get(tags.func_74762_e("RenderHead"));
                }
                if (renderPass == 2) {
                    return (Icon)this.accessoryIcons3.get(tags.func_74762_e("RenderAccessory"));
                }
                if (renderPass == 3) {
                    return (Icon)this.extraIcons3.get(tags.func_74762_e("RenderExtra"));
                }
            } else if (renderPass == this.getPartAmount()) {
                if (tags.func_74764_b("Effect1")) {
                    return (Icon)this.effectIcons3.get(tags.func_74762_e("Effect1"));
                }
            } else if (renderPass == this.getPartAmount() + 1) {
                if (tags.func_74764_b("Effect2")) {
                    return (Icon)this.effectIcons3.get(tags.func_74762_e("Effect2"));
                }
            } else if (renderPass == this.getPartAmount() + 2) {
                if (tags.func_74764_b("Effect3")) {
                    return (Icon)this.effectIcons3.get(tags.func_74762_e("Effect3"));
                }
            } else if (renderPass == this.getPartAmount() + 3) {
                if (tags.func_74764_b("Effect4")) {
                    return (Icon)this.effectIcons3.get(tags.func_74762_e("Effect4"));
                }
            } else if (renderPass == this.getPartAmount() + 4) {
                if (tags.func_74764_b("Effect5")) {
                    return (Icon)this.effectIcons3.get(tags.func_74762_e("Effect5"));
                }
            } else if (renderPass == this.getPartAmount() + 5) {
                if (tags.func_74764_b("Effect6")) {
                    return (Icon)this.effectIcons3.get(tags.func_74762_e("Effect6"));
                }
            } else {
                return this.arrow3;
            }
            return blankSprite;
        }
        return emptyIcon;
    }

    @Override
    public void buildTool(int id, String name, List list) {
        Item accessory = this.getAccessoryItem();
        ItemStack accessoryStack = accessory != null ? new ItemStack(this.getAccessoryItem(), 1, id) : null;
        Item extra = this.getExtraItem();
        ItemStack extraStack = extra != null ? new ItemStack(this.getExtraItem(), 1, id) : null;
        ItemStack tool = ToolBuilder.instance.buildTool(new ItemStack(this.getHeadItem(), 1, id), new ItemStack(this.getHandleItem(), 1, 0), accessoryStack, extraStack, name + this.getToolName());
        if (tool == null) {
            System.out.println("Creative builder failed tool for " + name + this.getToolName());
            System.out.println("Make sure you do not have item ID conflicts");
        } else {
            tool.func_77978_p().func_74775_l("InfiTool").func_74757_a("Built", true);
            list.add(tool);
        }
    }
}

