/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.entity.genetics;

import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;

public class Trait {
    protected int[] alleles;
    static Random rand = new Random();
    String traitName;

    public Trait(String name, NBTTagCompound tags) {
        this.traitName = name;
        this.loadFromNBT(tags);
    }

    public Trait(int[] alleles) {
        this.alleles = alleles;
    }

    public Trait(int minimum, int maximum, int quantity, boolean bellCurve) {
        this.alleles = new int[quantity];
        if (bellCurve) {
            for (int i = 0; i < this.alleles.length; ++i) {
                int value;
                this.alleles[i] = value = (int)(rand.nextGaussian() * (double)(maximum + 1) + (double)minimum);
            }
        } else {
            for (int i = 0; i < this.alleles.length; ++i) {
                int value;
                this.alleles[i] = value = rand.nextInt(maximum + 1) + minimum;
            }
        }
    }

    public Trait setName(String name) {
        this.traitName = name;
        return this;
    }

    public int getAverage() {
        int average = 0;
        if (this.alleles.length > 0) {
            for (int i = 0; i < this.alleles.length; i = (int)((byte)(i + 1))) {
                average += this.alleles[i];
            }
            average /= this.alleles.length;
        }
        return average;
    }

    public Trait breed(byte[] other, float mutationChance, float mutationVariance) {
        int[] newAlleles = this.breedNumbers(other, mutationChance, mutationVariance);
        Trait trait = new Trait(newAlleles).setName(this.traitName);
        return trait;
    }

    public int[] breedNumbers(byte[] other, float mutationChance, float mutationVariance) {
        assert (this.alleles.length == other.length) : "Complete trait arrays need to have identical length";
        int[] result = new int[this.alleles.length > other.length ? this.alleles.length : other.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = rand.nextFloat() < mutationChance ? this.mutate(this.alleles[i], other[i], mutationVariance) : (rand.nextBoolean() ? this.alleles[i] : other[i]);
        }
        return result;
    }

    protected int mutate(int allele, int other, float variance) {
        int mutator = rand.nextBoolean() ? allele : other;
        double bellcurve = rand.nextGaussian();
        double offset = (double)variance * bellcurve;
        mutator = (double)mutator + (offset -= offset / 2.0) < 0.0 ? 0 : ((double)mutator + offset > 2.147483647E9 ? Integer.MAX_VALUE : (int)((double)mutator + offset));
        return mutator;
    }

    public void saveToNBT(NBTTagCompound tags) {
        tags.func_74783_a(this.traitName + ".Alleles", this.alleles);
    }

    public void loadFromNBT(NBTTagCompound tags) {
        this.alleles = tags.func_74759_k(this.traitName + ".Alleles");
    }
}

