/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.tinker.tconstruct.TConstruct;
import mods.tinker.tconstruct.common.TContent;
import mods.tinker.tconstruct.common.TProxyCommon;
import mods.tinker.tconstruct.entity.GolemBase;
import mods.tinker.tconstruct.entity.ai.AIFellTree;
import mods.tinker.tconstruct.entity.ai.AIFollowOwner;
import mods.tinker.tconstruct.entity.ai.AIMakeBuilding;
import mods.tinker.tconstruct.entity.ai.AISwim;
import mods.tinker.tconstruct.entity.genetics.Trait;
import mods.tinker.tconstruct.library.util.CoordTuple;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class Gardeslime
extends GolemBase {
    Trait strength;
    Trait agility;
    Trait capacity;
    Trait intelligence;
    public CoordTuple home;
    public boolean completedHome;
    public int[][][] buildingArray;
    public int[][][] metaArray;

    public Gardeslime(World world) {
        super(world);
        this.field_70750_az = "/mods/tinker/textures/mob/googirl.png";
        this.func_70105_a(0.375f, 0.875f);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AISwim(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AIMakeBuilding(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AIFellTree(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new AIFollowOwner(this));
        this.strength = new Trait(10, 30, 4, true).setName("Strength");
        this.agility = new Trait(10, 30, 6, true).setName("Agility");
        this.capacity = new Trait(10, 30, 1, true).setName("Capacity");
        this.intelligence = new Trait(10, 30, 8, true).setName("Intelligence");
        this.decideMaterials();
    }

    public void setHome(int x, int y, int z) {
        this.home = new CoordTuple(x, y, z);
    }

    public boolean hasMaterials() {
        return true;
    }

    public void decideMaterials() {
        this.buildingArray = new int[3][2][3];
        this.metaArray = new int[3][2][3];
        for (int x = 0; x < 3; ++x) {
            for (int z = 0; z < 3; ++z) {
                this.buildingArray[x][0][z] = Block.field_71988_x.field_71990_ca;
                this.metaArray[x][0][z] = 1;
            }
        }
        this.buildingArray[1][1][1] = TContent.craftingSlabWood.field_71990_ca;
    }

    @Override
    public void setupInventory() {
        this.inventory = new ItemStack[14];
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 1.0f;
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (player.func_70093_af()) {
            if (!this.field_70170_p.field_72995_K) {
                player.openGui((Object)TConstruct.instance, TProxyCommon.miniGardyGui, this.field_70170_p, this.field_70157_k, 0, 0);
            }
            return true;
        }
        ItemStack stack = this.func_70694_bm();
        if (stack == null) {
            ItemStack playerStack = player.func_71045_bC();
            if (playerStack != null) {
                this.func_70062_b(0, playerStack.func_77946_l());
                player.func_71028_bD();
            }
        } else if (player.field_71071_by.func_70441_a(stack.func_77946_l())) {
            this.field_70170_p.func_72956_a((Entity)player, "random.pop", 0.3f, ((field_70146_Z.nextFloat() - field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.func_70062_b(0, null);
        }
        return true;
    }

    @Override
    public void func_70014_b(NBTTagCompound tags) {
        super.func_70014_b(tags);
        NBTTagCompound traits = new NBTTagCompound();
        this.strength.saveToNBT(traits);
        this.agility.saveToNBT(traits);
        this.capacity.saveToNBT(traits);
        this.intelligence.saveToNBT(traits);
        tags.func_74766_a("Traits", traits);
        tags.func_74783_a("HomeCoord", new int[]{this.home.x, this.home.y, this.home.z});
    }

    @Override
    public void func_70037_a(NBTTagCompound tags) {
        int[] coord;
        super.func_70037_a(tags);
        NBTTagCompound traits = tags.func_74775_l("Traits");
        if (traits != null) {
            this.strength = new Trait("Strength", traits);
            this.agility = new Trait("Agility", traits);
            this.capacity = new Trait("Capacity", traits);
            this.intelligence = new Trait("Intelligence", traits);
        }
        if ((coord = tags.func_74759_k("HomeCoord")).length == 3) {
            this.home = new CoordTuple(coord[0], coord[1], coord[2]);
        }
    }
}

