/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.crystal;

import mods.tinker.tconstruct.crystal.Crystallinity;
import net.minecraft.nbt.NBTTagCompound;

public class CrystalValues {
    int light;
    int time;
    int life;
    int stone;
    int fire;
    int water;
    final String valueType;

    public CrystalValues(String type) {
        this.valueType = type;
    }

    public void addValue(int value, Crystallinity.CrystalType type) {
        switch (type) {
            case Light: {
                this.light += value;
            }
            case Time: {
                this.time += value;
            }
            case Life: {
                this.life += value;
            }
            case Stone: {
                this.stone += value;
            }
            case Fire: {
                this.fire += value;
            }
            case Water: {
                this.water += value;
            }
        }
    }

    public int getValue(Crystallinity.CrystalType type) {
        switch (type) {
            case Light: {
                return this.light;
            }
            case Time: {
                return this.time;
            }
            case Life: {
                return this.life;
            }
            case Stone: {
                return this.stone;
            }
            case Fire: {
                return this.fire;
            }
            case Water: {
                return this.water;
            }
        }
        return 0;
    }

    protected void setValue(int[] array) {
        this.light = array[0];
        this.time = array[1];
        this.life = array[2];
        this.stone = array[3];
        this.fire = array[4];
        this.water = array[5];
    }

    public CrystalValues loadFromNBT(NBTTagCompound tags) {
        int[] crystalArray = tags.func_74759_k("TConstruct.Crystal." + this.valueType);
        if (crystalArray != null && crystalArray.length >= 6) {
            this.setValue(crystalArray);
        }
        return this;
    }

    public void saveToNBT(NBTTagCompound tags) {
        int[] crystalArray = new int[]{this.light, this.time, this.life, this.stone, this.fire, this.water};
        tags.func_74783_a("TConstruct.Crystal.", crystalArray);
    }
}

