/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.blocks.logic;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.tinker.tconstruct.blocks.logic.LavaTankLogic;
import mods.tinker.tconstruct.blocks.logic.MultiServantLogic;
import mods.tinker.tconstruct.common.TContent;
import mods.tinker.tconstruct.inventory.SmelteryContainer;
import mods.tinker.tconstruct.library.blocks.InventoryLogic;
import mods.tinker.tconstruct.library.crafting.Smeltery;
import mods.tinker.tconstruct.library.util.CoordTuple;
import mods.tinker.tconstruct.library.util.IActiveLogic;
import mods.tinker.tconstruct.library.util.IFacingLogic;
import mods.tinker.tconstruct.library.util.IMasterLogic;
import mods.tinker.tconstruct.util.SmelteryDamageSource;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class SmelteryLogic
extends InventoryLogic
implements IActiveLogic,
IFacingLogic,
ILiquidTank,
IMasterLogic {
    public boolean validStructure;
    public boolean tempValidStructure;
    byte direction;
    int internalTemp;
    public int useTime;
    public int fuelGague;
    public int fuelAmount;
    boolean inUse;
    ArrayList lavaTanks;
    CoordTuple activeLavaTank;
    public CoordTuple centerPos;
    public int[] activeTemps;
    public int[] meltingTemps;
    int tick;
    public ArrayList moltenMetal = new ArrayList();
    int maxLiquid;
    int currentLiquid;
    public int layers;
    int slag;
    int numBricks;
    Random rand = new Random();
    boolean needsUpdate;

    public SmelteryLogic() {
        super(0);
        this.lavaTanks = new ArrayList();
        this.activeTemps = new int[0];
        this.meltingTemps = new int[0];
    }

    void adjustLayers(int lay, boolean forceAdjust) {
        if (lay != this.layers || forceAdjust) {
            int i;
            this.needsUpdate = true;
            this.layers = lay;
            this.maxLiquid = 20000 * lay;
            int[] tempActive = this.activeTemps;
            this.activeTemps = new int[9 * lay];
            int activeLength = tempActive.length > this.activeTemps.length ? this.activeTemps.length : tempActive.length;
            System.arraycopy(tempActive, 0, this.activeTemps, 0, activeLength);
            int[] tempMelting = this.meltingTemps;
            this.meltingTemps = new int[9 * lay];
            int meltingLength = tempMelting.length > this.meltingTemps.length ? this.meltingTemps.length : tempMelting.length;
            System.arraycopy(tempMelting, 0, this.meltingTemps, 0, meltingLength);
            ItemStack[] tempInv = this.inventory;
            this.inventory = new ItemStack[9 * lay];
            int invLength = tempInv.length > this.inventory.length ? this.inventory.length : tempInv.length;
            System.arraycopy(tempInv, 0, this.inventory, 0, invLength);
            if (this.activeTemps.length > 0 && this.activeTemps.length > tempActive.length) {
                for (i = tempActive.length; i < this.activeTemps.length; ++i) {
                    this.activeTemps[i] = 20;
                    this.meltingTemps[i] = 20;
                }
            }
            if (tempInv.length > this.inventory.length) {
                for (i = this.inventory.length; i < tempInv.length; ++i) {
                    ItemStack stack = tempInv[i];
                    if (stack == null) continue;
                    float jumpX = this.rand.nextFloat() * 0.8f + 0.1f;
                    float jumpY = this.rand.nextFloat() * 0.8f + 0.1f;
                    float jumpZ = this.rand.nextFloat() * 0.8f + 0.1f;
                    int offsetX = 0;
                    int offsetZ = 0;
                    switch (this.getRenderDirection()) {
                        case 2: {
                            offsetZ = -1;
                            break;
                        }
                        case 3: {
                            offsetZ = 1;
                            break;
                        }
                        case 4: {
                            offsetX = -1;
                            break;
                        }
                        case 5: {
                            offsetX = 1;
                        }
                    }
                    while (stack.field_77994_a > 0) {
                        int itemSize = this.rand.nextInt(21) + 10;
                        if (itemSize > stack.field_77994_a) {
                            itemSize = stack.field_77994_a;
                        }
                        stack.field_77994_a -= itemSize;
                        EntityItem entityitem = new EntityItem(this.field_70331_k, (double)((float)this.field_70329_l + jumpX + (float)offsetX), (double)((float)this.field_70330_m + jumpY), (double)((float)this.field_70327_n + jumpZ + (float)offsetZ), new ItemStack(stack.field_77993_c, itemSize, stack.func_77960_j()));
                        if (stack.func_77942_o()) {
                            entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                        }
                        float offset = 0.05f;
                        entityitem.field_70159_w = (float)this.rand.nextGaussian() * offset;
                        entityitem.field_70181_x = (float)this.rand.nextGaussian() * offset + 0.2f;
                        entityitem.field_70179_y = (float)this.rand.nextGaussian() * offset;
                        this.field_70331_k.func_72838_d((Entity)entityitem);
                    }
                }
            }
        }
    }

    @Override
    public String getDefaultName() {
        return "crafters.Smeltery";
    }

    @Override
    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return new SmelteryContainer(inventoryplayer, this);
    }

    @Override
    public byte getRenderDirection() {
        return this.direction;
    }

    @Override
    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    @Override
    public void setDirection(int side) {
    }

    @Override
    public void setDirection(float yaw, float pitch, EntityLiving player) {
        int facing = MathHelper.func_76128_c((double)((double)(yaw / 360.0f) + 0.5)) & 3;
        switch (facing) {
            case 0: {
                this.direction = (byte)2;
                break;
            }
            case 1: {
                this.direction = (byte)5;
                break;
            }
            case 2: {
                this.direction = (byte)3;
                break;
            }
            case 3: {
                this.direction = (byte)4;
            }
        }
    }

    @Override
    public boolean getActive() {
        return this.validStructure;
    }

    @Override
    public void setActive(boolean flag) {
        this.needsUpdate = true;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public int getScaledFuelGague(int scale) {
        int ret = this.fuelGague * scale / 52;
        if (ret < 1) {
            ret = 1;
        }
        return ret;
    }

    public int getInternalTemperature() {
        return this.internalTemp;
    }

    public int getTempForSlot(int slot) {
        return this.activeTemps[slot];
    }

    public int getMeltingPointForSlot(int slot) {
        return this.meltingTemps[slot];
    }

    public void func_70316_g() {
        ++this.tick;
        if (this.tick % 4 == 0) {
            this.heatItems();
        }
        if (this.tick % 20 == 0) {
            if (!this.validStructure) {
                this.checkValidPlacement();
            }
            if (this.useTime > 0 && this.inUse) {
                this.useTime -= 3;
            }
            if (this.validStructure && this.useTime <= 0) {
                this.updateFuelGague();
            }
            if (this.needsUpdate) {
                this.needsUpdate = false;
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
        if (this.tick == 60) {
            this.tick = 0;
            if (this.validStructure) {
                this.detectEntities();
            }
        }
    }

    void detectEntities() {
        AxisAlignedBB box = AxisAlignedBB.func_72332_a().func_72299_a((double)this.centerPos.x, (double)this.centerPos.y, (double)this.centerPos.z, (double)this.centerPos.x + 1.0, (double)this.centerPos.y + 1.0, (double)this.centerPos.z + 1.0).func_72314_b(1.0, 0.0, 1.0);
        List list = this.field_70331_k.func_72872_a(Entity.class, box);
        for (Object o : list) {
            EntityLiving living;
            EntityVillager villager;
            if (o instanceof EntityVillager) {
                villager = (EntityVillager)o;
                if (!villager.func_70097_a((DamageSource)new SmelteryDamageSource(), 1) || this.currentLiquid + 8 >= this.maxLiquid) continue;
                int amount = villager.func_70631_g_() ? 2 : 8;
                this.addMoltenMetal(new LiquidStack(TContent.liquidMetalStill.field_71990_ca, amount, 15), false);
                continue;
            }
            if (o instanceof EntityEnderman) {
                villager = (EntityEnderman)o;
                if (!villager.func_70097_a((DamageSource)new SmelteryDamageSource(), 1) || this.currentLiquid + 25 >= this.maxLiquid) continue;
                this.addMoltenMetal(new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 25, 23), false);
                continue;
            }
            if (o instanceof EntityLiving && !(living = (EntityLiving)o).func_70097_a((DamageSource)new SmelteryDamageSource(), 1)) continue;
        }
    }

    void heatItems() {
        if (this.useTime > 0) {
            boolean hasUse = false;
            for (int i = 0; i < 9 * this.layers; ++i) {
                if (this.meltingTemps[i] > 20 && this.isStackInSlot(i)) {
                    LiquidStack result;
                    hasUse = true;
                    if (this.activeTemps[i] < this.internalTemp && this.activeTemps[i] < this.meltingTemps[i]) {
                        int n = i;
                        this.activeTemps[n] = this.activeTemps[n] + 1;
                        continue;
                    }
                    if (this.activeTemps[i] < this.meltingTemps[i] || this.field_70331_k.field_72995_K || (result = this.getResultFor(this.inventory[i])) == null || !this.addMoltenMetal(result, false)) continue;
                    this.inventory[i] = null;
                    this.activeTemps[i] = 20;
                    ArrayList alloys = Smeltery.mixMetals(this.moltenMetal);
                    for (int al = 0; al < alloys.size(); ++al) {
                        LiquidStack liquid = (LiquidStack)alloys.get(al);
                        this.addMoltenMetal(liquid, true);
                    }
                    this.func_70296_d();
                    continue;
                }
                this.activeTemps[i] = 20;
            }
            this.inUse = hasUse;
        }
    }

    boolean addMoltenMetal(LiquidStack liquid, boolean first) {
        this.needsUpdate = true;
        if (this.moltenMetal.size() == 0) {
            this.moltenMetal.add(liquid.copy());
            this.currentLiquid += liquid.amount;
            return true;
        }
        if (liquid.amount + this.currentLiquid > this.maxLiquid) {
            return false;
        }
        this.currentLiquid += liquid.amount;
        boolean added = false;
        for (int i = 0; i < this.moltenMetal.size(); ++i) {
            LiquidStack l = (LiquidStack)this.moltenMetal.get(i);
            if (l.itemID == liquid.itemID && l.itemMeta == liquid.itemMeta) {
                l.amount += liquid.amount;
                added = true;
            }
            if (l.amount > 0) continue;
            this.moltenMetal.remove(l);
            --i;
        }
        if (!added) {
            if (first) {
                this.moltenMetal.add(0, liquid.copy());
            } else {
                this.moltenMetal.add(liquid.copy());
            }
        }
        return true;
    }

    void updateTemperatures() {
        this.inUse = true;
        for (int i = 0; i < 9 * this.layers; ++i) {
            this.meltingTemps[i] = Smeltery.getLiquifyTemperature(this.inventory[i]);
        }
    }

    public void updateFuelDisplay() {
        if (this.activeLavaTank == null || this.useTime > 0) {
            return;
        }
        if (!this.field_70331_k.func_72899_e(this.activeLavaTank.x, this.activeLavaTank.y, this.activeLavaTank.z)) {
            this.fuelAmount = 0;
            this.fuelGague = 0;
            return;
        }
        TileEntity tankContainer = this.field_70331_k.func_72796_p(this.activeLavaTank.x, this.activeLavaTank.y, this.activeLavaTank.z);
        if (tankContainer == null) {
            this.fuelAmount = 0;
            this.fuelGague = 0;
            return;
        }
        if (tankContainer instanceof ITankContainer) {
            this.needsUpdate = true;
            LiquidStack liquid = ((ITankContainer)tankContainer).drain(ForgeDirection.DOWN, 150, false);
            if (liquid != null && liquid.itemID == Block.field_71938_D.field_71990_ca) {
                ILiquidTank tank = ((ITankContainer)tankContainer).getTank(ForgeDirection.DOWN, liquid);
                int capacity = tank.getCapacity();
                this.fuelAmount = liquid.amount;
                this.fuelGague = liquid.amount * 52 / capacity;
            } else {
                this.fuelAmount = 0;
                this.fuelGague = 0;
            }
        }
    }

    void updateFuelGague() {
        if (this.activeLavaTank == null || this.useTime > 0) {
            return;
        }
        if (!this.field_70331_k.func_72899_e(this.activeLavaTank.x, this.activeLavaTank.y, this.activeLavaTank.z)) {
            this.fuelAmount = 0;
            this.fuelGague = 0;
            return;
        }
        TileEntity tankContainer = this.field_70331_k.func_72796_p(this.activeLavaTank.x, this.activeLavaTank.y, this.activeLavaTank.z);
        if (tankContainer == null) {
            this.fuelAmount = 0;
            this.fuelGague = 0;
            return;
        }
        if (tankContainer instanceof ITankContainer) {
            this.needsUpdate = true;
            LiquidStack liquid = ((ITankContainer)tankContainer).drain(ForgeDirection.DOWN, 150, false);
            if (liquid != null && liquid.itemID == Block.field_71938_D.field_71990_ca) {
                liquid = ((ITankContainer)tankContainer).drain(ForgeDirection.DOWN, 150, true);
                this.useTime += liquid.amount;
                ILiquidTank tank = ((ITankContainer)tankContainer).getTank(ForgeDirection.DOWN, liquid);
                liquid = tank.getLiquid();
                int capacity = tank.getCapacity();
                if (liquid != null) {
                    this.fuelAmount = liquid.amount;
                    this.fuelGague = liquid.amount * 52 / capacity;
                } else {
                    this.fuelAmount = 0;
                    this.fuelGague = 0;
                }
            } else {
                boolean foundTank = false;
                int iter = 0;
                while (!foundTank) {
                    LiquidStack newliquid;
                    CoordTuple possibleTank = (CoordTuple)this.lavaTanks.get(iter);
                    TileEntity newTankContainer = this.field_70331_k.func_72796_p(possibleTank.x, possibleTank.y, possibleTank.z);
                    if (newTankContainer instanceof ITankContainer && (newliquid = ((ITankContainer)newTankContainer).drain(ForgeDirection.UNKNOWN, 150, false)) != null && newliquid.itemID == Block.field_71938_D.field_71990_ca && newliquid.amount > 0) {
                        foundTank = true;
                        this.activeLavaTank = possibleTank;
                        iter = this.lavaTanks.size();
                        ILiquidTank newTank = ((ITankContainer)newTankContainer).getTank(ForgeDirection.UNKNOWN, liquid);
                        liquid = newTank.getLiquid();
                        int capacity = newTank.getCapacity();
                        if (liquid != null) {
                            this.fuelAmount = liquid.amount;
                            this.fuelGague = liquid.amount * 52 / capacity;
                        } else {
                            this.fuelAmount = 0;
                            this.fuelGague = 0;
                        }
                    }
                    if (++iter < this.lavaTanks.size()) continue;
                    foundTank = true;
                }
            }
        }
    }

    public LiquidStack getResultFor(ItemStack stack) {
        return Smeltery.getSmelteryResult(stack);
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
        this.updateTemperatures();
        super.func_70296_d();
        this.needsUpdate = true;
    }

    @Override
    public void notifyChange(int x, int y, int z) {
        this.checkValidPlacement();
    }

    public void checkValidPlacement() {
        switch (this.getRenderDirection()) {
            case 2: {
                this.alignInitialPlacement(this.field_70329_l, this.field_70330_m, this.field_70327_n + 2);
                break;
            }
            case 3: {
                this.alignInitialPlacement(this.field_70329_l, this.field_70330_m, this.field_70327_n - 2);
                break;
            }
            case 4: {
                this.alignInitialPlacement(this.field_70329_l + 2, this.field_70330_m, this.field_70327_n);
                break;
            }
            case 5: {
                this.alignInitialPlacement(this.field_70329_l - 2, this.field_70330_m, this.field_70327_n);
            }
        }
    }

    public void alignInitialPlacement(int x, int y, int z) {
        int northID = this.field_70331_k.func_72798_a(x, y, z + 1);
        int southID = this.field_70331_k.func_72798_a(x, y, z - 1);
        int eastID = this.field_70331_k.func_72798_a(x + 1, y, z);
        int westID = this.field_70331_k.func_72798_a(x - 1, y, z);
        Block northBlock = Block.field_71973_m[northID];
        Block southBlock = Block.field_71973_m[southID];
        Block eastBlock = Block.field_71973_m[eastID];
        Block westBlock = Block.field_71973_m[westID];
        if (!(northBlock != null && !northBlock.isAirBlock(this.field_70331_k, x, y, z + 1) || southBlock != null && !southBlock.isAirBlock(this.field_70331_k, x, y, z - 1) || eastBlock != null && !eastBlock.isAirBlock(this.field_70331_k, x + 1, y, z) || westBlock != null && !westBlock.isAirBlock(this.field_70331_k, x - 1, y, z))) {
            this.checkValidStructure(x, y, z);
        } else if (!(northBlock == null || northBlock.isAirBlock(this.field_70331_k, x, y, z + 1) || southBlock != null && !southBlock.isAirBlock(this.field_70331_k, x, y, z - 1) || eastBlock != null && !eastBlock.isAirBlock(this.field_70331_k, x + 1, y, z) || westBlock != null && !westBlock.isAirBlock(this.field_70331_k, x - 1, y, z))) {
            this.checkValidStructure(x, y, z - 1);
        } else if (!(northBlock != null && !northBlock.isAirBlock(this.field_70331_k, x, y, z + 1) || southBlock == null || southBlock.isAirBlock(this.field_70331_k, x, y, z - 1) || eastBlock != null && !eastBlock.isAirBlock(this.field_70331_k, x + 1, y, z) || westBlock != null && !westBlock.isAirBlock(this.field_70331_k, x - 1, y, z))) {
            this.checkValidStructure(x, y, z + 1);
        } else if (!(northBlock != null && !northBlock.isAirBlock(this.field_70331_k, x, y, z + 1) || southBlock != null && !southBlock.isAirBlock(this.field_70331_k, x, y, z - 1) || eastBlock == null || eastBlock.isAirBlock(this.field_70331_k, x + 1, y, z) || westBlock != null && !westBlock.isAirBlock(this.field_70331_k, x - 1, y, z))) {
            this.checkValidStructure(x - 1, y, z);
        } else if (!(northBlock != null && !northBlock.isAirBlock(this.field_70331_k, x, y, z + 1) || southBlock != null && !southBlock.isAirBlock(this.field_70331_k, x, y, z - 1) || eastBlock != null && !eastBlock.isAirBlock(this.field_70331_k, x + 1, y, z) || westBlock == null || westBlock.isAirBlock(this.field_70331_k, x - 1, y, z))) {
            this.checkValidStructure(x + 1, y, z);
        }
    }

    public void checkValidStructure(int x, int y, int z) {
        int checkLayers = 0;
        this.tempValidStructure = false;
        if (this.checkSameLevel(x, y, z)) {
            ++checkLayers;
            checkLayers += this.recurseStructureUp(x, y + 1, z, 0);
            checkLayers += this.recurseStructureDown(x, y - 1, z, 0);
        }
        if (this.tempValidStructure != this.validStructure || checkLayers != this.layers) {
            if (this.tempValidStructure) {
                this.internalTemp = 800;
                this.activeLavaTank = (CoordTuple)this.lavaTanks.get(0);
                this.adjustLayers(checkLayers, false);
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                this.validStructure = true;
            } else {
                this.internalTemp = 20;
                this.validStructure = false;
            }
        }
    }

    public boolean checkSameLevel(int x, int y, int z) {
        int xPos;
        this.numBricks = 0;
        this.lavaTanks.clear();
        for (xPos = x - 1; xPos <= x + 1; ++xPos) {
            for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                Block block = Block.field_71973_m[this.field_70331_k.func_72798_a(xPos, y, zPos)];
                if (block == null || block.isAirBlock(this.field_70331_k, xPos, y, zPos)) continue;
                return false;
            }
        }
        for (xPos = x - 1; xPos <= x + 1; ++xPos) {
            this.numBricks += this.checkBricks(xPos, y, z - 2);
            this.numBricks += this.checkBricks(xPos, y, z + 2);
        }
        for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
            this.numBricks += this.checkBricks(x - 2, y, zPos);
            this.numBricks += this.checkBricks(x + 2, y, zPos);
        }
        return this.numBricks == 12 && this.lavaTanks.size() > 0;
    }

    public int recurseStructureUp(int x, int y, int z, int count) {
        int xPos;
        this.numBricks = 0;
        for (xPos = x - 1; xPos <= x + 1; ++xPos) {
            for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                Block block = Block.field_71973_m[this.field_70331_k.func_72798_a(xPos, y, zPos)];
                if (block == null || block.isAirBlock(this.field_70331_k, xPos, y, zPos)) continue;
                return count;
            }
        }
        for (xPos = x - 1; xPos <= x + 1; ++xPos) {
            this.numBricks += this.checkBricks(xPos, y, z - 2);
            this.numBricks += this.checkBricks(xPos, y, z + 2);
        }
        for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
            this.numBricks += this.checkBricks(x - 2, y, zPos);
            this.numBricks += this.checkBricks(x + 2, y, zPos);
        }
        if (this.numBricks != 12) {
            return count;
        }
        return this.recurseStructureUp(x, y + 1, z, ++count);
    }

    public int recurseStructureDown(int x, int y, int z, int count) {
        int xPos;
        this.numBricks = 0;
        for (xPos = x - 1; xPos <= x + 1; ++xPos) {
            for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                int blockID = this.field_70331_k.func_72798_a(xPos, y, zPos);
                Block block = Block.field_71973_m[blockID];
                if (block == null || block.isAirBlock(this.field_70331_k, xPos, y, zPos)) continue;
                if (blockID == TContent.smeltery.field_71990_ca) {
                    return this.validateBottom(x, y, z, count);
                }
                return count;
            }
        }
        for (xPos = x - 1; xPos <= x + 1; ++xPos) {
            this.numBricks += this.checkBricks(xPos, y, z - 2);
            this.numBricks += this.checkBricks(xPos, y, z + 2);
        }
        for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
            this.numBricks += this.checkBricks(x - 2, y, zPos);
            this.numBricks += this.checkBricks(x + 2, y, zPos);
        }
        if (this.numBricks != 12) {
            return count;
        }
        return this.recurseStructureDown(x, y - 1, z, ++count);
    }

    public int validateBottom(int x, int y, int z, int count) {
        int bottomBricks = 0;
        for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
            for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                if (this.field_70331_k.func_72798_a(xPos, y, zPos) != TContent.smeltery.field_71990_ca || this.field_70331_k.func_72805_g(xPos, y, zPos) < 2) continue;
                ++bottomBricks;
            }
        }
        if (bottomBricks == 9) {
            this.tempValidStructure = true;
            this.centerPos = new CoordTuple(x, y + 1, z);
        }
        return count;
    }

    int checkBricks(int x, int y, int z) {
        int tempBricks = 0;
        int blockID = this.field_70331_k.func_72798_a(x, y, z);
        if (blockID == TContent.smeltery.field_71990_ca || blockID == TContent.lavaTank.field_71990_ca) {
            TileEntity te = this.field_70331_k.func_72796_p(x, y, z);
            if (te == this) {
                ++tempBricks;
            } else if (te instanceof MultiServantLogic) {
                MultiServantLogic servant = (MultiServantLogic)te;
                if (servant.hasValidMaster()) {
                    if (servant.verifyMaster(this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
                        ++tempBricks;
                    }
                } else if (servant.setMaster(this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
                    ++tempBricks;
                }
                if (te instanceof LavaTankLogic) {
                    this.lavaTanks.add(new CoordTuple(x, y, z));
                }
            }
        }
        return tempBricks;
    }

    public int getCapacity() {
        return this.maxLiquid;
    }

    public int getTotalLiquid() {
        return this.currentLiquid;
    }

    public LiquidStack drain(int maxDrain, boolean doDrain) {
        if (this.moltenMetal.size() == 0) {
            return null;
        }
        LiquidStack liquid = (LiquidStack)this.moltenMetal.get(0);
        if (liquid.amount - maxDrain <= 0) {
            LiquidStack liq = liquid.copy();
            if (doDrain) {
                this.moltenMetal.remove(liquid);
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                this.currentLiquid = 0;
                this.needsUpdate = true;
            }
            return liq;
        }
        if (doDrain) {
            liquid.amount -= maxDrain;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.currentLiquid -= maxDrain;
            this.needsUpdate = true;
        }
        return new LiquidStack(liquid.itemID, maxDrain, liquid.itemMeta);
    }

    public int fill(LiquidStack resource, boolean doFill) {
        if (resource != null && resource.amount + this.currentLiquid < this.maxLiquid) {
            int amount = resource.amount;
            if (doFill) {
                if (this.addMoltenMetal(resource, false)) {
                    ArrayList alloys = Smeltery.mixMetals(this.moltenMetal);
                    for (int al = 0; al < alloys.size(); ++al) {
                        LiquidStack liquid = (LiquidStack)alloys.get(al);
                        this.addMoltenMetal(liquid, true);
                    }
                }
                this.needsUpdate = true;
                this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
            return amount;
        }
        return 0;
    }

    public LiquidStack getLiquid() {
        if (this.moltenMetal.size() == 0) {
            return null;
        }
        return (LiquidStack)this.moltenMetal.get(0);
    }

    public int getTankPressure() {
        return 0;
    }

    @Override
    public void func_70307_a(NBTTagCompound tags) {
        this.layers = tags.func_74762_e("Layers");
        this.inventory = new ItemStack[this.layers * 9];
        super.func_70307_a(tags);
        this.internalTemp = tags.func_74762_e("InternalTemp");
        this.inUse = tags.func_74767_n("InUse");
        int[] center = tags.func_74759_k("CenterPos");
        this.centerPos = center.length > 2 ? new CoordTuple(center[0], center[1], center[2]) : new CoordTuple(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.direction = tags.func_74771_c("Direction");
        this.useTime = tags.func_74762_e("UseTime");
        this.currentLiquid = tags.func_74762_e("CurrentLiquid");
        this.maxLiquid = tags.func_74762_e("MaxLiquid");
        this.meltingTemps = tags.func_74759_k("MeltingTemps");
        this.activeTemps = tags.func_74759_k("ActiveTemps");
        NBTTagList liquidTag = tags.func_74761_m("Liquids");
        this.moltenMetal.clear();
        for (int iter = 0; iter < liquidTag.func_74745_c(); ++iter) {
            NBTTagCompound tagList = (NBTTagCompound)liquidTag.func_74743_b(iter);
            int id = tagList.func_74762_e("id");
            int amount = tagList.func_74762_e("amount");
            int meta = tagList.func_74762_e("meta");
            this.moltenMetal.add(new LiquidStack(id, amount, meta));
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        tags.func_74768_a("InternalTemp", this.internalTemp);
        tags.func_74757_a("InUse", this.inUse);
        int[] center = new int[3];
        center = this.centerPos == null ? new int[]{this.field_70329_l, this.field_70330_m, this.field_70327_n} : new int[]{this.centerPos.x, this.centerPos.y, this.centerPos.z};
        tags.func_74783_a("CenterPos", center);
        tags.func_74774_a("Direction", this.direction);
        tags.func_74768_a("UseTime", this.useTime);
        tags.func_74768_a("CurrentLiquid", this.currentLiquid);
        tags.func_74768_a("MaxLiquid", this.maxLiquid);
        tags.func_74768_a("Layers", this.layers);
        tags.func_74783_a("MeltingTemps", this.meltingTemps);
        tags.func_74783_a("ActiveTemps", this.activeTemps);
        NBTTagList taglist = new NBTTagList();
        for (LiquidStack liquid : this.moltenMetal) {
            NBTTagCompound liquidTag = new NBTTagCompound();
            liquidTag.func_74768_a("id", liquid.itemID);
            liquidTag.func_74768_a("amount", liquid.amount);
            liquidTag.func_74768_a("meta", liquid.itemMeta);
            taglist.func_74742_a((NBTBase)liquidTag);
        }
        tags.func_74782_a("Liquids", (NBTBase)taglist);
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }
}

