/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.blocks.logic;

import cpw.mods.fml.common.registry.GameRegistry;
import mods.tinker.tconstruct.blocks.logic.EquipLogic;
import mods.tinker.tconstruct.inventory.FrypanContainer;
import mods.tinker.tconstruct.library.util.IActiveLogic;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class FrypanLogic
extends EquipLogic
implements IActiveLogic {
    boolean active = false;
    public int fuel;
    public int fuelGague;
    public int progress;

    public FrypanLogic() {
        super(10);
    }

    @Override
    public String getDefaultName() {
        return "crafters.frypan";
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean flag) {
        this.active = flag;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public int gaugeProgressScaled(int scale) {
        return this.progress * scale / 1000;
    }

    public int gaugeFuelScaled(int scale) {
        if (this.fuelGague == 0) {
            this.fuelGague = this.fuel;
            if (this.fuelGague == 0) {
                this.fuelGague = 1000;
            }
        }
        return this.fuel * scale / this.fuelGague;
    }

    public void func_70316_g() {
        boolean burning = this.isBurning();
        boolean updateInventory = false;
        if (this.fuel <= 0 && this.canCook()) {
            this.fuel = this.fuelGague = (int)((double)FrypanLogic.getItemBurnTime(this.inventory[1]) * 2.5);
            if (this.fuel > 0) {
                if (this.inventory[1].func_77973_b().func_77634_r()) {
                    this.inventory[1] = new ItemStack(this.inventory[1].func_77973_b().func_77668_q());
                } else {
                    --this.inventory[1].field_77994_a;
                }
                if (this.inventory[1].field_77994_a <= 0) {
                    this.inventory[1] = null;
                }
                updateInventory = true;
            }
        }
        if (this.isBurning() && this.canCook()) {
            ++this.progress;
            if (this.progress >= 1000) {
                this.progress = 0;
                this.cookItems();
                updateInventory = true;
            }
        } else {
            this.progress = 0;
        }
        if (this.fuel > 0) {
            --this.fuel;
        }
        if (burning != this.isBurning()) {
            this.setActive(this.isBurning());
            updateInventory = true;
        }
        if (updateInventory) {
            this.func_70296_d();
        }
    }

    public void cookItems() {
        if (!this.canCook()) {
            return;
        }
        for (int id = 2; id < 10; ++id) {
            int ids;
            ItemStack result;
            if (!this.canCook() || (result = this.getResultFor(this.inventory[id])) == null) continue;
            boolean placed = false;
            for (ids = 2; ids < 10 && !placed; ++ids) {
                if (this.inventory[ids] == null || !this.inventory[ids].func_77969_a(result) || this.inventory[ids].field_77994_a >= this.inventory[ids].func_77976_d()) continue;
                if (this.inventory[ids].field_77994_a + result.field_77994_a <= this.inventory[ids].func_77976_d()) {
                    this.inventory[ids].field_77994_a += result.field_77994_a;
                    placed = true;
                    continue;
                }
                int decrement = this.inventory[ids].func_77976_d() - this.inventory[ids].field_77994_a;
                this.inventory[ids].field_77994_a = this.inventory[ids].func_77976_d();
                result.field_77994_a -= decrement;
            }
            for (ids = 2; !placed && ids < 10; ++ids) {
                if (this.inventory[ids] != null) continue;
                this.inventory[ids] = result;
                placed = true;
            }
            if (!placed) continue;
            this.func_70298_a(id, 1);
        }
    }

    public boolean canCook() {
        for (int id = 2; id < 10; ++id) {
            ItemStack result;
            if (this.inventory[id] == null || (result = this.getResultFor(this.inventory[id])) == null) continue;
            for (int slotid = 2; slotid < 10; ++slotid) {
                if (this.inventory[slotid] == null) {
                    return true;
                }
                if (!this.inventory[slotid].func_77969_a(result) || this.inventory[slotid].field_77994_a + result.field_77994_a > this.inventory[slotid].func_77976_d()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isBurning() {
        return this.fuel > 0;
    }

    public ItemStack getResultFor(ItemStack stack) {
        ItemStack result = FurnaceRecipes.func_77602_a().getSmeltingResult(stack);
        if (result != null && result.func_77973_b() instanceof ItemFood) {
            return result.func_77946_l();
        }
        return null;
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        int itemID = stack.func_77973_b().field_77779_bT;
        Item item = stack.func_77973_b();
        if (stack.func_77973_b() instanceof ItemBlock && Block.field_71973_m[itemID] != null) {
            Block block = Block.field_71973_m[itemID];
            if (block == Block.field_72092_bO) {
                return 150;
            }
            if (block == Block.field_71951_J) {
                return 2400;
            }
            if (block.field_72018_cp == Material.field_76245_d) {
                return 300;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_77825_f().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 200;
        }
        if (itemID == Item.field_77669_D.field_77779_bT) {
            return 100;
        }
        if (itemID == Item.field_77705_m.field_77779_bT) {
            return 800;
        }
        if (itemID == Item.field_77775_ay.field_77779_bT) {
            return 20000;
        }
        if (itemID == Block.field_71987_y.field_71990_ca) {
            return 100;
        }
        if (itemID == Item.field_77731_bo.field_77779_bT) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)stack);
    }

    @Override
    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.active = tags.func_74767_n("Active");
        this.fuel = tags.func_74762_e("Fuel");
        this.fuelGague = tags.func_74762_e("FuelGague");
    }

    @Override
    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        tags.func_74757_a("Active", this.active);
        tags.func_74768_a("Fuel", this.fuel);
        tags.func_74768_a("FuelGague", this.fuelGague);
    }

    @Override
    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return new FrypanContainer(inventoryplayer, this);
    }
}

