/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.sounds;

import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.util.sounds.SoundRegistry;
import net.minecraft.block.StepSound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class SoundHelper {
    public static void playSound(World world, int x, int y, int z, String name, float volume, float pitch) {
        if (RailcraftConfig.playSounds()) {
            world.func_72908_a((double)x, (double)y, (double)z, name, volume, pitch);
        }
    }

    public static void playSoundClient(World world, int x, int y, int z, String name, float volume, float pitch) {
        if (RailcraftConfig.playSounds()) {
            world.func_72980_b((double)x, (double)y, (double)z, name, volume, pitch, false);
        }
    }

    public static void playSoundAtEntity(Entity entity, String name, float volume, float pitch) {
        if (RailcraftConfig.playSounds()) {
            entity.field_70170_p.func_72956_a(entity, name, volume, pitch);
        }
    }

    public static void playBlockSound(World world, int x, int y, int z, String soundName, float volume, float pitch, int blockID, int meta) {
        if (world != null && soundName != null) {
            StepSound sound;
            if (soundName.contains("railcraft") && (sound = SoundRegistry.getSound(blockID, meta)) != null) {
                String newName = soundName.contains("dig") ? sound.func_72676_a() : (soundName.contains("step") ? sound.func_72675_d() : sound.func_82593_b());
                world.func_72908_a((double)x, (double)y, (double)z, newName, volume, pitch * sound.func_72678_c());
            }
            world.func_72908_a((double)x, (double)y, (double)z, soundName, volume, pitch);
        }
    }

    public static void playFX(World world, EntityPlayer player, int id, int x, int y, int z, int data) {
        if (RailcraftConfig.playSounds()) {
            world.func_72889_a(player, id, x, y, z, data);
        }
    }
}

