/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.inventory;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.AdjacentTileCache;
import mods.railcraft.common.util.misc.ITileFilter;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class AdjacentInventoryCache {
    private final AdjacentTileCache cache;
    private boolean changed = true;
    private final List invs = new LinkedList();
    private final Comparator sorter;
    private final ITileFilter filter;

    public AdjacentInventoryCache(TileEntity tile) {
        this(tile, null, null);
    }

    public AdjacentInventoryCache(TileEntity tile, ITileFilter filter, Comparator sorter) {
        this.cache = new AdjacentTileCache(tile){

            @Override
            protected void changed() {
                AdjacentInventoryCache.this.changed = true;
            }
        };
        this.filter = filter;
        this.sorter = sorter;
    }

    public Collection getAdjecentInventories() {
        this.cache.refresh();
        if (this.changed) {
            this.changed = false;
            this.invs.clear();
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                IInventory inv;
                TileEntity tile = this.cache.getTileOnSide(side);
                if (tile == null || this.filter != null && !this.filter.matches(tile) || (inv = InvTools.getInventoryFromTile(tile, side.getOpposite())) == null) continue;
                this.invs.add(inv);
            }
            if (this.sorter != null) {
                Collections.sort(this.invs, this.sorter);
            }
        }
        return this.invs;
    }

    public void purge() {
        this.cache.purge();
        this.changed = true;
        this.invs.clear();
    }
}

