/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.liquids.tanks;

import java.util.Locale;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.gui.tooltips.ToolTipLine;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public class StandardTank
extends LiquidTank {
    private int tankIndex;
    protected final ToolTip toolTip = new ToolTip(){

        @Override
        public void refresh() {
            StandardTank.this.refreshTooltip();
        }
    };

    public StandardTank(int capacity) {
        super(capacity);
    }

    public StandardTank(int capacity, TileEntity tile) {
        super(null, capacity, tile);
    }

    public void setTankIndex(int index) {
        this.tankIndex = index;
    }

    public int getTankIndex() {
        return this.tankIndex;
    }

    public boolean isEmpty() {
        return this.getLiquid() == null || this.getLiquid().amount <= 0;
    }

    public boolean isFull() {
        return this.getLiquid() != null && this.getLiquid().amount == this.getCapacity();
    }

    public int fill(LiquidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (resource.amount <= 0) {
            return 0;
        }
        return super.fill(resource, doFill);
    }

    public LiquidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain <= 0) {
            return null;
        }
        return super.drain(maxDrain, doDrain);
    }

    public ToolTip getToolTip() {
        return this.toolTip;
    }

    protected void refreshTooltip() {
        this.toolTip.clear();
        int amount = 0;
        if (this.getLiquid() != null && this.getLiquid().itemID != 0 && this.getLiquid().amount > 0) {
            ItemStack stack = this.getLiquid().asItemStack();
            if (stack.func_77973_b() == null) {
                return;
            }
            ToolTipLine name = new ToolTipLine(Railcraft.getProxy().getItemDisplayName(stack), Railcraft.getProxy().getItemRarityColor(stack));
            name.setSpacing(2);
            this.toolTip.add(name);
            amount = this.getLiquid().amount;
        }
        this.toolTip.add(new ToolTipLine(String.format(Locale.ENGLISH, "%,d / %,d", amount, this.getCapacity())));
    }
}

