/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.liquids.tanks;

import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.gui.tooltips.ToolTipLine;
import mods.railcraft.common.liquids.tanks.StandardTank;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.liquids.LiquidStack;

public class FilteredTank
extends StandardTank {
    private final LiquidStack filter;

    public FilteredTank(int capacity, LiquidStack filter) {
        this(capacity, filter, null);
    }

    public FilteredTank(int capacity, LiquidStack filter, TileEntity tile) {
        super(capacity, tile);
        this.filter = filter;
    }

    @Override
    public int fill(LiquidStack resource, boolean doFill) {
        if (this.filter.isLiquidEqual(resource)) {
            return super.fill(resource, doFill);
        }
        return 0;
    }

    public LiquidStack getFilter() {
        return this.filter.copy();
    }

    public boolean liquidMatchesFilter(LiquidStack resource) {
        if (resource == null || this.filter == null) {
            return false;
        }
        return this.filter.isLiquidEqual(resource);
    }

    @Override
    protected void refreshTooltip() {
        this.toolTip.clear();
        int amount = 0;
        LiquidStack liquidType = this.getFilter();
        if (liquidType != null && liquidType.itemID > 0) {
            ItemStack stack = liquidType.asItemStack();
            if (stack.func_77973_b() == null) {
                return;
            }
            ToolTipLine name = new ToolTipLine(Railcraft.getProxy().getItemDisplayName(stack), Railcraft.getProxy().getItemRarityColor(stack));
            name.setSpacing(2);
            this.toolTip.add(name);
            if (this.getLiquid() != null) {
                amount = this.getLiquid().amount;
            }
        }
        this.toolTip.add(new ToolTipLine(String.format("%,d", amount) + " / " + String.format("%,d", this.getCapacity())));
    }
}

