/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.elements;

import mods.railcraft.client.gui.GuiContainerRailcraft;
import mods.railcraft.client.render.LiquidRenderer;
import mods.railcraft.common.gui.elements.Element;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.liquids.tanks.StandardTank;
import net.minecraft.util.Icon;
import net.minecraftforge.liquids.LiquidStack;

public class LiquidGauge
extends Element {
    public final StandardTank tank;

    public LiquidGauge(StandardTank tank, int x, int y, int u, int v, int w, int h) {
        super(x, y, u, v, w, h);
        this.tank = tank;
    }

    @Override
    public ToolTip getToolTip() {
        return this.tank.getToolTip();
    }

    @Override
    public void draw(GuiContainerRailcraft gui, int guiX, int guiY) {
        if (this.tank == null) {
            return;
        }
        LiquidStack liquid = this.tank.getLiquid();
        if (liquid == null || liquid.amount <= 0) {
            return;
        }
        Icon liquidIcon = LiquidRenderer.getLiquidTexture(liquid);
        if (liquidIcon == null) {
            return;
        }
        float scale = (float)Math.min(liquid.amount, this.tank.getCapacity()) / (float)this.tank.getCapacity();
        gui.bindTexture(liquid.canonical().getTextureSheet());
        for (int col = 0; col < this.w / 16; ++col) {
            for (int row = 0; row <= this.h / 16; ++row) {
                gui.func_94065_a(guiX + this.x + col * 16, guiY + this.y + row * 16 - 1, liquidIcon, 16, 16);
            }
        }
        gui.bindTexture(gui.texturePath);
        gui.func_73729_b(guiX + this.x, guiY + this.y - 1, this.x, this.y - 1, this.w, this.h - (int)Math.floor((float)this.h * scale) + 1);
        gui.func_73729_b(guiX + this.x, guiY + this.y, this.u, this.v, this.w, this.h);
    }
}

