/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.blocks.machine.beta.TileEngineSteamHobby;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.elements.Indicator;
import mods.railcraft.common.gui.elements.LiquidGauge;
import mods.railcraft.common.gui.slots.SlotFuel;
import mods.railcraft.common.gui.slots.SlotOutput;
import mods.railcraft.common.gui.slots.SlotWater;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerEngineSteamHobby
extends RailcraftContainer {
    private TileEngineSteamHobby tile;
    private Slot fuel;
    private Slot input;
    private Slot output;
    private float lastBurnTime;
    private float lastItemBurnTime;
    private float lastEnergy;
    private float lastOutput;
    private float lastHeat;

    public ContainerEngineSteamHobby(InventoryPlayer inventoryplayer, TileEngineSteamHobby tile) {
        super(tile);
        this.tile = tile;
        this.addElement(new LiquidGauge(tile.getTankManager().getTank(0), 17, 23, 176, 0, 16, 47));
        this.addElement(new LiquidGauge(tile.getTankManager().getTank(1), 107, 23, 176, 0, 16, 47));
        this.addElement(new Indicator(tile.getHeatIndicator(), 40, 25, 176, 61, 6, 43));
        this.addElement(new Indicator(tile.getEnergyIndicator(), 94, 25, 182, 61, 6, 43));
        this.fuel = new SlotFuel(tile, 0, 62, 39);
        this.addSlot(this.fuel);
        this.input = new SlotWater(tile, 1, 143, 21);
        this.addSlot(this.input);
        this.output = new SlotOutput(tile, 2, 143, 56);
        this.addSlot(this.output);
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((IInventory)inventoryplayer, k + i * 9 + 9, 8 + k * 18, 84 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((IInventory)inventoryplayer, j, 8 + j * 18, 142));
        }
    }

    public void func_75132_a(ICrafting icrafting) {
        super.func_75132_a(icrafting);
        this.tile.getTankManager().initGuiData(this, icrafting, 0);
        this.tile.getTankManager().initGuiData(this, icrafting, 1);
        icrafting.func_71112_a((Container)this, 10, Math.round(this.tile.burnTime));
        icrafting.func_71112_a((Container)this, 11, Math.round(this.tile.currentItemBurnTime));
        icrafting.func_71112_a((Container)this, 12, Math.round(this.tile.energy));
        icrafting.func_71112_a((Container)this, 13, Math.round(this.tile.currentOutput * 100.0f));
        icrafting.func_71112_a((Container)this, 14, Math.round(this.tile.heat));
    }

    public void func_75142_b() {
        super.func_75142_b();
        this.tile.getTankManager().updateGuiData(this, this.field_75149_d, 0);
        this.tile.getTankManager().updateGuiData(this, this.field_75149_d, 1);
        for (int var1 = 0; var1 < this.field_75149_d.size(); ++var1) {
            ICrafting var2 = (ICrafting)this.field_75149_d.get(var1);
            if (this.lastBurnTime != this.tile.burnTime) {
                var2.func_71112_a((Container)this, 10, Math.round(this.tile.burnTime));
            }
            if (this.lastItemBurnTime != this.tile.currentItemBurnTime) {
                var2.func_71112_a((Container)this, 11, Math.round(this.tile.currentItemBurnTime));
            }
            if (this.lastEnergy != this.tile.energy) {
                var2.func_71112_a((Container)this, 12, Math.round(this.tile.energy));
            }
            if (this.lastOutput != this.tile.currentOutput) {
                var2.func_71112_a((Container)this, 13, Math.round(this.tile.currentOutput * 100.0f));
            }
            if (this.lastHeat == this.tile.heat) continue;
            var2.func_71112_a((Container)this, 14, Math.round(this.tile.heat));
        }
        this.lastBurnTime = this.tile.burnTime;
        this.lastItemBurnTime = this.tile.currentItemBurnTime;
        this.lastEnergy = this.tile.energy;
        this.lastOutput = this.tile.currentOutput;
        this.lastHeat = this.tile.heat;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        this.tile.getTankManager().processGuiUpdate(id, value);
        switch (id) {
            case 10: {
                this.tile.burnTime = value;
                break;
            }
            case 11: {
                this.tile.currentItemBurnTime = value;
                break;
            }
            case 12: {
                this.tile.energy = value;
                break;
            }
            case 13: {
                this.tile.currentOutput = (float)value / 100.0f;
                break;
            }
            case 14: {
                this.tile.heat = value;
            }
        }
    }
}

