/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import buildcraft.api.inventory.ISpecialInventory;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.IItemTransfer;
import mods.railcraft.common.carts.CartContainerBase;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public abstract class CartMaintanceBase
extends CartContainerBase
implements ISpecialInventory {
    protected static final double DRAG_FACTOR = 0.9;
    protected static final float MAX_SPEED = 0.1f;
    private static final int BLINK_DURATION = 3;
    private static final int DATA_ID_BLINK = 25;
    protected final StandaloneInventory patternInv = new StandaloneInventory(6, this);

    public CartMaintanceBase(World world) {
        super(world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(25, (Object)new Byte(0));
    }

    public IInventory getPattern() {
        return this.patternInv;
    }

    public int func_70302_i_() {
        return 1;
    }

    protected void blink() {
        this.field_70180_af.func_75692_b(25, (Object)3);
    }

    protected void setBlink(byte blink) {
        this.field_70180_af.func_75692_b(25, (Object)blink);
    }

    protected byte getBlink() {
        return this.field_70180_af.func_75683_a(25);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (Game.isNotHost(this.field_70170_p)) {
            return;
        }
        if (this.isBlinking()) {
            this.setBlink((byte)(this.getBlink() - 1));
        }
    }

    @Override
    public List getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getCartItem());
        return items;
    }

    protected void stockItems(int slotReplace, int slotStock) {
        ItemStack stackReplace = this.patternInv.func_70301_a(slotReplace);
        ItemStack stackStock = this.func_70301_a(slotStock);
        if (stackStock != null && !InvTools.isItemEqual(stackReplace, stackStock)) {
            CartTools.offerOrDropItem((EntityMinecart)this, stackStock);
            this.func_70299_a(slotStock, null);
        }
        if (stackReplace == null) {
            return;
        }
        stackStock = this.func_70301_a(slotStock);
        EntityMinecart link_A = LinkageManager.instance().getLinkedCartA((EntityMinecart)this);
        EntityMinecart link_B = LinkageManager.instance().getLinkedCartB((EntityMinecart)this);
        if (stackStock == null || stackStock.field_77994_a < stackStock.func_77976_d()) {
            ItemStack stack = null;
            if (link_A instanceof IItemTransfer && (stack = ((IItemTransfer)link_A).requestItem((Object)this, stackReplace)) != null) {
                if (stackStock == null) {
                    this.func_70299_a(slotStock, stack);
                } else {
                    ++stackStock.field_77994_a;
                }
            }
            if (stack == null && link_B instanceof IItemTransfer && (stack = ((IItemTransfer)link_B).requestItem((Object)this, stackReplace)) != null) {
                if (stackStock == null) {
                    this.func_70299_a(slotStock, stack);
                } else {
                    ++stackStock.field_77994_a;
                }
            }
        }
    }

    public boolean canBeRidden() {
        return false;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        return new ItemStack[0];
    }

    @Override
    public double getDrag() {
        return 0.9;
    }

    public float getMaxCartSpeedOnRail() {
        return 0.1f;
    }

    public boolean isBlinking() {
        return this.field_70180_af.func_75683_a(25) > 0;
    }

    protected void func_70014_b(NBTTagCompound data) {
        super.func_70014_b(data);
        this.patternInv.writeToNBT("patternInv", data);
    }

    protected void func_70037_a(NBTTagCompound data) {
        super.func_70037_a(data);
        this.patternInv.readFromNBT("patternInv", data);
    }
}

