/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import mods.railcraft.api.events.CartLockdownEvent;
import mods.railcraft.api.tracks.ITrackLockdown;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.carts.Train;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public abstract class TrackLockingBase
extends TrackBaseRailcraft
implements ITrackLockdown,
ITrackPowered {
    protected static double START_BOOST = 0.04;
    protected static double BOOST_FACTOR = 0.06;
    protected boolean powered = false;
    private EntityMinecart lockedCart;
    protected byte prevDelay = 0;
    protected byte delay = 0;
    private UUID uuid;

    @Override
    public Icon getIcon() {
        if (this.isPowered() || this.delay > 0) {
            return this.getIcon(0);
        }
        return this.getIcon(1);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public EntityMinecart getCurrentCart() {
        return this.lockedCart;
    }

    @Override
    public void onBlockRemoved() {
        super.onBlockRemoved();
        this.setCurrentCart(null);
    }

    private UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        return this.uuid;
    }

    protected void setCurrentCart(EntityMinecart cart) {
        if (this.lockedCart != cart && this.lockedCart != null) {
            Train train = LinkageManager.instance().getTrain(this.lockedCart);
            train.removeLockingTrack(this.getUUID());
        }
        this.lockedCart = cart;
    }

    protected void lockCart(EntityMinecart cart) {
        if (cart != null) {
            Train train = LinkageManager.instance().getTrain(cart);
            train.addLockingTrack(this.getUUID());
            MinecraftForge.EVENT_BUS.post((Event)new CartLockdownEvent.Lock(cart, this.getX(), this.getY(), this.getZ()));
        }
    }

    protected void releaseCart(EntityMinecart cart) {
        if (cart != null) {
            Train train = LinkageManager.instance().getTrain(cart);
            train.removeLockingTrack(this.getUUID());
            MinecraftForge.EVENT_BUS.post((Event)new CartLockdownEvent.Release(cart, this.getX(), this.getY(), this.getZ()));
        }
    }

    protected void checkCart(EntityMinecart cart) {
        if (this.delay > 0 && cart != this.lockedCart) {
            this.delay = 0;
            this.setCurrentCart(cart);
        }
    }

    protected byte getDelayTime() {
        return 3;
    }

    @Override
    public void releaseCart() {
        this.delay = (byte)10;
    }

    @Override
    public boolean isCartLockedDown(EntityMinecart cart) {
        return !this.powered && this.lockedCart == cart && this.delay == 0;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("powered", this.powered);
        data.func_74772_a("uuidHigh", this.getUUID().getMostSignificantBits());
        data.func_74772_a("uuidLow", this.getUUID().getLeastSignificantBits());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.powered = data.func_74767_n("powered");
        if (data.func_74764_b("uuidHigh")) {
            this.uuid = new UUID(data.func_74763_f("uuidHigh"), data.func_74763_f("uuidLow"));
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeByte(this.delay);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
        this.delay = data.readByte();
        this.markBlockNeedsUpdate();
    }
}

