/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.railcraft.api.core.items.ITrackItem;
import mods.railcraft.api.tracks.ITrackCustomPlaced;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.TrackRegistry;
import mods.railcraft.api.tracks.TrackSpec;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.blocks.tracks.TrackFactory;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class ItemTrack
extends ItemBlock
implements ITrackItem {
    private String textureFile = "";

    public ItemTrack(int id) {
        super(id);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77655_b("railcraft.track");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77617_a(int damage) {
        TrackSpec trackSpec = TrackRegistry.getTrackSpec(damage);
        if (trackSpec == null) {
            return Block.field_72056_aG.func_71858_a(0, 0);
        }
        return trackSpec.getIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94901_k() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister par1IconRegister) {
    }

    public int func_77647_b(int i) {
        return 0;
    }

    public String func_77667_c(ItemStack stack) {
        return TrackRegistry.getTrackSpec(stack.func_77960_j()).getTrackTag();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        super.func_77624_a(stack, player, list, advanced);
        TrackSpec spec = TrackRegistry.getTrackSpec(stack.func_77960_j());
        try {
            List tips = spec.getItemToolTip();
            if (tips != null) {
                list.addAll(tips);
            }
        }
        catch (Throwable error) {
            Game.logErrorAPI("Railcraft", error);
        }
    }

    @Override
    public int getPlacedBlockId() {
        return RailcraftBlocks.getBlockTrack().field_71990_ca;
    }

    @Override
    public boolean isPlacedTileEntity(ItemStack stack, TileEntity tile) {
        TileTrack track;
        return tile instanceof TileTrack && (track = (TileTrack)tile).getTrackInstance().getTrackSpec().getTrackId() == stack.func_77960_j();
    }

    @Override
    public boolean placeTrack(ItemStack stack, World world, int i, int j, int k) {
        return this.placeTrack(stack, world, i, j, k, 1);
    }

    private boolean placeTrack(ItemStack stack, World world, int i, int j, int k, int side) {
        Block blockTrack = RailcraftBlocks.getBlockTrack();
        if (blockTrack == null) {
            return false;
        }
        if (j >= world.func_72800_K() - 1) {
            return false;
        }
        if (stack == null || !(stack.func_77973_b() instanceof ItemTrack)) {
            return false;
        }
        TrackSpec spec = TrackRegistry.getTrackSpec(stack.func_77960_j());
        ITrackInstance track = spec.createInstanceFromSpec();
        boolean canPlace = world.func_72931_a(blockTrack.field_71990_ca, i, j, k, true, side, null, stack);
        canPlace = track instanceof ITrackCustomPlaced ? (canPlace &= ((ITrackCustomPlaced)track).canPlaceRailAt(world, i, j, k)) : (canPlace &= world.isBlockSolidOnSide(i, j - 1, k, ForgeDirection.UP));
        if (canPlace) {
            boolean placed = world.func_94575_c(i, j, k, blockTrack.field_71990_ca);
            if (placed) {
                if (world.func_72798_a(i, j, k) == blockTrack.field_71990_ca) {
                    TileTrack tile = TrackFactory.makeTrackTile(track);
                    world.func_72837_a(i, j, k, (TileEntity)tile);
                    blockTrack.func_85105_g(world, i, j, k, 0);
                    world.func_72845_h(i, j, k);
                }
                world.func_72908_a((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), blockTrack.field_72020_cn.func_72675_d(), (blockTrack.field_72020_cn.func_72677_b() + 1.0f) / 2.0f, blockTrack.field_72020_cn.func_72678_c() * 0.8f);
            }
            return true;
        }
        return false;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        if (stack.field_77994_a <= 0) {
            return false;
        }
        int id = world.func_72798_a(x, y, z);
        if (id == Block.field_72037_aS.field_71990_ca) {
            side = 1;
        } else if (!(id == Block.field_71998_bu.field_71990_ca || id == Block.field_71962_X.field_71990_ca || id == Block.field_71961_Y.field_71990_ca || Block.field_71973_m[id] != null && Block.field_71973_m[id].isBlockReplaceable(world, x, y, z))) {
            if (side == 0) {
                --y;
            }
            if (side == 1) {
                ++y;
            }
            if (side == 2) {
                --z;
            }
            if (side == 3) {
                ++z;
            }
            if (side == 4) {
                --x;
            }
            if (side == 5) {
                ++x;
            }
        }
        if (player != null && !player.func_82247_a(x, y, z, side, stack)) {
            return false;
        }
        boolean success = this.placeTrack(stack, world, x, y, z, side);
        if (success) {
            Block blockTrack = RailcraftBlocks.getBlockTrack();
            if (player != null) {
                blockTrack.func_71860_a(world, x, y, z, (EntityLiving)player, stack);
            }
            --stack.field_77994_a;
        }
        return success;
    }
}

