/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.signals.DualSignalReceiver;
import mods.railcraft.api.signals.IReceiverTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SignalController;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.IDualHeadSignal;
import mods.railcraft.common.blocks.signals.TileSignalBase;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileSignalDualHeadDistantSignal
extends TileSignalBase
implements IReceiverTile,
IDualHeadSignal {
    private static final float SIZE = 0.15f;
    private final DualSignalReceiver receiver = new DualSignalReceiver(this.func_70303_b(), this);

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.DUAL_HEAD_DISTANT_SIGNAL;
    }

    @Override
    protected boolean isLit() {
        return this.getTopAspect().isLit() || this.getBottomAspect().isLit();
    }

    @Override
    protected boolean isBlinking() {
        return this.getTopAspect().isBlinkAspect() || this.getBottomAspect().isBlinkAspect();
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isNotHost(this.field_70331_k)) {
            this.receiver.tickClient();
            return;
        }
        this.receiver.tickServer();
        int numPairs = this.receiver.getNumPairs();
        boolean changed = false;
        switch (numPairs) {
            case 0: {
                changed |= this.receiver.setTopAspect(SignalAspect.BLINK_RED);
            }
            case 1: {
                changed |= this.receiver.setBottomAspect(SignalAspect.BLINK_RED);
            }
        }
        if (changed) {
            this.sendUpdateToClient();
        }
    }

    @Override
    public void onControllerAspectChange(SignalController con, SignalAspect aspect) {
        this.sendUpdateToClient();
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess world, int i, int j, int k) {
        this.func_70311_o().func_71905_a(0.15f, 0.0f, 0.15f, 0.85f, 1.0f, 0.85f);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)i + 0.15f), (double)j, (double)((float)k + 0.15f), (double)((float)i + 0.85f), (double)((float)j + 1.0f), (double)((float)k + 0.85f));
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)i + 0.15f), (double)j, (double)((float)k + 0.15f), (double)((float)(i + 1) - 0.15f), (double)(j + 1), (double)((float)(k + 1) - 0.15f));
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.receiver.writeToNBT(data);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.receiver.readFromNBT(data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.receiver.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.receiver.readPacketData(data);
    }

    @Override
    public DualSignalReceiver getReceiver() {
        return this.receiver;
    }

    @Override
    public SignalAspect getTopAspect() {
        return this.receiver.getTopAspect();
    }

    @Override
    public SignalAspect getBottomAspect() {
        return this.receiver.getBottomAspect();
    }

    @Override
    public SignalAspect getSignalAspect() {
        return this.receiver.getTopAspect();
    }
}

