/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.signals.IReceiverTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SignalController;
import mods.railcraft.api.signals.SignalReceiver;
import mods.railcraft.api.signals.SimpleSignalReceiver;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.TileSignalBase;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.nbt.NBTTagCompound;

public class TileSignalDistantSignal
extends TileSignalBase
implements IReceiverTile {
    private final SimpleSignalReceiver receiver = new SimpleSignalReceiver(this.func_70303_b(), this);

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.DISTANT_SIGNAL;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isNotHost(this.getWorld())) {
            this.receiver.tickClient();
            return;
        }
        this.receiver.tickServer();
        SignalAspect prevAspect = this.receiver.getAspect();
        if (this.receiver.isBeingPaired()) {
            this.receiver.setAspect(SignalAspect.BLINK_YELLOW);
        } else if (!this.receiver.isPaired()) {
            this.receiver.setAspect(SignalAspect.BLINK_RED);
        }
        if (prevAspect != this.receiver.getAspect()) {
            this.sendUpdateToClient();
        }
    }

    @Override
    public void onControllerAspectChange(SignalController con, SignalAspect aspect) {
        this.sendUpdateToClient();
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.receiver.writeToNBT(data);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.receiver.readFromNBT(data);
        if (data.func_74764_b("ControllerX")) {
            int cx = data.func_74762_e("ControllerX");
            int cy = data.func_74762_e("ControllerY");
            int cz = data.func_74762_e("ControllerZ");
            this.receiver.registerLegacyController(cx, cy, cz);
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.receiver.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.receiver.readPacketData(data);
    }

    @Override
    public SignalReceiver getReceiver() {
        return this.receiver;
    }

    @Override
    public SignalAspect getSignalAspect() {
        return this.receiver.getAspect();
    }
}

