/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.signals.IReceiverTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SignalController;
import mods.railcraft.api.signals.SimpleSignalReceiver;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.IAspectActionManager;
import mods.railcraft.common.blocks.signals.ItemSignalTuner;
import mods.railcraft.common.blocks.signals.TileBoxActionManager;
import mods.railcraft.common.blocks.signals.TileBoxBase;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.buildcraft.triggers.IAspectProvider;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class TileBoxReceiver
extends TileBoxActionManager
implements IAspectActionManager,
IGuiReturnHandler,
IReceiverTile,
IAspectProvider {
    protected int update = MiscTools.getRand().nextInt();
    private boolean prevBlinkState;
    private final SimpleSignalReceiver receiver = new SimpleSignalReceiver(this.func_70303_b(), this);

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.BOX_RECEIVER;
    }

    @Override
    public boolean blockActivated(int side, EntityPlayer player) {
        if (player.func_70093_af()) {
            return false;
        }
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() instanceof ItemSignalTuner) {
            return super.blockActivated(side, player);
        }
        if (Game.isHost(this.field_70331_k)) {
            GuiHandler.openGui(EnumGui.BOX_RECEIVER, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        return true;
    }

    @Override
    public void func_70316_g() {
        ++this.update;
        if (Game.isNotHost(this.getWorld())) {
            this.receiver.tickClient();
            if (this.receiver.getAspect().isBlinkAspect() && this.prevBlinkState != SignalAspect.isBlinkOn()) {
                this.prevBlinkState = SignalAspect.isBlinkOn();
                this.markBlockForUpdate();
            }
            return;
        }
        this.receiver.tickServer();
        SignalAspect prevAspect = this.receiver.getAspect();
        if (this.receiver.isBeingPaired()) {
            this.receiver.setAspect(SignalAspect.BLINK_YELLOW);
        } else if (!this.receiver.isPaired()) {
            this.receiver.setAspect(SignalAspect.BLINK_RED);
        }
        if (prevAspect != this.receiver.getAspect()) {
            this.updateNeighbors();
            this.sendUpdateToClient();
        }
    }

    @Override
    public void onControllerAspectChange(SignalController con, SignalAspect aspect) {
        this.updateNeighbors();
        this.sendUpdateToClient();
    }

    private void updateNeighbors() {
        int blockID = this.getBlockId();
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, blockID);
        for (int side = 2; side < 6; ++side) {
            ForgeDirection forgeSide = ForgeDirection.getOrientation((int)side);
            TileEntity tile = this.tileCache.getTileOnSide(forgeSide);
            if (!(tile instanceof TileBoxBase)) continue;
            TileBoxBase box = (TileBoxBase)tile;
            box.onNeighborStateChange(this);
        }
    }

    @Override
    public int getPowerOutput(int side) {
        TileEntity tile = MiscTools.getBlockTileEntityOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, MiscTools.getOppositeSide(side));
        if (tile instanceof TileBoxBase) {
            return 0;
        }
        return this.doesActionOnAspect(this.receiver.getAspect()) ? 15 : 0;
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.receiver.writeToNBT(data);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.receiver.readFromNBT(data);
        if (data.func_74764_b("ControllerX")) {
            int cx = data.func_74762_e("ControllerX");
            int cy = data.func_74762_e("ControllerY");
            int cz = data.func_74762_e("ControllerZ");
            this.receiver.registerLegacyController(cx, cy, cz);
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.receiver.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.receiver.readPacketData(data);
        this.markBlockForUpdate();
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        super.readGuiData(data, sender);
        this.updateNeighbors();
    }

    @Override
    public boolean connectToBoxAt(int i, int j, int k, int side) {
        TileEntity tile = this.field_70331_k.func_72796_p(i, j, k);
        if (tile instanceof TileBoxBase) {
            return ((TileBoxBase)tile).canReceiveAspect();
        }
        return false;
    }

    @Override
    public boolean isEmitingRedstone() {
        return this.doesActionOnAspect(this.receiver.getAspect());
    }

    @Override
    public void doActionOnAspect(SignalAspect aspect, boolean trigger) {
        super.doActionOnAspect(aspect, trigger);
        this.updateNeighbors();
    }

    @Override
    public SignalAspect getBoxSignalAspect() {
        return this.receiver.getAspect();
    }

    @Override
    public boolean canTransferAspect() {
        return true;
    }

    @Override
    public SimpleSignalReceiver getReceiver() {
        return this.receiver;
    }

    @Override
    public SignalAspect getTriggerAspect() {
        return this.getBoxSignalAspect();
    }
}

