/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import mods.railcraft.common.blocks.machine.ITankTile;
import mods.railcraft.common.blocks.machine.TileMultiBlockInventory;
import mods.railcraft.common.gui.slots.SlotLiquidContainer;
import mods.railcraft.common.liquids.TankManager;
import mods.railcraft.common.liquids.tanks.FakeTank;
import mods.railcraft.common.liquids.tanks.StandardTank;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public abstract class TileTank
extends TileMultiBlockInventory
implements ITankContainer,
ITankTile,
ISidedInventory {
    protected final TankManager tankManager = new TankManager();

    public TileTank(String name, int invNum, List patterns) {
        super(name, invNum, patterns);
    }

    @Override
    public IInventory getInventory() {
        return this;
    }

    @Override
    public TankManager getTankManager() {
        TileTank mBlock = (TileTank)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager;
        }
        return null;
    }

    @Override
    public StandardTank getTank() {
        TileTank mBlock = (TileTank)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager.getTank(0);
        }
        return null;
    }

    @Override
    public Slot getInputSlot(IInventory inv, int id, int x, int y) {
        return new SlotLiquidContainer(inv, id, x, y);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.drain(tankIndex, maxDrain, doDrain);
        }
        return null;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.fill(tankIndex, resource, doFill);
        }
        return 0;
    }

    public ILiquidTank[] getTanks(ForgeDirection side) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.getTanks();
        }
        return FakeTank.ARRAY;
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.getTank(0);
        }
        return FakeTank.INSTANCE;
    }

    public int[] func_94128_d(int side) {
        if (side == 1) {
            return new int[]{0};
        }
        return new int[]{1};
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    protected void onMasterReset() {
        super.onMasterReset();
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.tankManager.writeTanksToNBT(data);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.tankManager.readTanksFromNBT(data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.tankManager.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.tankManager.readPacketData(data);
    }
}

