/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import mods.railcraft.common.blocks.detector.DetectorFilter;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.buttons.IButtonTextureSet;
import mods.railcraft.common.gui.buttons.IMultiButtonState;
import mods.railcraft.common.gui.buttons.MultiButtonController;
import mods.railcraft.common.gui.buttons.StandardButtonTextureSets;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.liquids.LiquidManager;
import mods.railcraft.common.liquids.TankToolkit;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class DetectorTank
extends DetectorFilter {
    private final MultiButtonController buttonController = new MultiButtonController(ButtonState.ANALOG.ordinal(), ButtonState.values());

    public DetectorTank() {
        super(1);
    }

    public MultiButtonController getButtonController() {
        return this.buttonController;
    }

    public LiquidStack getFilterLiquid() {
        ItemStack filter = this.getFilters().func_70301_a(0);
        if (filter != null) {
            return LiquidManager.instance().getLiquidInContainer(filter);
        }
        return null;
    }

    @Override
    public int testCarts(List carts) {
        for (EntityMinecart cart : carts) {
            if (!(cart instanceof ITankContainer)) continue;
            TankToolkit tank = new TankToolkit((ITankContainer)cart);
            boolean liquidMatches = false;
            LiquidStack filterLiquid = this.getFilterLiquid();
            LiquidStack tankLiquid = tank.drain(ForgeDirection.UNKNOWN, 1, false);
            if (filterLiquid == null) {
                liquidMatches = true;
            } else if (filterLiquid.isLiquidEqual(tankLiquid)) {
                liquidMatches = true;
            } else if (tank.canPutLiquid(ForgeDirection.UNKNOWN, filterLiquid)) {
                liquidMatches = true;
            }
            boolean quantityMatches = false;
            ButtonState state = (ButtonState)this.buttonController.getButtonState();
            block0 : switch (state) {
                case VOID: {
                    quantityMatches = true;
                    break;
                }
                case EMPTY: {
                    if (filterLiquid != null && tank.isTankEmpty(filterLiquid)) {
                        quantityMatches = true;
                        break;
                    }
                    if (filterLiquid != null || !tank.areTanksEmpty()) break;
                    quantityMatches = true;
                    break;
                }
                case NOT_EMPTY: {
                    if (filterLiquid != null && tank.getLiquidQty(filterLiquid) > 0) {
                        quantityMatches = true;
                        break;
                    }
                    if (filterLiquid != null || !tank.isLiquidInTank()) break;
                    quantityMatches = true;
                    break;
                }
                case FULL: {
                    if (filterLiquid != null && tank.isTankFull(filterLiquid)) {
                        quantityMatches = true;
                        break;
                    }
                    if (filterLiquid != null || !tank.areTanksFull()) break;
                    quantityMatches = true;
                    break;
                }
                default: {
                    float level = filterLiquid != null ? tank.getLiquidLevel(filterLiquid) : tank.getLiquidLevel();
                    switch (state) {
                        case ANALOG: {
                            return (int)(15.0f * level);
                        }
                        case QUARTER: {
                            quantityMatches = level >= 0.25f;
                            break block0;
                        }
                        case HALF: {
                            quantityMatches = level >= 0.5f;
                            break block0;
                        }
                        case MOST: {
                            quantityMatches = level >= 0.75f;
                            break block0;
                        }
                        case LESS_THAN_QUARTER: {
                            quantityMatches = level < 0.25f;
                            break block0;
                        }
                        case LESS_THAN_HALF: {
                            quantityMatches = level < 0.5f;
                            break block0;
                        }
                        case LESS_THAN_MOST: {
                            quantityMatches = level < 0.75f;
                            break block0;
                        }
                        case LESS_THAN_FULL: {
                            quantityMatches = level < 1.0f;
                        }
                    }
                }
            }
            return liquidMatches && quantityMatches ? 15 : 0;
        }
        return 0;
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        this.openGui(EnumGui.DETECTOR_TANK, player);
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74774_a("state", (byte)this.buttonController.getCurrentState());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.buttonController.setCurrentState(data.func_74771_c("state"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.buttonController.getCurrentState());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.buttonController.setCurrentState(data.readByte());
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.buttonController.getCurrentState());
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.buttonController.setCurrentState(data.readByte());
    }

    @Override
    public EnumDetector getType() {
        return EnumDetector.TANK;
    }

    public static enum ButtonState implements IMultiButtonState
    {
        VOID("L = *"),
        EMPTY("L = 0%"),
        NOT_EMPTY("L > 0%"),
        FULL("L = 100%"),
        QUARTER("L >= 25%"),
        HALF("L >= 50%"),
        MOST("L >= 75%"),
        LESS_THAN_QUARTER("L < 25%"),
        LESS_THAN_HALF("L < 50%"),
        LESS_THAN_MOST("L < 75%"),
        LESS_THAN_FULL("L < 100%"),
        ANALOG("L = ~");

        private final String label;
        private ToolTip tip;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private ButtonState() {
            void label;
            this.label = label;
            this.tip = ToolTip.buildToolTip("gui.detector.tank.tip." + this.name().toLowerCase(Locale.ENGLISH).replace("_", "."), new String[0]);
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public IButtonTextureSet getTextureSet() {
            return StandardButtonTextureSets.LARGE_BUTTON;
        }

        @Override
        public ToolTip getToolTip() {
            return this.tip;
        }
    }
}

