/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.sounds;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.sounds.IBlockSoundProvider;
import mods.railcraft.common.util.sounds.SoundRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.StepSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundPool;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;

public class SoundHandler {
    private static SoundHandler instance;

    public static SoundHandler getInstance() {
        if (instance == null) {
            instance = new SoundHandler();
        }
        return instance;
    }

    private SoundHandler() {
    }

    @ForgeSubscribe
    public void loadSounds(SoundLoadEvent event) {
        SoundPool pool = event.manager.field_77379_b;
        this.addSound(pool, "locomotive/steam/whistle1.ogg");
        this.addSound(pool, "locomotive/steam/whistle2.ogg");
        this.addSound(pool, "locomotive/steam/whistle3.ogg");
        this.addSound(pool, "machine/steamburst.ogg");
        this.addSound(pool, "machine/steamhiss.ogg");
    }

    private void addSound(SoundPool pool, String path) {
        try {
            File sound = this.getSoundFile(path);
            if (sound == null) {
                throw new RuntimeException("Resource not found");
            }
            pool.func_77459_a(path, sound);
        }
        catch (Exception ex) {
            Game.logError("Failed to load sound: " + path, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getSoundFile(String path) {
        File soundFile;
        File resources = new File(Minecraft.func_71380_b(), "resources/railcraft/sounds/" + path.substring(0, path.lastIndexOf("/")));
        if (!resources.exists()) {
            resources.mkdirs();
        }
        if (!(soundFile = new File(resources, path.substring(path.lastIndexOf("/") + 1))).exists()) {
            InputStream is = null;
            FileOutputStream fos = null;
            try {
                is = Railcraft.class.getResourceAsStream("/mods/railcraft/client/sounds/" + path);
                fos = new FileOutputStream(soundFile);
                while (is.available() > 0) {
                    fos.write(is.read());
                }
                fos.close();
                is.close();
                File file = soundFile;
                return file;
            }
            catch (Exception ex) {
                Game.logError("Failed to extract sound file: " + path, ex);
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException ex) {}
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ex) {}
            }
        }
        return soundFile;
    }

    @ForgeSubscribe
    public void onPlaySound(PlaySoundEvent event) {
        int iz;
        int iy;
        int ix;
        StepSound sound;
        World world;
        String soundName = event.name;
        if (soundName != null && soundName.contains("railcraft") && (world = Railcraft.getProxy().getClientWorld()) != null && (sound = this.getBlockSound(world, ix = MathHelper.func_76141_d((float)event.x), iy = MathHelper.func_76141_d((float)event.y), iz = MathHelper.func_76141_d((float)event.z))) != null) {
            String newName = sound.func_72675_d();
            if (soundName.contains("dig")) {
                newName = sound.func_72676_a();
            } else if (soundName.contains("place")) {
                newName = sound.func_82593_b();
            }
            event.manager.func_77364_b(newName, event.x, event.y, event.z, event.volume, event.pitch * sound.func_72678_c());
            event.result = null;
        }
    }

    @ForgeSubscribe
    public void onPlaySoundAtEntity(PlaySoundAtEntityEvent event) {
        int iz;
        int iy;
        int ix;
        StepSound sound;
        World world;
        String soundName = event.name;
        Entity entity = event.entity;
        if (soundName != null && soundName.equals("step.railcraft") && (world = entity.field_70170_p) != null && (sound = this.getBlockSound(world, ix = MathHelper.func_76128_c((double)entity.field_70165_t), iy = MathHelper.func_76128_c((double)(entity.field_70163_u - 0.2 - (double)entity.field_70129_M)), iz = MathHelper.func_76128_c((double)entity.field_70161_v))) != null) {
            world.func_72956_a(entity, sound.func_72675_d(), event.volume, event.pitch * sound.func_72678_c());
            event.setCanceled(true);
        }
    }

    private StepSound getBlockSound(World world, int x, int y, int z) {
        int blockID = world.func_72798_a(x, y, z);
        Block block = Block.field_71973_m[blockID];
        if (block instanceof IBlockSoundProvider) {
            return ((IBlockSoundProvider)block).getSound(world, x, y, z);
        }
        int meta = world.func_72805_g(x, y, z);
        return SoundRegistry.getSound(blockID, meta);
    }
}

