/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import java.util.HashMap;
import java.util.Map;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.common.util.misc.FakeBlockRenderInfo;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

public class LiquidRenderer {
    private static Map flowingRenderCache = new HashMap();
    private static Map stillRenderCache = new HashMap();
    public static final int DISPLAY_STAGES = 100;
    private static final FakeBlockRenderInfo liquidBlock = new FakeBlockRenderInfo();

    public static Icon getLiquidTexture(LiquidStack liquid) {
        if (liquid == null || liquid.itemID <= 0) {
            return null;
        }
        LiquidStack canon = liquid.canonical();
        if (canon == null) {
            throw new LiquidCanonException(liquid);
        }
        Icon icon = canon.getRenderingIcon();
        if (icon == null) {
            throw new LiquidTextureException(liquid);
        }
        return icon;
    }

    public static String setupFlowingLiquidTexture(LiquidStack liquid, Icon[] texArray) {
        Icon top;
        if (liquid == null || liquid.amount <= 0 || liquid.itemID <= 0) {
            return null;
        }
        ItemStack stack = liquid.asItemStack();
        LiquidStack canon = liquid.canonical();
        if (canon == null) {
            throw new LiquidCanonException(liquid);
        }
        String texSheet = canon.getTextureSheet();
        Icon side = top = canon.getRenderingIcon();
        if (stack.func_77973_b() instanceof ItemBlock) {
            top = Block.field_71973_m[stack.field_77993_c].func_71858_a(0, 0);
            side = Block.field_71973_m[stack.field_77993_c].func_71858_a(2, 0);
            texSheet = "/terrain.png";
        }
        if (top == null || side == null) {
            throw new LiquidTextureException(canon);
        }
        texArray[0] = top;
        texArray[1] = top;
        texArray[2] = side;
        texArray[3] = side;
        texArray[4] = side;
        texArray[5] = side;
        return texSheet;
    }

    public static int[] getLiquidDisplayLists(LiquidStack liquid) {
        return LiquidRenderer.getLiquidDisplayLists(liquid, false);
    }

    public static int[] getLiquidDisplayLists(LiquidStack liquid, boolean flowing) {
        if (liquid == null) {
            return null;
        }
        if ((liquid = liquid.canonical()) == null) {
            throw new LiquidCanonException(liquid);
        }
        Map cache = flowing ? flowingRenderCache : stillRenderCache;
        int[] diplayLists = (int[])cache.get(liquid);
        if (diplayLists != null) {
            return diplayLists;
        }
        diplayLists = new int[100];
        LiquidRenderer.liquidBlock.texture[0] = null;
        if (liquid.itemID < Block.field_71973_m.length && Block.field_71973_m[liquid.itemID] != null) {
            LiquidRenderer.liquidBlock.template = Block.field_71973_m[liquid.itemID];
            if (!flowing) {
                LiquidRenderer.liquidBlock.texture[0] = LiquidRenderer.getLiquidTexture(liquid);
            }
        } else if (Item.field_77698_e[liquid.itemID] != null) {
            LiquidRenderer.liquidBlock.template = Block.field_71943_B;
            LiquidRenderer.liquidBlock.texture[0] = LiquidRenderer.getLiquidTexture(liquid);
        } else {
            return null;
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2884);
        ItemStack stack = liquid.asItemStack();
        int color = stack.func_77973_b().func_82790_a(stack, 0);
        float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
        float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
        float c3 = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)c1, (float)c2, (float)c3, (float)1.0f);
        for (int s = 0; s < 100; ++s) {
            diplayLists[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)diplayLists[s], (int)4864);
            LiquidRenderer.liquidBlock.minX = 0.01f;
            LiquidRenderer.liquidBlock.minY = 0.0f;
            LiquidRenderer.liquidBlock.minZ = 0.01f;
            LiquidRenderer.liquidBlock.maxX = 0.99f;
            LiquidRenderer.liquidBlock.maxY = (float)s / 100.0f;
            LiquidRenderer.liquidBlock.maxZ = 0.99f;
            RenderFakeBlock.renderBlockForEntity(liquidBlock, null, 0, 0, 0, false, true);
            GL11.glEndList();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2896);
        cache.put(liquid, diplayLists);
        return diplayLists;
    }

    static {
        LiquidRenderer.liquidBlock.texture = new Icon[1];
    }

    public static class LiquidCanonException
    extends RuntimeException {
        private final LiquidStack liquid;

        public LiquidCanonException(LiquidStack liquid) {
            this.liquid = liquid;
        }

        @Override
        public String getMessage() {
            String liquidName = LiquidDictionary.findLiquidName((LiquidStack)this.liquid);
            if (liquidName == null) {
                liquidName = String.format("ID: %d Meta: %d", this.liquid.itemID, this.liquid.itemMeta);
            }
            return String.format("Liquid %s is not registered with the Liquid Dictionary. Please contact the author of the mod the liquid came from.", liquidName);
        }
    }

    public static class LiquidTextureException
    extends RuntimeException {
        private final LiquidStack liquid;

        public LiquidTextureException(LiquidStack liquid) {
            this.liquid = liquid;
        }

        @Override
        public String getMessage() {
            String liquidName = LiquidDictionary.findLiquidName((LiquidStack)this.liquid);
            if (liquidName == null) {
                liquidName = String.format("ID: %d Meta: %d", this.liquid.itemID, this.liquid.itemMeta);
            }
            return String.format("Liquid %s has no icon. Please contact the author of the mod the liquid came from.", liquidName);
        }
    }
}

