/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.buttons.GuiBetterButton;
import mods.railcraft.client.gui.buttons.GuiButtonRoutingTableNextPage;
import mods.railcraft.common.items.ItemRoutingTable;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.util.network.PacketCurrentItemNBT;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiRoutingTable
extends GuiScreen {
    public static final String TEXTURE = "/mods/railcraft/textures/gui/routing_table.png";
    public static final int MANUAL_PAGES = 6;
    public static final int MAX_PAGES = 50;
    public static final int WRAP_WIDTH = 226;
    private final EntityPlayer player;
    private final ItemStack bookStack;
    private final boolean editable = true;
    private boolean bookModified;
    private boolean editingTitle;
    private boolean readingManual;
    private int updateCount;
    private int bookImageWidth = 256;
    private int bookImageHeight = 192;
    private int currPage;
    private int currLine;
    private int currChar;
    private final List bookPages;
    private String bookTitle = "";
    private GuiButtonRoutingTableNextPage buttonNextPage;
    private GuiButtonRoutingTableNextPage buttonPreviousPage;
    private GuiBetterButton buttonDone;
    private GuiBetterButton buttonSign;
    private GuiBetterButton buttonHelp;

    public GuiRoutingTable(EntityPlayer player, ItemStack stack) {
        this.player = player;
        this.bookStack = stack;
        List pages = ItemRoutingTable.getPages(stack);
        if (pages == null) {
            this.bookPages = new LinkedList();
            this.initPages();
        } else {
            this.bookPages = pages;
            if (this.bookPages.isEmpty()) {
                this.initPages();
            }
        }
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            this.bookTitle = nbt.func_74779_i("title");
        }
    }

    private void initPages() {
        LinkedList<String> page = new LinkedList<String>();
        this.bookPages.add(page);
        page.add("");
    }

    public void func_73876_c() {
        super.func_73876_c();
        ++this.updateCount;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_73887_h.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        ArrayList<GuiBetterButton> buttons = new ArrayList<GuiBetterButton>();
        this.buttonSign = new GuiBetterButton(3, 0, 4 + this.bookImageHeight, 65, RailcraftLanguage.translate("routing.table.name"));
        buttons.add(this.buttonSign);
        this.buttonHelp = new GuiBetterButton(4, 0, 4 + this.bookImageHeight, 65, RailcraftLanguage.translate("gui.help"));
        buttons.add(this.buttonHelp);
        this.buttonDone = new GuiBetterButton(0, 0, 4 + this.bookImageHeight, 65, StatCollector.func_74838_a((String)"gui.done"));
        buttons.add(this.buttonDone);
        GuiTools.newButtonRowAuto(this.field_73887_h, this.field_73880_f / 2 - 100, 200, buttons);
        int xOffset = (this.field_73880_f - this.bookImageWidth) / 2;
        int yOffset = 2;
        this.buttonNextPage = new GuiButtonRoutingTableNextPage(1, xOffset + 200, yOffset + 154, true);
        this.field_73887_h.add(this.buttonNextPage);
        this.buttonPreviousPage = new GuiButtonRoutingTableNextPage(2, xOffset + 30, yOffset + 154, false);
        this.field_73887_h.add(this.buttonPreviousPage);
        this.updateButtons();
    }

    public void func_73874_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private int getMaxPages() {
        if (this.readingManual) {
            return 6;
        }
        if (this.editingTitle) {
            return 0;
        }
        return 50;
    }

    private void updateButtons() {
        this.buttonNextPage.field_73748_h = !this.editingTitle && this.currPage < this.getMaxPages() - 1;
        this.buttonPreviousPage.field_73748_h = !this.editingTitle && this.currPage > 0;
        this.buttonHelp.field_73744_e = this.readingManual ? StatCollector.func_74838_a((String)"gui.back") : RailcraftLanguage.translate("gui.help");
        this.buttonSign.field_73744_e = this.editingTitle ? StatCollector.func_74838_a((String)"gui.back") : RailcraftLanguage.translate("routing.table.name");
    }

    private void sendBookToServer() {
        ((Object)((Object)this)).getClass();
        if (this.bookModified) {
            this.cleanEmptyLines();
            NBTTagList data = new NBTTagList("pages");
            ListIterator pageIt = this.bookPages.listIterator();
            while (pageIt.hasNext()) {
                List page = (List)pageIt.next();
                NBTTagList pageNBT = new NBTTagList();
                data.func_74742_a((NBTBase)pageNBT);
                ListIterator lineIt = page.listIterator();
                while (lineIt.hasNext()) {
                    String line = (String)lineIt.next();
                    pageNBT.func_74742_a((NBTBase)new NBTTagString("" + lineIt.previousIndex(), line));
                }
            }
            NBTTagCompound nbt = this.bookStack.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound("tag");
                this.bookStack.func_77982_d(nbt);
            }
            nbt.func_74782_a("pages", (NBTBase)data);
            nbt.func_74778_a("author", this.player.field_71092_bJ);
            if (!this.bookTitle.equals("")) {
                nbt.func_74778_a("title", this.bookTitle);
            }
            PacketCurrentItemNBT pkt = new PacketCurrentItemNBT(this.player, this.bookStack);
            PacketDispatcher.sendPacketToServer((Packet)pkt.getPacket());
        }
    }

    private void cleanEmptyLines() {
        Iterator pageIt = this.bookPages.iterator();
        while (pageIt.hasNext()) {
            List page = (List)pageIt.next();
            Iterator lineIt = page.iterator();
            while (lineIt.hasNext()) {
                String line = (String)lineIt.next();
                if (!line.equals("")) continue;
                lineIt.remove();
            }
            if (!page.isEmpty()) continue;
            pageIt.remove();
        }
    }

    protected void func_73875_a(GuiButton button) {
        if (button.field_73742_g) {
            if (button == this.buttonDone) {
                this.field_73882_e.func_71373_a((GuiScreen)null);
                this.sendBookToServer();
            } else if (button == this.buttonSign) {
                this.editingTitle = !this.editingTitle;
                this.readingManual = false;
                this.currPage = 0;
                this.currLine = 0;
                this.currChar = 0;
            } else if (button == this.buttonHelp) {
                this.readingManual = !this.readingManual;
                this.editingTitle = false;
                this.currPage = 0;
                this.currLine = 0;
                this.currChar = 0;
            } else if (button == this.buttonNextPage) {
                if (this.readingManual) {
                    if (this.currPage < 5) {
                        ++this.currPage;
                        this.currLine = 0;
                        this.currChar = 0;
                    }
                } else if (this.currPage < this.bookPages.size() - 1) {
                    ++this.currPage;
                    this.currLine = 0;
                    this.currChar = 0;
                } else {
                    this.addNewPage();
                    if (this.currPage < this.bookPages.size() - 1) {
                        ++this.currPage;
                        this.currLine = 0;
                        this.currChar = 0;
                    }
                }
            } else if (button == this.buttonPreviousPage && this.currPage > 0) {
                --this.currPage;
                this.currLine = 0;
                this.currChar = 0;
            }
            this.updateButtons();
        }
    }

    private void addNewPage() {
        if (this.bookPages.size() < 50) {
            LinkedList<String> page = new LinkedList<String>();
            page.add("");
            this.bookPages.add(page);
            this.bookModified = true;
        }
    }

    protected void func_73869_a(char c, int key) {
        super.func_73869_a(c, key);
        if (!this.readingManual) {
            if (this.editingTitle) {
                this.keyTypedInTitle(c, key);
            } else {
                this.keyTypedInBook(c, key);
            }
        }
    }

    private void keyTypedInBook(char c, int key) {
        String text;
        switch (c) {
            case '\u0016': {
                this.addToBook(GuiScreen.func_73870_l());
                return;
            }
        }
        switch (key) {
            case 14: {
                String text2 = this.getLine(this.currLine);
                if (text2.length() > 0 && this.currChar > 0) {
                    this.setLine(this.currPage, this.currLine, text2.substring(0, this.currChar - 1) + text2.substring(this.currChar--));
                } else if (this.currLine > 0) {
                    List page = this.getPage(this.currPage);
                    page.remove(this.currLine--);
                    this.currChar = this.getLine(this.currLine).length();
                }
                return;
            }
            case 211: {
                String text3 = this.getLine(this.currLine);
                if (this.currChar < text3.length()) {
                    this.setLine(this.currPage, this.currLine, text3.substring(0, this.currChar) + text3.substring(this.currChar + 1));
                    return;
                }
                List page = this.getPage(this.currPage);
                if (this.currLine < page.size() - 1) {
                    if (text3.length() == 0) {
                        page.remove(this.currLine);
                        this.currChar = 0;
                        return;
                    }
                    text3 = this.getLine(this.currLine + 1);
                    if (text3.length() == 0) {
                        page.remove(this.currLine + 1);
                        return;
                    }
                }
                return;
            }
            case 28: {
                List page = this.getPage(this.currPage);
                if (page.size() < 13) {
                    String line = this.getLine(this.currLine);
                    this.setLine(this.currPage, this.currLine, line.substring(0, this.currChar));
                    page.add(++this.currLine, line.substring(this.currChar));
                    this.currChar = 0;
                }
                return;
            }
            case 207: {
                this.currChar = this.getLine(this.currLine).length();
                return;
            }
            case 199: {
                this.currChar = 0;
                return;
            }
            case 209: {
                this.currLine = this.getPage(this.currPage).size() - 1;
                this.currChar = Math.min(this.currChar, this.getLine(this.currLine).length());
                return;
            }
            case 201: {
                this.currLine = 0;
                this.currChar = Math.min(this.currChar, this.getLine(this.currLine).length());
                return;
            }
            case 208: {
                List page = this.getPage(this.currPage);
                if (this.currLine < page.size() - 1) {
                    this.currChar = this.getLine(++this.currLine).length();
                }
                return;
            }
            case 200: {
                if (this.currLine > 0) {
                    this.currChar = this.getLine(--this.currLine).length();
                }
                return;
            }
            case 205: {
                String line = this.getLine(this.currLine);
                if (this.currChar < line.length()) {
                    ++this.currChar;
                }
                return;
            }
            case 203: {
                if (this.currChar > 0) {
                    --this.currChar;
                }
                return;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)c) && (text = this.getLine(this.currLine)).length() < 37) {
            StringBuilder builder = new StringBuilder(text);
            this.setLine(this.currPage, this.currLine, builder.insert(this.currChar++, c).toString());
        }
    }

    private void keyTypedInTitle(char c, int key) {
        switch (key) {
            case 14: {
                if (this.bookTitle.length() > 0) {
                    this.bookTitle = this.bookTitle.substring(0, this.bookTitle.length() - 1);
                    this.updateButtons();
                }
                return;
            }
            case 28: {
                if (this.bookTitle.length() > 0) {
                    this.sendBookToServer();
                    this.field_73882_e.func_71373_a((GuiScreen)null);
                }
                return;
            }
        }
        if (this.bookTitle.length() < 16 && ChatAllowedCharacters.func_71566_a((char)c)) {
            this.bookTitle = this.bookTitle + Character.toString(c);
            this.updateButtons();
            this.bookModified = true;
        }
    }

    private List getPage(int page) {
        if (this.bookPages.isEmpty()) {
            this.initPages();
        }
        return (List)this.bookPages.get(page);
    }

    private String getLine(int line) {
        List page = this.getPage(this.currPage);
        return (String)page.get(line);
    }

    private void setLine(int pageNum, int lineNum, String string) {
        if (pageNum >= 0 && pageNum < this.bookPages.size()) {
            List page = (List)this.bookPages.get(pageNum);
            page.set(lineNum, string);
            this.bookModified = true;
        }
    }

    private void addToBook(String string) {
        String currentText = this.getLine(this.currLine);
        String newText = currentText + string;
        if (newText.length() < 37) {
            this.setLine(this.currPage, this.currLine, newText);
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b(TEXTURE);
        int xOffset = (this.field_73880_f - this.bookImageWidth) / 2;
        int yOffset = 2;
        this.func_73729_b(xOffset, yOffset, 0, 0, this.bookImageWidth, this.bookImageHeight);
        if (this.editingTitle) {
            String title = this.bookTitle;
            ((Object)((Object)this)).getClass();
            title = this.updateCount / 6 % 2 == 0 ? title + "" + EnumChatFormatting.BLACK + "_" : title + "" + EnumChatFormatting.GRAY + "_";
            String s1 = StatCollector.func_74838_a((String)"book.editTitle");
            int l = this.field_73886_k.func_78256_a(s1);
            this.field_73886_k.func_78276_b(s1, xOffset + 36 + (116 - l) / 2, yOffset + 16 + 16, 0);
            int i1 = this.field_73886_k.func_78256_a(title);
            this.field_73886_k.func_78276_b(title, xOffset + 36 + (116 - i1) / 2, yOffset + 48, 0);
            String s2 = String.format(StatCollector.func_74838_a((String)"book.byAuthor"), this.player.field_71092_bJ);
            int j1 = this.field_73886_k.func_78256_a(s2);
            this.field_73886_k.func_78276_b(EnumChatFormatting.DARK_GRAY + s2, xOffset + 36 + (116 - j1) / 2, yOffset + 48 + 10, 0);
        } else if (this.readingManual) {
            this.field_73886_k.func_78276_b(RailcraftLanguage.translate("routing.table.manual.title"), xOffset + 45, yOffset + 16, 0);
            String pageNumString = String.format(StatCollector.func_74838_a((String)"book.pageIndicator"), this.currPage + 1, 6);
            int pageNumStringWidth = this.field_73886_k.func_78256_a(pageNumString);
            this.field_73886_k.func_78276_b(pageNumString, xOffset - pageNumStringWidth + this.bookImageWidth - 44, yOffset + 16, 0);
            if (this.currPage < 0 || this.currPage >= 6) {
                return;
            }
            String text = RailcraftLanguage.translate("routing.table.manual.page" + (this.currPage + 1));
            this.field_73886_k.func_78279_b(text, xOffset + 16, yOffset + 16 + 16, 226, 0);
        } else {
            String pageNumString = String.format(StatCollector.func_74838_a((String)"book.pageIndicator"), this.currPage + 1, this.bookPages.size());
            int pageNumStringWidth = this.field_73886_k.func_78256_a(pageNumString);
            this.field_73886_k.func_78276_b(pageNumString, xOffset - pageNumStringWidth + this.bookImageWidth - 44, yOffset + 16, 0);
            if (this.currPage < 0 || this.currPage >= this.bookPages.size()) {
                return;
            }
            StringBuilder text = new StringBuilder();
            List page = (List)this.bookPages.get(this.currPage);
            ListIterator it = page.listIterator();
            while (it.hasNext()) {
                String line = (String)it.next();
                text.append(EnumChatFormatting.BLACK);
                int start = text.length();
                text.append(line).append(" ");
                if (it.previousIndex() == this.currLine && this.updateCount / 6 % 2 == 0) {
                    text.insert(start + this.currChar, EnumChatFormatting.UNDERLINE.toString());
                    text.insert(start + this.currChar + 3, EnumChatFormatting.BLACK.toString());
                }
                text.append("\n");
            }
            this.field_73886_k.func_78279_b(text.toString(), xOffset + 16, yOffset + 16 + 16, 226, 0);
        }
        super.func_73863_a(par1, par2, par3);
    }
}

