/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.tracks;

import cpw.mods.fml.relauncher.FMLRelaunchLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import mods.railcraft.api.core.ITextureLoader;
import mods.railcraft.api.tracks.TrackSpec;

public class TrackRegistry {
    private static Map trackSpecs = new HashMap();
    private static Set invalidSpecs = new HashSet();
    private static List iconLoaders = new ArrayList();

    public static void registerIconLoader(ITextureLoader iconLoader) {
        iconLoaders.add(iconLoader);
    }

    public static List getIconLoaders() {
        return iconLoaders;
    }

    public static void registerTrackSpec(TrackSpec trackSpec) {
        if (trackSpecs.put(trackSpec.getTrackId(), trackSpec) != null) {
            throw new TrackIdConflictException("TrackId conflict detected, please adjust your config or contact the author of the " + trackSpec.getTrackTag());
        }
    }

    public static TrackSpec getTrackSpec(int trackId) {
        Short id = (short)trackId;
        TrackSpec spec = (TrackSpec)trackSpecs.get(id);
        if (spec == null) {
            if (!invalidSpecs.contains(id)) {
                FMLRelaunchLog.log((String)"Railcraft", (Level)Level.WARNING, (String)"Unknown Track Spec ID(%d), reverting to normal track", (Object[])new Object[]{trackId});
                invalidSpecs.add(id);
            }
            id = -1;
            spec = (TrackSpec)trackSpecs.get(id);
        }
        return spec;
    }

    public static Map getTrackSpecs() {
        return trackSpecs;
    }

    public static class TrackIdConflictException
    extends RuntimeException {
        public TrackIdConflictException(String msg) {
            super(msg);
        }
    }
}

