/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.opengl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Iterator;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;
import org.newdawn.slick.opengl.DeferredTexture;
import org.newdawn.slick.opengl.EmptyImageData;
import org.newdawn.slick.opengl.ImageData;
import org.newdawn.slick.opengl.ImageDataFactory;
import org.newdawn.slick.opengl.LoadableImageData;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureImpl;
import org.newdawn.slick.opengl.renderer.Renderer;
import org.newdawn.slick.opengl.renderer.SGL;
import org.newdawn.slick.util.ResourceLoader;

public class InternalTextureLoader {
    static int textureCount = 0;
    private static boolean forcePOT = true;
    protected static SGL GL = Renderer.get();
    private static final InternalTextureLoader loader = new InternalTextureLoader();
    private HashMap texturesLinear = new HashMap();
    private HashMap texturesNearest = new HashMap();
    private int dstPixelFormat = 6408;
    private boolean deferred;
    private boolean holdTextureData;

    public static boolean isPowerOfTwo(int n) {
        return (n & -n) == n;
    }

    public static boolean isForcePOT() {
        return forcePOT;
    }

    public static void setForcePOT(boolean b) {
        forcePOT = b;
    }

    public static int getTextureCount() {
        return textureCount;
    }

    public static int createTextureID() {
        IntBuffer tmp = InternalTextureLoader.createIntBuffer(1);
        GL.glGenTextures(tmp);
        ++textureCount;
        return tmp.get(0);
    }

    public static void deleteTextureID(int id) {
        IntBuffer texBuf = InternalTextureLoader.createIntBuffer(1);
        texBuf.put(id);
        texBuf.flip();
        GL.glDeleteTextures(texBuf);
        --textureCount;
    }

    public static boolean isGenerateMipmapSupported() {
        return GLContext.getCapabilities().OpenGL14 || GLContext.getCapabilities().GL_EXT_framebuffer_object;
    }

    public static boolean isNPOTSupported() {
        return GLContext.getCapabilities().GL_ARB_texture_non_power_of_two;
    }

    public static InternalTextureLoader get() {
        return loader;
    }

    private InternalTextureLoader() {
    }

    public void setHoldTextureData(boolean holdTextureData) {
        this.holdTextureData = holdTextureData;
    }

    public void setDeferredLoading(boolean deferred) {
        this.deferred = deferred;
    }

    public boolean isDeferredLoading() {
        return this.deferred;
    }

    public void clear(String name) {
        this.texturesLinear.remove(name);
        this.texturesNearest.remove(name);
    }

    public void clear() {
        this.texturesLinear.clear();
        this.texturesNearest.clear();
    }

    public void set16BitMode() {
        this.dstPixelFormat = 32859;
    }

    public Texture getTexture(File source, boolean flipped, int filter) throws IOException {
        String resourceName = source.getAbsolutePath();
        FileInputStream in = new FileInputStream(source);
        return this.getTexture(in, resourceName, flipped, filter, null);
    }

    public Texture getTexture(File source, boolean flipped, int filter, int[] transparent) throws IOException {
        String resourceName = source.getAbsolutePath();
        FileInputStream in = new FileInputStream(source);
        return this.getTexture(in, resourceName, flipped, filter, transparent);
    }

    public Texture getTexture(String resourceName, boolean flipped, int filter) throws IOException {
        InputStream in = ResourceLoader.getResourceAsStream(resourceName);
        return this.getTexture(in, resourceName, flipped, filter, null);
    }

    public Texture getTexture(String resourceName, boolean flipped, int filter, int[] transparent) throws IOException {
        InputStream in = ResourceLoader.getResourceAsStream(resourceName);
        return this.getTexture(in, resourceName, flipped, filter, transparent);
    }

    public Texture getTexture(InputStream in, String resourceName, boolean flipped, int filter) throws IOException {
        return this.getTexture(in, resourceName, flipped, filter, null);
    }

    public TextureImpl getTexture(InputStream in, String resourceName, boolean flipped, int filter, int[] transparent) throws IOException {
        TextureImpl tex;
        if (this.deferred) {
            return new DeferredTexture(in, resourceName, flipped, filter, transparent);
        }
        HashMap hash = this.texturesLinear;
        if (filter == 9728) {
            hash = this.texturesNearest;
        }
        String resName = resourceName;
        if (transparent != null) {
            resName = resName + ":" + transparent[0] + ":" + transparent[1] + ":" + transparent[2];
        }
        resName = resName + ":" + flipped;
        if (this.holdTextureData) {
            tex = (TextureImpl)hash.get(resName);
            if (tex != null) {
                return tex;
            }
        } else {
            SoftReference ref = (SoftReference)hash.get(resName);
            if (ref != null) {
                TextureImpl tex2 = (TextureImpl)ref.get();
                if (tex2 != null) {
                    return tex2;
                }
                hash.remove(resName);
            }
        }
        try {
            GL.glGetError();
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Image based resources must be loaded as part of init() or the game loop. They cannot be loaded before initialisation.");
        }
        tex = this.getTexture(in, resourceName, 3553, filter, filter, flipped, transparent);
        tex.setCacheName(resName);
        if (this.holdTextureData) {
            hash.put(resName, tex);
        } else {
            hash.put(resName, new SoftReference<TextureImpl>(tex));
        }
        return tex;
    }

    private TextureImpl getTexture(InputStream in, String resourceName, int target, int minFilter, int magFilter, boolean flipped, int[] transparent) throws IOException {
        LoadableImageData imageData = ImageDataFactory.getImageDataFor(resourceName);
        ByteBuffer textureBuffer = imageData.loadImage(new BufferedInputStream(in), flipped, transparent);
        int textureID = InternalTextureLoader.createTextureID();
        TextureImpl texture = new TextureImpl(resourceName, target, textureID);
        GL.glEnable(target);
        GL.glBindTexture(target, textureID);
        int width = imageData.getWidth();
        int height = imageData.getHeight();
        ImageData.Format format = imageData.getFormat();
        texture.setTextureWidth(imageData.getTexWidth());
        texture.setTextureHeight(imageData.getTexHeight());
        int texWidth = texture.getTextureWidth();
        int texHeight = texture.getTextureHeight();
        IntBuffer temp = BufferUtils.createIntBuffer((int)16);
        GL.glGetInteger(3379, temp);
        int max = temp.get(0);
        if (texWidth > max || texHeight > max) {
            throw new IOException("Attempt to allocate a texture to big for the current hardware");
        }
        int srcPixelFormat = format.getOGLType();
        int componentCount = format.getColorComponents();
        texture.setWidth(width);
        texture.setHeight(height);
        texture.setImageFormat(format);
        if (this.holdTextureData) {
            texture.setTextureData(srcPixelFormat, componentCount, minFilter, magFilter, textureBuffer);
        }
        GL.glTexParameteri(target, 10241, minFilter);
        GL.glTexParameteri(target, 10240, magFilter);
        GL.glTexImage2D(target, 0, this.dstPixelFormat, InternalTextureLoader.get2Fold(width), InternalTextureLoader.get2Fold(height), 0, srcPixelFormat, 5121, textureBuffer);
        return texture;
    }

    public TextureImpl createTexture(ImageData data, ByteBuffer buffer, String ref, int target, int minFilter, int magFilter, boolean genMipmaps, ImageData.Format internalFormat) throws IOException {
        int max;
        boolean usePOT;
        int textureID = InternalTextureLoader.createTextureID();
        TextureImpl texture = new TextureImpl(ref, target, textureID);
        GL.glEnable(target);
        GL.glBindTexture(target, textureID);
        int width = data.getWidth();
        int height = data.getHeight();
        int texWidth = data.getTexWidth();
        int texHeight = data.getTexHeight();
        boolean bl = usePOT = !InternalTextureLoader.isNPOTSupported() || InternalTextureLoader.isForcePOT();
        if (usePOT) {
            texWidth = InternalTextureLoader.get2Fold(width);
            texHeight = InternalTextureLoader.get2Fold(height);
        }
        if (texWidth > (max = GL11.glGetInteger((int)3379)) || texHeight > max) {
            throw new IOException("Attempt to allocate a texture to big for the current hardware");
        }
        ImageData.Format dataFormat = data.getFormat();
        int dstFmt = internalFormat != null ? internalFormat.getOGLType() : this.dstPixelFormat;
        int srcFmt = dataFormat.getOGLType();
        texture.setTextureWidth(texWidth);
        texture.setTextureHeight(texHeight);
        texture.setWidth(width);
        texture.setHeight(height);
        texture.setImageFormat(internalFormat != null ? internalFormat : ImageData.Format.RGBA);
        if (this.holdTextureData) {
            int componentCount = dataFormat.getColorComponents();
            texture.setTextureData(srcFmt, componentCount, minFilter, magFilter, buffer);
        }
        ContextCapabilities cx = GLContext.getCapabilities();
        if (genMipmaps && !InternalTextureLoader.isGenerateMipmapSupported()) {
            minFilter = magFilter;
            genMipmaps = false;
        }
        GL.glTexParameteri(target, 10241, minFilter);
        GL.glTexParameteri(target, 10240, magFilter);
        if (genMipmaps && !cx.OpenGL30 && !cx.GL_EXT_framebuffer_object) {
            GL.glTexParameteri(target, 33169, 1);
            genMipmaps = false;
        }
        GL.glTexImage2D(target, 0, dstFmt, texWidth, texHeight, 0, srcFmt, 5121, buffer);
        if (genMipmaps) {
            GL11.glEnable((int)target);
            if (cx.OpenGL30) {
                GL30.glGenerateMipmap((int)target);
            } else {
                EXTFramebufferObject.glGenerateMipmapEXT((int)target);
            }
        }
        return texture;
    }

    public Texture createTexture(int width, int height) throws IOException {
        return this.createTexture(width, height, 9728);
    }

    public Texture createTexture(int width, int height, int filter) throws IOException {
        EmptyImageData ds = new EmptyImageData(width, height);
        return this.getTexture(ds, filter);
    }

    public Texture getTexture(ImageData dataSource, int filter) throws IOException {
        int target = 3553;
        ByteBuffer textureBuffer = dataSource.getImageBufferData();
        int textureID = InternalTextureLoader.createTextureID();
        TextureImpl texture = new TextureImpl("generated:" + dataSource, target, textureID);
        int minFilter = filter;
        int magFilter = filter;
        boolean flipped = false;
        GL.glEnable(target);
        GL.glBindTexture(target, textureID);
        int width = dataSource.getWidth();
        int height = dataSource.getHeight();
        ImageData.Format format = dataSource.getFormat();
        texture.setTextureWidth(dataSource.getTexWidth());
        texture.setTextureHeight(dataSource.getTexHeight());
        int texWidth = texture.getTextureWidth();
        int texHeight = texture.getTextureHeight();
        int srcPixelFormat = format.getOGLType();
        int componentCount = format.getColorComponents();
        texture.setWidth(width);
        texture.setHeight(height);
        texture.setImageFormat(format);
        IntBuffer temp = BufferUtils.createIntBuffer((int)16);
        GL.glGetInteger(3379, temp);
        int max = temp.get(0);
        if (texWidth > max || texHeight > max) {
            throw new IOException("Attempt to allocate a texture to big for the current hardware");
        }
        if (this.holdTextureData) {
            texture.setTextureData(srcPixelFormat, componentCount, minFilter, magFilter, textureBuffer);
        }
        GL.glTexParameteri(target, 10241, minFilter);
        GL.glTexParameteri(target, 10240, magFilter);
        GL.glTexImage2D(target, 0, this.dstPixelFormat, InternalTextureLoader.get2Fold(width), InternalTextureLoader.get2Fold(height), 0, srcPixelFormat, 5121, textureBuffer);
        return texture;
    }

    public static int get2Fold(int fold) {
        int ret;
        for (ret = 2; ret < fold; ret *= 2) {
        }
        return ret;
    }

    public static IntBuffer createIntBuffer(int size) {
        ByteBuffer temp = ByteBuffer.allocateDirect(4 * size);
        temp.order(ByteOrder.nativeOrder());
        return temp.asIntBuffer();
    }

    public void reload() {
        Iterator texs = this.texturesLinear.values().iterator();
        while (texs.hasNext()) {
            ((TextureImpl)texs.next()).reload();
        }
        texs = this.texturesNearest.values().iterator();
        while (texs.hasNext()) {
            ((TextureImpl)texs.next()).reload();
        }
    }

    public int reload(TextureImpl texture, int srcPixelFormat, int componentCount, int minFilter, int magFilter, ByteBuffer textureBuffer) {
        int target = 3553;
        int textureID = InternalTextureLoader.createTextureID();
        GL.glEnable(target);
        GL.glBindTexture(target, textureID);
        GL.glTexParameteri(target, 10241, minFilter);
        GL.glTexParameteri(target, 10240, magFilter);
        GL.glTexImage2D(target, 0, this.dstPixelFormat, texture.getTextureWidth(), texture.getTextureHeight(), 0, srcPixelFormat, 5121, textureBuffer);
        return textureID;
    }
}

