/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.utils.render;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.machinemuse.general.MuseLogger;
import net.machinemuse.general.geometry.Colour;
import net.machinemuse.general.geometry.MusePoint2D;
import net.machinemuse.general.geometry.SwirlyMuseCircle;
import net.machinemuse.general.gui.MuseGui;
import net.machinemuse.general.gui.clickable.IClickable;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.utils.MuseMathUtils;
import net.machinemuse.utils.render.SlickFont;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderEngine;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.Vec3;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public abstract class MuseRenderer {
    protected static RenderItem renderItem;
    protected static SwirlyMuseCircle selectionCircle;
    private static String TEXTURE_MAP;
    private static Stack texturestack;
    public static final String ITEM_TEXTURE_QUILT = "/gui/items.png";
    public static final String BLOCK_TEXTURE_QUILT = "/terrain.png";
    public static final String ICON_PREFIX = "mmmPowersuits:";
    static boolean messagedAboutSlick;
    private static float lightmapLastX;
    private static float lightmapLastY;

    public static void drawCircleAround(double xoffset, double yoffset, double radius) {
        if (selectionCircle == null) {
            selectionCircle = new SwirlyMuseCircle(new Colour(0.0, 1.0, 0.0, 0.0), new Colour(0.8f, 1.0, 0.8f, 1.0));
        }
        selectionCircle.draw(radius, xoffset, yoffset);
    }

    public static void pushTexture(String filename) {
        texturestack.push(TEXTURE_MAP);
        TEXTURE_MAP = filename;
        MuseRenderer.getRenderEngine().func_98187_b(TEXTURE_MAP);
    }

    public static void popTexture() {
        TEXTURE_MAP = (String)texturestack.pop();
        MuseRenderer.getRenderEngine().func_98187_b(TEXTURE_MAP);
    }

    public static List pointsInLine(int num, MusePoint2D a, MusePoint2D b) {
        ArrayList<MusePoint2D> points = new ArrayList<MusePoint2D>();
        if (num < 1) {
            return points;
        }
        if (num < 2) {
            points.add(b.minus(a).times(0.5).plus(a));
        } else {
            MusePoint2D step = b.minus(a).times(1.0f / (float)(num + 1));
            for (int i = 1; i < num + 1; ++i) {
                points.add(a.plus(step.times(i)));
            }
        }
        return points;
    }

    public static DoubleBuffer getColourGradient(Colour c1, Colour c2, int numsegments) {
        DoubleBuffer buffer = BufferUtils.createDoubleBuffer((int)(numsegments * 4));
        for (double i = 0.0; i < (double)numsegments; i += 1.0) {
            Colour c3 = c1.interpolate(c2, i / (double)numsegments);
            buffer.put(c3.r);
            buffer.put(c3.g);
            buffer.put(c3.b);
            buffer.put(c3.a);
        }
        buffer.flip();
        return buffer;
    }

    public static DoubleBuffer getArcPoints(double startangle, double endangle, double radius, double xoffset, double yoffset, double zoffset) {
        int numVertices = (int)Math.ceil(Math.abs((endangle - startangle) * 16.0 * Math.PI));
        double theta = (endangle - startangle) / (double)numVertices;
        DoubleBuffer buffer = BufferUtils.createDoubleBuffer((int)(numVertices * 3));
        double x = radius * Math.sin(startangle);
        double y = radius * Math.cos(startangle);
        double tf = Math.tan(theta);
        double rf = Math.cos(theta);
        for (int i = 0; i < numVertices; ++i) {
            buffer.put(x + xoffset);
            buffer.put(y + yoffset);
            buffer.put(zoffset);
            double tx = y;
            double ty = -x;
            x += tx * tf;
            y += ty * tf;
            x *= rf;
            y *= rf;
        }
        buffer.flip();
        return buffer;
    }

    public static void on2D() {
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2896);
    }

    public static void off2D() {
        GL11.glPopAttrib();
    }

    public static void arraysOnC() {
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32886);
    }

    public static void arraysOnT() {
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32888);
    }

    public static void arraysOff() {
        GL11.glDisableClientState((int)32884);
        GL11.glDisableClientState((int)32886);
        GL11.glDisableClientState((int)32888);
    }

    public static void texturelessOn() {
        GL11.glDisable((int)3553);
    }

    public static void texturelessOff() {
        GL11.glEnable((int)3553);
    }

    public static void blendingOn() {
        GL11.glPushAttrib((int)16448);
        if (Minecraft.func_71375_t()) {
            GL11.glShadeModel((int)7425);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        }
    }

    public static void blendingOff() {
        GL11.glPopAttrib();
    }

    public static void scissorsOn(double x, double y, double w, double h) {
        GL11.glPushAttrib((int)532480);
        GL11.glPushMatrix();
        Minecraft mc = Minecraft.func_71410_x();
        int dw = mc.field_71443_c;
        int dh = mc.field_71440_d;
        ScaledResolution res = new ScaledResolution(mc.field_71474_y, dw, dh);
        double newx = x * (double)res.func_78325_e();
        double newy = (double)dh - h * (double)res.func_78325_e() - y * (double)res.func_78325_e();
        double neww = w * (double)res.func_78325_e();
        double newh = h * (double)res.func_78325_e();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)newx), (int)((int)newy), (int)((int)neww), (int)((int)newh));
    }

    public static void scissorsOff() {
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    public static void drawItemAt(double x, double y, ItemStack item) {
        MuseRenderer.on2D();
        MuseRenderer.getRenderItem().func_82406_b(MuseRenderer.getFontRenderer(), MuseRenderer.getRenderEngine(), item, (int)x, (int)y);
        MuseRenderer.getRenderItem().func_77021_b(MuseRenderer.getFontRenderer(), MuseRenderer.getRenderEngine(), item, (int)x, (int)y);
        MuseRenderer.off2D();
    }

    public static void drawIconAt(double x, double y, Icon icon, Colour colour) {
        MuseRenderer.drawIconPartial(x, y, icon, colour, 0.0, 0.0, 16.0, 16.0);
    }

    public static void drawIconPartialOccluded(double x, double y, Icon icon, Colour colour, double left, double top, double right, double bottom) {
        double xmin = MuseMathUtils.clampDouble(left - x, 0.0, 16.0);
        double ymin = MuseMathUtils.clampDouble(top - y, 0.0, 16.0);
        double xmax = MuseMathUtils.clampDouble(right - x, 0.0, 16.0);
        double ymax = MuseMathUtils.clampDouble(bottom - y, 0.0, 16.0);
        MuseRenderer.drawIconPartial(x, y, icon, colour, xmin, ymin, xmax, ymax);
    }

    public static void drawIconPartial(double x, double y, Icon icon, Colour colour, double left, double top, double right, double bottom) {
        if (icon == null) {
            return;
        }
        GL11.glPushMatrix();
        MuseRenderer.on2D();
        MuseRenderer.blendingOn();
        if (colour != null) {
            colour.doGL();
        }
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        float u1 = icon.func_94209_e();
        float v1 = icon.func_94206_g();
        float u2 = icon.func_94212_f();
        float v2 = icon.func_94210_h();
        double xoffset1 = left * (double)(u2 - u1) / 16.0;
        double yoffset1 = top * (double)(v2 - v1) / 16.0;
        double xoffset2 = right * (double)(u2 - u1) / 16.0;
        double yoffset2 = bottom * (double)(v2 - v1) / 16.0;
        tess.func_78374_a(x + left, y + top, 0.0, (double)u1 + xoffset1, (double)v1 + yoffset1);
        tess.func_78374_a(x + left, y + bottom, 0.0, (double)u1 + xoffset1, (double)v1 + yoffset2);
        tess.func_78374_a(x + right, y + bottom, 0.0, (double)u1 + xoffset2, (double)v1 + yoffset2);
        tess.func_78374_a(x + right, y + top, 0.0, (double)u1 + xoffset2, (double)v1 + yoffset1);
        tess.func_78381_a();
        MuseRenderer.blendingOff();
        MuseRenderer.off2D();
        GL11.glPopMatrix();
    }

    public static void relativeCoords(MuseGui gui) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(gui.field_73880_f / 2), (float)(gui.field_73881_g / 2), (float)0.0f);
        GL11.glScalef((float)gui.getxSize(), (float)gui.getySize(), (float)0.0f);
    }

    public static void drawString(String s, double x, double y) {
        MuseRenderer.drawString(s, x, y, Colour.WHITE);
    }

    public static void drawString(String s, double x, double y, Colour c) {
        RenderHelper.func_74518_a();
        MuseRenderer.blendingOn();
        MuseRenderer.on2D();
        if (Config.useCustomFonts()) {
            try {
                SlickFont.apply(x, y, s, c);
            }
            catch (Throwable e) {
                if (!messagedAboutSlick) {
                    MuseLogger.logError("Slick-Util failed or was disabled in config!");
                    e.printStackTrace();
                    messagedAboutSlick = true;
                }
                MuseRenderer.getFontRenderer().func_78261_a(s, (int)x, (int)y, c.getInt());
            }
        } else {
            MuseRenderer.getFontRenderer().func_78261_a(s, (int)x, (int)y, c.getInt());
        }
        MuseRenderer.off2D();
        MuseRenderer.blendingOff();
    }

    public static void drawCenteredString(String s, double x, double y) {
        MuseRenderer.drawString(s, x - MuseRenderer.getStringWidth(s) / 2.0, y);
    }

    public static void drawRightAlignedString(String s, double x, double y) {
        MuseRenderer.drawString(s, x - MuseRenderer.getStringWidth(s), y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getStringWidth(String s) {
        double val;
        GL11.glPushAttrib((int)262144);
        try {
            if (!Config.useCustomFonts()) {
                throw new UnsupportedOperationException();
            }
            val = SlickFont.getStringWidth(s);
        }
        catch (Throwable e) {
            val = MuseRenderer.getFontRenderer().func_78256_a(s);
        }
        finally {
            GL11.glPopAttrib();
        }
        return val;
    }

    public static void drawStringsJustified(List words, double x1, double x2, double y) {
        int totalwidth = 0;
        for (String word : words) {
            totalwidth = (int)((double)totalwidth + MuseRenderer.getStringWidth(word));
        }
        double spacing = (x2 - x1 - (double)totalwidth) / (double)(words.size() - 1);
        double currentwidth = 0.0;
        for (String word : words) {
            MuseRenderer.drawString(word, x1 + currentwidth, y);
            currentwidth += MuseRenderer.getStringWidth(word) + spacing;
        }
    }

    public static void drawRectPrism(double x, double d, double e, double f, double z, double g, float texturex, float texturey, float texturex2, float texturey2) {
        MuseRenderer.arraysOnT();
        MuseRenderer.texturelessOff();
        Vec3[] points = new Vec3[]{Vec3.func_72443_a((double)x, (double)e, (double)z), Vec3.func_72443_a((double)d, (double)e, (double)z), Vec3.func_72443_a((double)x, (double)f, (double)z), Vec3.func_72443_a((double)d, (double)f, (double)z), Vec3.func_72443_a((double)x, (double)e, (double)g), Vec3.func_72443_a((double)d, (double)e, (double)g), Vec3.func_72443_a((double)x, (double)f, (double)g), Vec3.func_72443_a((double)d, (double)f, (double)g)};
        PositionTextureVertex[] va1 = new PositionTextureVertex[]{new PositionTextureVertex(points[0], texturex, texturey2), new PositionTextureVertex(points[2], texturex2, texturey2), new PositionTextureVertex(points[3], texturex2, texturey), new PositionTextureVertex(points[1], texturex, texturey)};
        new TexturedQuad(va1).func_78236_a(Tessellator.field_78398_a, 1.0f);
        PositionTextureVertex[] va2 = new PositionTextureVertex[]{new PositionTextureVertex(points[2], texturex, texturey2), new PositionTextureVertex(points[6], texturex2, texturey2), new PositionTextureVertex(points[7], texturex2, texturey), new PositionTextureVertex(points[3], texturex, texturey)};
        new TexturedQuad(va2).func_78236_a(Tessellator.field_78398_a, 1.0f);
        PositionTextureVertex[] va3 = new PositionTextureVertex[]{new PositionTextureVertex(points[6], texturex, texturey2), new PositionTextureVertex(points[4], texturex2, texturey2), new PositionTextureVertex(points[5], texturex2, texturey), new PositionTextureVertex(points[7], texturex, texturey)};
        new TexturedQuad(va3).func_78236_a(Tessellator.field_78398_a, 1.0f);
        PositionTextureVertex[] va4 = new PositionTextureVertex[]{new PositionTextureVertex(points[4], texturex, texturey2), new PositionTextureVertex(points[0], texturex2, texturey2), new PositionTextureVertex(points[1], texturex2, texturey), new PositionTextureVertex(points[5], texturex, texturey)};
        new TexturedQuad(va4).func_78236_a(Tessellator.field_78398_a, 1.0f);
        PositionTextureVertex[] va5 = new PositionTextureVertex[]{new PositionTextureVertex(points[1], texturex, texturey2), new PositionTextureVertex(points[3], texturex2, texturey2), new PositionTextureVertex(points[7], texturex2, texturey), new PositionTextureVertex(points[5], texturex, texturey)};
        new TexturedQuad(va5).func_78236_a(Tessellator.field_78398_a, 1.0f);
        PositionTextureVertex[] va6 = new PositionTextureVertex[]{new PositionTextureVertex(points[0], texturex, texturey2), new PositionTextureVertex(points[4], texturex2, texturey2), new PositionTextureVertex(points[6], texturex2, texturey), new PositionTextureVertex(points[2], texturex, texturey)};
        new TexturedQuad(va6).func_78236_a(Tessellator.field_78398_a, 1.0f);
        MuseRenderer.texturelessOff();
        MuseRenderer.arraysOff();
    }

    public static void glowOn() {
        GL11.glPushAttrib((int)64);
        lightmapLastX = OpenGlHelper.lastBrightnessX;
        lightmapLastY = OpenGlHelper.lastBrightnessY;
        RenderHelper.func_74518_a();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
    }

    public static void glowOff() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightmapLastX, (float)lightmapLastY);
        GL11.glPopAttrib();
    }

    public static FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    public static RenderEngine getRenderEngine() {
        return Minecraft.func_71410_x().field_71446_o;
    }

    public static RenderItem getRenderItem() {
        if (renderItem == null) {
            renderItem = new RenderItem();
        }
        return renderItem;
    }

    public static void drawLineBetween(IClickable firstClickable, IClickable secondClickable, Colour gradientColour) {
        MusePoint2D secondpoint;
        MusePoint2D firstpoint;
        long varia = System.currentTimeMillis() % 2000L - 1000L;
        double gradientRatio = 1.0 - (double)((varia + 1000L) % 1000L) / 1000.0;
        MusePoint2D midpoint = firstClickable.getPosition().minus(secondClickable.getPosition()).times(Math.abs((double)varia / 1000.0)).plus(secondClickable.getPosition());
        if (varia < 0L) {
            firstpoint = secondClickable.getPosition();
            secondpoint = firstClickable.getPosition();
        } else {
            firstpoint = firstClickable.getPosition();
            secondpoint = secondClickable.getPosition();
        }
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)3553);
        GL11.glBegin((int)1);
        gradientColour.withAlpha(gradientRatio).doGL();
        GL11.glVertex3d((double)midpoint.x(), (double)midpoint.y(), (double)1.0);
        gradientColour.withAlpha(0.0).doGL();
        GL11.glVertex3d((double)firstpoint.x(), (double)firstpoint.y(), (double)1.0);
        gradientColour.withAlpha(gradientRatio).doGL();
        GL11.glVertex3d((double)secondpoint.x(), (double)secondpoint.y(), (double)1.0);
        Colour.WHITE.withAlpha(1.0).doGL();
        GL11.glVertex3d((double)midpoint.x(), (double)midpoint.y(), (double)1.0);
        GL11.glEnd();
        GL11.glPopAttrib();
    }

    public static void drawLightning(double x1, double y1, double z1, double x2, double y2, double z2, Colour colour) {
        MuseRenderer.drawLightningTextured(x1, y1, z1, x2, y2, z2, colour);
    }

    public static void drawMPDLightning(double x1, double y1, double z1, double x2, double y2, double z2, Colour colour, double displacement, double detail) {
        if (displacement < detail) {
            colour.doGL();
            GL11.glBegin((int)1);
            GL11.glVertex3d((double)x1, (double)y1, (double)z1);
            GL11.glVertex3d((double)x2, (double)y2, (double)z2);
            GL11.glEnd();
        } else {
            double mid_x = (x1 + x2) / 2.0;
            double mid_y = (y1 + y2) / 2.0;
            double mid_z = (z1 + z2) / 2.0;
            MuseRenderer.drawMPDLightning(x1, y1, z1, mid_x += (Math.random() - 0.5) * displacement, mid_y += (Math.random() - 0.5) * displacement, mid_z += (Math.random() - 0.5) * displacement, colour, displacement / 2.0, detail);
            MuseRenderer.drawMPDLightning(mid_x, mid_y, mid_z, x2, y2, z2, colour, displacement / 2.0, detail);
        }
    }

    public static void drawLightningTextured(double x1, double y1, double z1, double x2, double y2, double z2, Colour colour) {
        double tx = x2 - x1;
        double ty = y2 - y1;
        double tz = z2 - z1;
        double ax = 0.0;
        double ay = 0.0;
        double az = 0.0;
        double bx = 0.0;
        double by = 0.0;
        double bz = 0.0;
        double cx = 0.0;
        double cy = 0.0;
        double cz = 0.0;
        double jagfactor = 0.3;
        MuseRenderer.on2D();
        GL11.glEnable((int)2929);
        MuseRenderer.pushTexture("/mods/mmmPowersuits/textures/gui/lightning-medium.png");
        MuseRenderer.blendingOn();
        colour.doGL();
        GL11.glBegin((int)7);
        while (Math.abs(cx) < Math.abs(tx) && Math.abs(cy) < Math.abs(ty) && Math.abs(cz) < Math.abs(tz)) {
            ax = x1 + cx;
            ay = y1 + cy;
            az = z1 + cz;
            bx = x1 + (cx += Math.random() * tx * jagfactor - 0.1 * tx);
            by = y1 + (cy += Math.random() * ty * jagfactor - 0.1 * ty);
            bz = z1 + (cz += Math.random() * tz * jagfactor - 0.1 * tz);
            int index = (int)Math.random() * 50;
            MuseRenderer.drawLightningBetweenPointsFast(ax, ay, az, bx, by, bz, index);
        }
        GL11.glEnd();
        MuseRenderer.blendingOff();
        MuseRenderer.off2D();
    }

    public static void drawLightningBetweenPoints(double x1, double y1, double z1, double x2, double y2, double z2, int index) {
        MuseRenderer.pushTexture("/mods/mmmPowersuits/textures/gui/lightning-medium.png");
        double u1 = (double)index / 50.0;
        double u2 = u1 + 0.02;
        double px = (y1 - y2) * 0.125;
        double py = (x2 - x1) * 0.125;
        GL11.glTexCoord2d((double)u1, (double)0.0);
        GL11.glVertex3d((double)(x1 - px), (double)(y1 - py), (double)z1);
        GL11.glTexCoord2d((double)u2, (double)0.0);
        GL11.glVertex3d((double)(x1 + px), (double)(y1 + py), (double)z1);
        GL11.glTexCoord2d((double)u1, (double)1.0);
        GL11.glVertex3d((double)(x2 - px), (double)(y2 - py), (double)z2);
        GL11.glTexCoord2d((double)u2, (double)1.0);
        GL11.glVertex3d((double)(x2 + px), (double)(y2 + py), (double)z2);
        MuseRenderer.popTexture();
    }

    public static void drawLightningBetweenPointsFast(double x1, double y1, double z1, double x2, double y2, double z2, int index) {
        double u1 = (double)index / 50.0;
        double u2 = u1 + 0.02;
        double px = (y1 - y2) * 0.125;
        double py = (x2 - x1) * 0.125;
        GL11.glTexCoord2d((double)u1, (double)0.0);
        GL11.glVertex3d((double)(x1 - px), (double)(y1 - py), (double)z1);
        GL11.glTexCoord2d((double)u2, (double)0.0);
        GL11.glVertex3d((double)(x1 + px), (double)(y1 + py), (double)z1);
        GL11.glTexCoord2d((double)u1, (double)1.0);
        GL11.glVertex3d((double)(x2 - px), (double)(y2 - py), (double)z2);
        GL11.glTexCoord2d((double)u2, (double)1.0);
        GL11.glVertex3d((double)(x2 + px), (double)(y2 + py), (double)z2);
    }

    public static void drawLightningLines(double x1, double y1, double z1, double x2, double y2, double z2, Colour colour) {
        double tx = x2 - x1;
        double ty = y2 - y1;
        double tz = z2 - z1;
        double cx = 0.0;
        double cy = 0.0;
        double cz = 0.0;
        double jagfactor = 0.3;
        MuseRenderer.texturelessOn();
        MuseRenderer.blendingOn();
        MuseRenderer.on2D();
        GL11.glBegin((int)3);
        while (Math.abs(cx) < Math.abs(tx) && Math.abs(cy) < Math.abs(ty) && Math.abs(cz) < Math.abs(tz)) {
            colour.doGL();
            GL11.glVertex3d((double)(x1 + (cx += Math.random() * tx * jagfactor - 0.1 * tx)), (double)(y1 + (cy += Math.random() * ty * jagfactor - 0.1 * ty)), (double)(z1 + (cz += Math.random() * tz * jagfactor - 0.1 * tz)));
        }
        GL11.glEnd();
        MuseRenderer.off2D();
        MuseRenderer.blendingOff();
        MuseRenderer.texturelessOff();
    }

    private static float pythag(float x, float y, float z) {
        return (float)Math.sqrt(x * x + y * y + z * z);
    }

    public static void unRotate() {
        FloatBuffer matrix = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2982, (FloatBuffer)matrix);
        float scalex = MuseRenderer.pythag(matrix.get(0), matrix.get(1), matrix.get(2));
        float scaley = MuseRenderer.pythag(matrix.get(4), matrix.get(5), matrix.get(6));
        float scalez = MuseRenderer.pythag(matrix.get(8), matrix.get(9), matrix.get(10));
        for (int i = 0; i < 12; ++i) {
            matrix.put(i, 0.0f);
        }
        matrix.put(0, scalex);
        matrix.put(5, scaley);
        matrix.put(10, scalez);
        GL11.glLoadMatrix((FloatBuffer)matrix);
    }

    static {
        TEXTURE_MAP = ITEM_TEXTURE_QUILT;
        texturestack = new Stack();
        messagedAboutSlick = false;
    }
}

