/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.weapon;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MusePlayerUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class RailgunModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_RAILGUN = "Railgun";
    public static final String IMPULSE = "Railgun Total Impulse";
    public static final String ENERGY = "Railgun Energy Cost";
    public static final String HEAT = "Railgun Heat Emission";

    public RailgunModule(List validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 6));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.hvcapacitor, 1));
        this.addBaseProperty(IMPULSE, 500.0, "Ns");
        this.addBaseProperty(ENERGY, 500.0, "J");
        this.addBaseProperty(HEAT, 5.0, "");
        this.addTradeoffProperty("Voltage", IMPULSE, 2500.0);
        this.addTradeoffProperty("Voltage", ENERGY, 2500.0);
        this.addTradeoffProperty("Voltage", HEAT, 25.0);
    }

    @Override
    public String getCategory() {
        return "Weapon";
    }

    @Override
    public String getDataName() {
        return MODULE_RAILGUN;
    }

    @Override
    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)"module.railgun.name");
    }

    @Override
    public String getDescription() {
        return "An assembly which accelerates a projectile to supersonic speeds using magnetic force. Heavy recoil.";
    }

    public void drawParticleStreamTo(EntityPlayer source, World world, double x, double y, double z) {
        Vec3 direction = source.func_70040_Z().func_72432_b();
        double scale = 1.0;
        double xoffset = 1.3f;
        double yoffset = -0.2;
        double zoffset = 0.3f;
        Vec3 horzdir = direction.func_72432_b();
        horzdir.field_72448_b = 0.0;
        horzdir = horzdir.func_72432_b();
        double cx = source.field_70165_t + direction.field_72450_a * xoffset - direction.field_72448_b * horzdir.field_72450_a * yoffset - horzdir.field_72449_c * zoffset;
        double cy = source.field_70163_u + (double)source.func_70047_e() + direction.field_72448_b * xoffset + (1.0 - Math.abs(direction.field_72448_b)) * yoffset;
        double cz = source.field_70161_v + direction.field_72449_c * xoffset - direction.field_72448_b * horzdir.field_72449_c * yoffset + horzdir.field_72450_a * zoffset;
        double dx = x - cx;
        double dy = y - cy;
        double dz = z - cz;
        double ratio = Math.sqrt(dx * dx + dy * dy + dz * dz);
        while (Math.abs(cx - x) > Math.abs(dx / ratio)) {
            world.func_72869_a("townaura", cx, cy, cz, 0.0, 0.0, 0.0);
            cx += dx * 0.1 / ratio;
            cy += dy * 0.1 / ratio;
            cz += dz * 0.1 / ratio;
        }
    }

    @Override
    public void onRightClick(EntityPlayer player, World world, ItemStack itemStack) {
        double range = 64.0;
        double energyConsumption = ModuleManager.computeModularProperty(itemStack, ENERGY);
        if (ElectricItemUtils.getPlayerEnergy(player) > energyConsumption) {
            ElectricItemUtils.drainPlayerEnergy(player, energyConsumption);
            MuseHeatUtils.heatPlayer(player, ModuleManager.computeModularProperty(itemStack, HEAT));
            MovingObjectPosition hitMOP = MusePlayerUtils.doCustomRayTrace(player.field_70170_p, player, true, range);
            world.func_72956_a((Entity)player, "random.bow", 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
            double damage = ModuleManager.computeModularProperty(itemStack, IMPULSE) / 100.0;
            double knockback = damage / 20.0;
            Vec3 lookVec = player.func_70040_Z();
            if (hitMOP != null) {
                switch (hitMOP.field_72313_a) {
                    case ENTITY: {
                        this.drawParticleStreamTo(player, world, hitMOP.field_72307_f.field_72450_a, hitMOP.field_72307_f.field_72448_b, hitMOP.field_72307_f.field_72449_c);
                        DamageSource damageSource = DamageSource.func_76365_a((EntityPlayer)player);
                        if (!hitMOP.field_72308_g.func_70097_a(damageSource, (int)damage)) break;
                        hitMOP.field_72308_g.func_70024_g(lookVec.field_72450_a * knockback, Math.abs(lookVec.field_72448_b + (double)0.2f) * knockback, lookVec.field_72449_c * knockback);
                        break;
                    }
                    case TILE: {
                        this.drawParticleStreamTo(player, world, hitMOP.field_72307_f.field_72450_a, hitMOP.field_72307_f.field_72448_b, hitMOP.field_72307_f.field_72449_c);
                        break;
                    }
                }
                player.func_70024_g(-lookVec.field_72450_a * knockback, Math.abs(-lookVec.field_72448_b + (double)0.2f) * knockback, -lookVec.field_72449_c * knockback);
                world.func_72956_a((Entity)player, "random.bow", 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
            }
        }
        player.func_71008_a(itemStack, 10);
    }

    @Override
    public String getTextureFile() {
        return "electricweapon";
    }

    @Override
    public void onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
    }

    @Override
    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int par4) {
    }
}

