/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.entity.EntityLuxCapacitor;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class LuxCapacitor
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_LUX_CAPACITOR = "Lux Capacitor";
    public static final String ENERGY = "Lux Capacitor Energy Consumption";

    public LuxCapacitor(List validItems) {
        super(validItems);
        this.addInstallCost(new ItemStack(Item.field_77751_aT, 1));
        this.addInstallCost(new ItemStack(Item.field_77703_o, 2));
        this.addBaseProperty(ENERGY, 100.0, "J");
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_LUX_CAPACITOR;
    }

    @Override
    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)"module.luxCapacitor.name");
    }

    @Override
    public String getDescription() {
        return "Launch a virtually infinite number of attractive light sources at the wall.";
    }

    @Override
    public String getTextureFile() {
        return "bluelight";
    }

    @Override
    public void onRightClick(EntityPlayer player, World world, ItemStack itemStack) {
        player.func_71008_a(itemStack, 10);
        if (!world.field_72995_K) {
            double energyConsumption = ModuleManager.computeModularProperty(itemStack, ENERGY);
            if (ElectricItemUtils.getPlayerEnergy(player) > energyConsumption) {
                ElectricItemUtils.drainPlayerEnergy(player, energyConsumption);
                EntityLuxCapacitor luxCapacitor = new EntityLuxCapacitor(world, (EntityLiving)player);
                world.func_72838_d((Entity)luxCapacitor);
            }
        }
    }

    @Override
    public void onItemUse(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
    }

    @Override
    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int par4) {
    }
}

