/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.movement;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.control.PlayerInputMap;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MusePlayerUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class ParachuteModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public static final String MODULE_PARACHUTE = "Parachute";

    public ParachuteModule(List validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.parachute, 2));
    }

    @Override
    public String getCategory() {
        return "Movement";
    }

    @Override
    public String getDataName() {
        return MODULE_PARACHUTE;
    }

    @Override
    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)"module.parachute.name");
    }

    @Override
    public String getDescription() {
        return "Add a parachute to slow your descent. Activate by pressing sneak (defaults to Shift) in midair.";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        double totalVelocity;
        PlayerInputMap movementInput = PlayerInputMap.getInputMapFor(player.field_71092_bJ);
        float forwardkey = movementInput.forwardKey;
        boolean sneakkey = movementInput.sneakKey;
        ItemStack torso = player.func_82169_q(2);
        boolean hasGlider = false;
        MusePlayerUtils.resetFloatKickTicks(player);
        if (torso != null && torso.func_77973_b() instanceof IModularItem) {
            hasGlider = MuseItemUtils.itemHasActiveModule(torso, "Glider");
        }
        if (sneakkey && player.field_70181_x < -0.1 && (!hasGlider || forwardkey <= 0.0f) && (totalVelocity = Math.sqrt(player.field_70159_w * player.field_70159_w + player.field_70179_y * player.field_70179_y + player.field_70181_x * player.field_70181_x) * MusePlayerUtils.getWeightPenaltyRatio(MuseItemUtils.getPlayerWeight(player), 25000.0)) > 0.0) {
            player.field_70159_w = player.field_70159_w * 0.1 / totalVelocity;
            player.field_70181_x = player.field_70181_x * 0.1 / totalVelocity;
            player.field_70179_y = player.field_70179_y * 0.1 / totalVelocity;
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }

    @Override
    public String getTextureFile() {
        return "parachute";
    }
}

