/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.movement;

import java.util.List;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.control.PlayerInputMap;
import net.machinemuse.powersuits.event.MovementManager;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MusePlayerUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class JumpAssistModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public static final String MODULE_JUMP_ASSIST = "Jump Assist";
    public static final String JUMP_ENERGY_CONSUMPTION = "Jump Energy Consumption";
    public static final String JUMP_MULTIPLIER = "Jump Boost";
    public static final String JUMP_FOOD_COMPENSATION = "Jump Exhaustion Compensation";

    public JumpAssistModule(List validItems) {
        super(validItems);
        this.addSimpleTradeoff(this, "Power", JUMP_ENERGY_CONSUMPTION, "J", 0.0, 25.0, JUMP_MULTIPLIER, "%", 1.0, 4.0);
        this.addSimpleTradeoff(this, "Compensation", JUMP_ENERGY_CONSUMPTION, "J", 0.0, 5.0, JUMP_FOOD_COMPENSATION, "%", 0.0, 1.0);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.servoMotor, 4));
    }

    @Override
    public String getCategory() {
        return "Movement";
    }

    @Override
    public String getDataName() {
        return MODULE_JUMP_ASSIST;
    }

    @Override
    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)"module.jumpAssist.name");
    }

    @Override
    public String getDescription() {
        return "Another set of servo motors to help you jump higher.";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        PlayerInputMap movementInput = PlayerInputMap.getInputMapFor(player.field_71092_bJ);
        boolean jumpkey = movementInput.jumpKey;
        if (jumpkey) {
            double multiplier = MovementManager.getPlayerJumpMultiplier(player);
            if (multiplier > 0.0) {
                player.field_70181_x += 0.15 * Math.min(multiplier, 1.0) * MusePlayerUtils.getWeightPenaltyRatio(MuseItemUtils.getPlayerWeight(player), 25000.0);
                MovementManager.setPlayerJumpTicks(player, multiplier - 1.0);
            }
            player.field_70747_aH = player.field_70746_aG * 0.7f;
        } else {
            MovementManager.setPlayerJumpTicks(player, 0.0);
        }
        MusePlayerUtils.resetFloatKickTicks(player);
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }

    @Override
    public String getTextureFile() {
        return "jumpassist";
    }
}

