/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.movement;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.general.sound.Musique;
import net.machinemuse.powersuits.control.PlayerInputMap;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MusePlayerUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class JetPackModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public static final String MODULE_JETPACK = "Jetpack";
    public static final String JET_ENERGY_CONSUMPTION = "Jetpack Energy Consumption";
    public static final String JET_THRUST = "Jetpack Thrust";

    public JetPackModule(List validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.ionThruster, 4));
        this.addBaseProperty(JET_ENERGY_CONSUMPTION, 0.0, "J/t");
        this.addBaseProperty(JET_THRUST, 0.0, "N");
        this.addTradeoffProperty("Thrust", JET_ENERGY_CONSUMPTION, 150.0);
        this.addTradeoffProperty("Thrust", JET_THRUST, 0.16);
    }

    @Override
    public String getCategory() {
        return "Movement";
    }

    @Override
    public String getDataName() {
        return MODULE_JETPACK;
    }

    @Override
    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)"module.jetpack.name");
    }

    @Override
    public String getDescription() {
        return "A jetpack should allow you to jump indefinitely, or at least until you run out of power.";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        if (player.func_70090_H()) {
            return;
        }
        PlayerInputMap movementInput = PlayerInputMap.getInputMapFor(player.field_71092_bJ);
        boolean jumpkey = movementInput.jumpKey;
        ItemStack helmet = player.func_82169_q(3);
        boolean hasFlightControl = helmet != null && helmet.func_77973_b() instanceof IModularItem && MuseItemUtils.itemHasActiveModule(helmet, "Flight Control");
        double jetEnergy = 0.0;
        double thrust = 0.0;
        jetEnergy += ModuleManager.computeModularProperty(item, JET_ENERGY_CONSUMPTION);
        thrust += ModuleManager.computeModularProperty(item, JET_THRUST);
        if (jetEnergy < ElectricItemUtils.getPlayerEnergy(player)) {
            thrust *= MusePlayerUtils.getWeightPenaltyRatio(MuseItemUtils.getPlayerWeight(player), 25000.0);
            if (hasFlightControl && thrust > 0.0) {
                thrust = MusePlayerUtils.thrust(player, thrust, true);
                Musique.playerSound(player, "mods.mmmPowersuits.sound.Jetpack", (float)(thrust * 6.25), 1.0f, true);
                ElectricItemUtils.drainPlayerEnergy(player, thrust * jetEnergy);
            } else if (jumpkey && player.field_70181_x < 0.5) {
                thrust = MusePlayerUtils.thrust(player, thrust, false);
                Musique.playerSound(player, "mods.mmmPowersuits.sound.Jetpack", (float)(thrust * 6.25), 1.0f, true);
                ElectricItemUtils.drainPlayerEnergy(player, thrust * jetEnergy);
            } else {
                Musique.stopPlayerSound(player, "mods.mmmPowersuits.sound.Jetpack");
            }
        } else {
            Musique.stopPlayerSound(player, "mods.mmmPowersuits.sound.Jetpack");
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
        Musique.stopPlayerSound(player, "mods.mmmPowersuits.sound.Jetpack");
    }

    @Override
    public String getTextureFile() {
        return "jetpack";
    }
}

