/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.movement;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.control.PlayerInputMap;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MusePlayerUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;

public class GliderModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public static final String MODULE_GLIDER = "Glider";

    @Override
    public String getTextureFile() {
        return "glider";
    }

    public GliderModule(List validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.gliderWing, 2));
    }

    @Override
    public String getCategory() {
        return "Movement";
    }

    @Override
    public String getDataName() {
        return MODULE_GLIDER;
    }

    @Override
    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)"module.glider.name");
    }

    @Override
    public String getDescription() {
        return "Tack on some wings to turn downward into forward momentum. Press sneak+forward while falling to activate.";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        Vec3 playerHorzFacing = player.func_70040_Z();
        playerHorzFacing.field_72448_b = 0.0;
        playerHorzFacing.func_72432_b();
        PlayerInputMap movementInput = PlayerInputMap.getInputMapFor(player.field_71092_bJ);
        boolean sneakkey = movementInput.sneakKey;
        float forwardkey = movementInput.forwardKey;
        ItemStack torso = player.func_82169_q(2);
        boolean hasParachute = false;
        MusePlayerUtils.resetFloatKickTicks(player);
        if (torso != null && torso.func_77973_b() instanceof IModularItem) {
            hasParachute = MuseItemUtils.itemHasActiveModule(torso, "Parachute");
        }
        if (sneakkey && player.field_70181_x < 0.0 && (!hasParachute || forwardkey > 0.0f) && player.field_70181_x < -0.1) {
            float vol = (float)(player.field_70159_w * player.field_70159_w + player.field_70179_y * player.field_70179_y);
            double motionYchange = Math.min(0.08, -0.1 - player.field_70181_x);
            player.field_70181_x += motionYchange;
            player.field_70159_w += playerHorzFacing.field_72450_a * motionYchange;
            player.field_70179_y += playerHorzFacing.field_72449_c * motionYchange;
            player.field_70747_aH += 0.03f;
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }
}

