/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.misc;

import java.util.List;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.StatCollector;

public class InvisibilityModule
extends PowerModuleBase
implements IPlayerTickModule,
IToggleableModule {
    public static final String MODULE_ACTIVE_CAMOUFLAGE = "Active Camouflage";

    public InvisibilityModule(List validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.laserHologram, 4));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.fieldEmitter, 2));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 2));
    }

    @Override
    public String getCategory() {
        return "Special";
    }

    @Override
    public String getDataName() {
        return MODULE_ACTIVE_CAMOUFLAGE;
    }

    @Override
    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)"module.invisibility.name");
    }

    @Override
    public String getDescription() {
        return "Emit a hologram of your surroundings to make yourself almost imperceptible.";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        double totalEnergy = ElectricItemUtils.getPlayerEnergy(player);
        PotionEffect invis = null;
        if (player.func_82165_m(Potion.field_76441_p.field_76415_H)) {
            invis = player.func_70660_b(Potion.field_76441_p);
        }
        if (50.0 < totalEnergy) {
            if (invis == null || invis.func_76459_b() < 210) {
                player.func_70690_d(new PotionEffect(Potion.field_76441_p.field_76415_H, 500, -3));
                ElectricItemUtils.drainPlayerEnergy(player, 50.0);
            }
        } else {
            this.onPlayerTickInactive(player, item);
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
        PotionEffect invis = null;
        if (player.func_82165_m(Potion.field_76441_p.field_76415_H)) {
            invis = player.func_70660_b(Potion.field_76441_p);
        }
        if (invis != null && invis.func_76458_c() == -3) {
            if (player.field_70170_p.field_72995_K) {
                player.func_70618_n(Potion.field_76441_p.field_76415_H);
            } else {
                player.func_82170_o(Potion.field_76441_p.field_76415_H);
            }
        }
    }

    @Override
    public String getTextureFile() {
        return "bluedrone";
    }
}

