/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.event;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.machinemuse.api.IModularItem;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.IAspectSource;
import thaumcraft.api.ObjectTags;

public class ThaumRenderEventHandler {
    private static Class c_eventHandler;
    private static Class c_guiTicker;
    private static Object o_eventHandler;
    private static Object o_guiTicker;
    private static Method m_drawTagOnJar;
    private static Method m_renderAuraNodes;
    private static Method m_renderGogglesHUD_eventHandler;
    private static Method m_renderGogglesHUD_guiTicker;
    private static Field f_tagscale;

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void renderLast(RenderWorldLastEvent event) {
        ItemStack stack;
        EntityClientPlayerMP player;
        float tagscale = ThaumRenderEventHandler.getTagScale();
        if (tagscale > 0.0f) {
            ThaumRenderEventHandler.setTagScale(tagscale - 0.005f);
        }
        if ((player = Minecraft.func_71410_x().field_71439_g) != null && player.field_71071_by.func_70440_f(3) != null && player.field_71071_by.func_70440_f(3).func_77973_b() instanceof IModularItem && MuseItemUtils.itemHasModule(stack = player.field_71071_by.func_70440_f(3), "Aurameter")) {
            ThaumRenderEventHandler.renderAuraNodes(event, event.partialTicks, (EntityPlayer)player, Minecraft.func_71410_x().field_71441_e.func_72820_D());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void blockHighlight(DrawBlockHighlightEvent event) {
        ItemStack stack;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.field_71071_by.func_70440_f(3) != null && player.field_71071_by.func_70440_f(3).func_77973_b() instanceof IModularItem && MuseItemUtils.itemHasModule(stack = player.field_71071_by.func_70440_f(3), "Aurameter")) {
            ThaumRenderEventHandler.drawTags(event.target, player.field_70170_p, event.partialTicks);
        }
    }

    public static void drawTags(MovingObjectPosition target, World world, float partialTicks) {
        ObjectTags tags;
        int x = target.field_72311_b;
        int y = target.field_72312_c;
        int z = target.field_72309_d;
        float tagscale = ThaumRenderEventHandler.getTagScale();
        TileEntity entity = world.func_72796_p(x, y, z);
        if (entity instanceof IAspectSource && (tags = ((IAspectSource)entity).getSourceTags()).size() > 0) {
            if (tagscale < 0.3f) {
                ThaumRenderEventHandler.setTagScale(tagscale * 0.9f + 0.031f);
            }
            ThaumRenderEventHandler.drawTagOnJar(x, (float)y + 0.4f, z, tags, 220, ForgeDirection.UP, partialTicks);
        }
    }

    public static void populateReflections() {
        try {
            if (c_eventHandler == null) {
                c_eventHandler = Class.forName("thaumcraft.client.lib.RenderEventHandler");
                o_eventHandler = c_eventHandler.newInstance();
            }
            if (m_drawTagOnJar == null) {
                m_drawTagOnJar = c_eventHandler.getDeclaredMethod("drawTagOnJar", Double.TYPE, Double.TYPE, Double.TYPE, ObjectTags.class, Integer.TYPE, ForgeDirection.class, Float.TYPE);
            }
            if (m_renderAuraNodes == null) {
                m_renderAuraNodes = c_eventHandler.getDeclaredMethod("renderAuraNodes", RenderWorldLastEvent.class, Float.TYPE, EntityPlayer.class, Long.TYPE);
            }
            if (m_renderGogglesHUD_eventHandler == null) {
                m_renderGogglesHUD_eventHandler = c_eventHandler.getDeclaredMethod("renderGogglesHUD", RenderWorldLastEvent.class, Float.TYPE, EntityPlayer.class, Long.TYPE);
            }
            if (f_tagscale == null) {
                f_tagscale = c_eventHandler.getField("tagscale");
            }
            if (c_guiTicker == null) {
                c_guiTicker = Class.forName("thaumcraft.client.lib.GUITicker");
            }
            if (m_renderGogglesHUD_guiTicker == null) {
                m_renderGogglesHUD_guiTicker = c_guiTicker.getDeclaredMethod("renderGogglesHUD", Float.TYPE, EntityPlayer.class, Long.TYPE);
                o_guiTicker = c_guiTicker.newInstance();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void drawTagOnJar(double x, double y, double z, ObjectTags tags, int bright, ForgeDirection dir, float partialTicks) {
        ThaumRenderEventHandler.populateReflections();
        try {
            m_drawTagOnJar.invoke(o_eventHandler, x, y, z, tags, bright, dir, Float.valueOf(partialTicks));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void renderGogglesHUD(RenderWorldLastEvent event, float partialTicks, EntityPlayer player, long time) {
        ThaumRenderEventHandler.populateReflections();
        try {
            m_renderGogglesHUD_eventHandler.invoke(o_eventHandler, event, Float.valueOf(partialTicks), player, time);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void renderGogglesHUD(float partialTicks, EntityPlayer player, long time) {
        ThaumRenderEventHandler.populateReflections();
        try {
            m_renderGogglesHUD_guiTicker.invoke(o_guiTicker, Float.valueOf(partialTicks), player, time);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void renderAuraNodes(RenderWorldLastEvent event, float partialTicks, EntityPlayer player, long time) {
        ThaumRenderEventHandler.populateReflections();
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2896);
        try {
            m_renderAuraNodes.invoke(o_eventHandler, event, Float.valueOf(partialTicks), player, time);
        }
        catch (Exception e) {
            // empty catch block
        }
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
    }

    public static void setTagScale(float f) {
        ThaumRenderEventHandler.populateReflections();
        try {
            f_tagscale.set(o_eventHandler, Float.valueOf(f));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static float getTagScale() {
        ThaumRenderEventHandler.populateReflections();
        try {
            return ((Float)f_tagscale.get(o_eventHandler)).floatValue();
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }
}

