/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.powersuits.block.BlockLuxCapacitor;
import net.machinemuse.powersuits.block.BlockTinkerTable;
import net.machinemuse.powersuits.common.ModularPowersuits;
import net.machinemuse.powersuits.common.MuseCreativeTab;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.item.ItemPowerArmorBoots;
import net.machinemuse.powersuits.item.ItemPowerArmorChestplate;
import net.machinemuse.powersuits.item.ItemPowerArmorHelmet;
import net.machinemuse.powersuits.item.ItemPowerArmorLeggings;
import net.machinemuse.powersuits.item.ItemPowerFist;
import net.machinemuse.powersuits.powermodule.armor.BasicPlatingModule;
import net.machinemuse.powersuits.powermodule.armor.DiamondPlatingModule;
import net.machinemuse.powersuits.powermodule.armor.EnergyShieldModule;
import net.machinemuse.powersuits.powermodule.armor.HeatSinkModule;
import net.machinemuse.powersuits.powermodule.energy.AdvancedBatteryModule;
import net.machinemuse.powersuits.powermodule.energy.BasicBatteryModule;
import net.machinemuse.powersuits.powermodule.energy.EliteBatteryModule;
import net.machinemuse.powersuits.powermodule.misc.BinocularsModule;
import net.machinemuse.powersuits.powermodule.misc.CoolingSystemModule;
import net.machinemuse.powersuits.powermodule.misc.CosmeticGlowModule;
import net.machinemuse.powersuits.powermodule.misc.InvisibilityModule;
import net.machinemuse.powersuits.powermodule.misc.NightVisionModule;
import net.machinemuse.powersuits.powermodule.misc.TintModule;
import net.machinemuse.powersuits.powermodule.misc.TransparentArmorModule;
import net.machinemuse.powersuits.powermodule.misc.WaterElectrolyzerModule;
import net.machinemuse.powersuits.powermodule.movement.BlinkDriveModule;
import net.machinemuse.powersuits.powermodule.movement.ClimbAssistModule;
import net.machinemuse.powersuits.powermodule.movement.FlightControlModule;
import net.machinemuse.powersuits.powermodule.movement.GliderModule;
import net.machinemuse.powersuits.powermodule.movement.JetBootsModule;
import net.machinemuse.powersuits.powermodule.movement.JetPackModule;
import net.machinemuse.powersuits.powermodule.movement.JumpAssistModule;
import net.machinemuse.powersuits.powermodule.movement.ParachuteModule;
import net.machinemuse.powersuits.powermodule.movement.ShockAbsorberModule;
import net.machinemuse.powersuits.powermodule.movement.SprintAssistModule;
import net.machinemuse.powersuits.powermodule.movement.SwimAssistModule;
import net.machinemuse.powersuits.powermodule.tool.AquaAffinityModule;
import net.machinemuse.powersuits.powermodule.tool.AxeModule;
import net.machinemuse.powersuits.powermodule.tool.DiamondPickUpgradeModule;
import net.machinemuse.powersuits.powermodule.tool.FieldTinkerModule;
import net.machinemuse.powersuits.powermodule.tool.HoeModule;
import net.machinemuse.powersuits.powermodule.tool.LuxCapacitor;
import net.machinemuse.powersuits.powermodule.tool.OmniWrenchModule;
import net.machinemuse.powersuits.powermodule.tool.PickaxeModule;
import net.machinemuse.powersuits.powermodule.tool.ShearsModule;
import net.machinemuse.powersuits.powermodule.tool.ShovelModule;
import net.machinemuse.powersuits.powermodule.weapon.BladeLauncherModule;
import net.machinemuse.powersuits.powermodule.weapon.MeleeAssistModule;
import net.machinemuse.powersuits.powermodule.weapon.PlasmaCannonModule;
import net.machinemuse.powersuits.powermodule.weapon.RailgunModule;
import net.machinemuse.utils.MuseStringUtils;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.Configuration;
import org.lwjgl.input.Keyboard;

public class Config {
    public static final String RESOURCE_PREFIX = "/mods/mmmPowersuits/";
    public static final String TEXTURE_PREFIX = "/mods/mmmPowersuits/textures/";
    public static final String SOUND_PREFIX = "/mods/mmmPowersuits/sound/";
    public static final String LANG_PREFIX = "/mods/mmmPowersuits/lang/";
    public static final String SEBK_ARMOR_PATH = "/mods/mmmPowersuits/textures/models/sebkarmor.png";
    public static final String SEBK_ARMORPANTS_PATH = "/mods/mmmPowersuits/textures/models/sebkarmorpants.png";
    public static final String TINKERTABLE_TEXTURE_PATH = "/mods/mmmPowersuits/textures/models/tinkertable_tx.png";
    public static final String ARMOR_TEXTURE_PATH = "/mods/mmmPowersuits/textures/models/diffuse.png";
    public static final String BLANK_ARMOR_MODEL_PATH = "/mods/mmmPowersuits/textures/models/blankarmor.png";
    public static final String SEBK_TOOL_TEXTURE = "/mods/mmmPowersuits/textures/models/tool.png";
    public static final String LIGHTNING_TEXTURE = "/mods/mmmPowersuits/textures/gui/lightning-medium.png";
    public static final String CITIZENJOE_ARMOR_PATH = "/mods/mmmPowersuits/textures/models/joearmor.png";
    public static final String CITIZENJOE_ARMORPANTS_PATH = "/mods/mmmPowersuits/textures/models/joearmorpants.png";
    public static final String GLASS_TEXTURE = "/mods/mmmPowersuits/textures/gui/glass.png";
    public static File configFolder;
    public static int helmID;
    public static int chestID;
    public static int legsID;
    public static int bootsID;
    public static int fistID;
    private static Configuration config;
    public static boolean canUseShaders;

    public static void init(Configuration config) {
        Config.config = config;
        config.load();
        BlockTinkerTable.assignedBlockID = config.getBlock("Power Armor Tinker Table", 2477).getInt();
        BlockLuxCapacitor.assignedBlockID = config.getBlock("Lux Capacitor", 2478).getInt();
        ItemComponent.assignedItemID = config.getItem("Power Armor Component", 24770).getInt();
        helmID = config.getItem("Power Armor Head", 24771).getInt();
        chestID = config.getItem("Power Armor Torso", 24772).getInt();
        legsID = config.getItem("Power Armor Legs", 24773).getInt();
        bootsID = config.getItem("Power Armor Feet", 24774).getInt();
        fistID = config.getItem("Power Tool", 24775).getInt();
        config.save();
    }

    public static String getNetworkChannelName() {
        return "mmmPowerSuits";
    }

    public static CreativeTabs getCreativeTab() {
        return MuseCreativeTab.instance();
    }

    public static double getSalvageChance() {
        return config.get("general", "Salvage Ratio", 0.9).getDouble(0.9);
    }

    public static double getMaximumArmorPerPiece() {
        return Math.max(0.0, config.get("general", "Maximum Armor per Piece", 6.0).getDouble(6.0));
    }

    public static double getMaximumFlyingSpeedmps() {
        return config.get("general", "Maximum flight speed (in m/s)", 25.0).getDouble(25.0);
    }

    public static boolean useMouseWheel() {
        return config.get("general", "Use Mousewheel to change modes", true).getBoolean(true);
    }

    public static boolean isDebugging() {
        return config.get("general", "Debugging info", false).getBoolean(false);
    }

    public static void addModule(IPowerModule module) {
        ModuleManager.addModule(module);
    }

    public static void loadPowerModules() {
        List<IModularItem> ARMORONLY = Arrays.asList(ModularPowersuits.powerArmorHead, ModularPowersuits.powerArmorTorso, ModularPowersuits.powerArmorLegs, ModularPowersuits.powerArmorFeet);
        List<IModularItem> ALLITEMS = Arrays.asList(ModularPowersuits.powerArmorHead, ModularPowersuits.powerArmorTorso, ModularPowersuits.powerArmorLegs, ModularPowersuits.powerArmorFeet, ModularPowersuits.powerTool);
        List<ItemPowerArmorHelmet> HEADONLY = Collections.singletonList(ModularPowersuits.powerArmorHead);
        List<ItemPowerArmorChestplate> TORSOONLY = Collections.singletonList(ModularPowersuits.powerArmorTorso);
        List<ItemPowerArmorLeggings> LEGSONLY = Collections.singletonList(ModularPowersuits.powerArmorLegs);
        List<ItemPowerArmorBoots> FEETONLY = Collections.singletonList(ModularPowersuits.powerArmorFeet);
        List<ItemPowerFist> TOOLONLY = Collections.singletonList(ModularPowersuits.powerTool);
        Config.addModule(new BasicPlatingModule(ARMORONLY));
        Config.addModule(new DiamondPlatingModule(ARMORONLY));
        Config.addModule(new EnergyShieldModule(ARMORONLY));
        Config.addModule(new HeatSinkModule(ARMORONLY));
        Config.addModule(new AxeModule(TOOLONLY));
        Config.addModule(new PickaxeModule(TOOLONLY));
        Config.addModule(new ShovelModule(TOOLONLY));
        Config.addModule(new ShearsModule(TOOLONLY));
        Config.addModule(new HoeModule(TOOLONLY));
        Config.addModule(new LuxCapacitor(TOOLONLY));
        Config.addModule(new OmniWrenchModule(TOOLONLY));
        Config.addModule(new FieldTinkerModule(TOOLONLY));
        Config.addModule(new MeleeAssistModule(TOOLONLY));
        Config.addModule(new PlasmaCannonModule(TOOLONLY));
        Config.addModule(new RailgunModule(TOOLONLY));
        Config.addModule(new BladeLauncherModule(TOOLONLY));
        Config.addModule(new BasicBatteryModule(ALLITEMS));
        Config.addModule(new AdvancedBatteryModule(ALLITEMS));
        Config.addModule(new EliteBatteryModule(ALLITEMS));
        Config.addModule(new ParachuteModule(TORSOONLY));
        Config.addModule(new GliderModule(TORSOONLY));
        Config.addModule(new JetPackModule(TORSOONLY));
        Config.addModule(new SprintAssistModule(LEGSONLY));
        Config.addModule(new JumpAssistModule(LEGSONLY));
        Config.addModule(new SwimAssistModule(LEGSONLY));
        Config.addModule(new ClimbAssistModule(LEGSONLY));
        Config.addModule(new JetBootsModule(FEETONLY));
        Config.addModule(new ShockAbsorberModule(FEETONLY));
        Config.addModule(new WaterElectrolyzerModule(HEADONLY));
        Config.addModule(new BinocularsModule(HEADONLY));
        Config.addModule(new NightVisionModule(HEADONLY));
        Config.addModule(new FlightControlModule(HEADONLY));
        Config.addModule(new InvisibilityModule(TORSOONLY));
        Config.addModule(new BlinkDriveModule(TOOLONLY));
        Config.addModule(new DiamondPickUpgradeModule(TOOLONLY));
        Config.addModule(new AquaAffinityModule(TOOLONLY));
        Config.addModule(new CoolingSystemModule(TORSOONLY));
        Config.addModule(new TintModule(TOOLONLY));
        Config.addModule(new TransparentArmorModule(ARMORONLY));
        Config.addModule(new CosmeticGlowModule(ARMORONLY));
    }

    public static Configuration getConfig() {
        return config;
    }

    public static boolean doAdditionalInfo() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && Keyboard.isKeyDown((int)42);
    }

    public static Object additionalInfoInstructions() {
        String message = "Press SHIFT for more information.";
        message = MuseStringUtils.wrapMultipleFormatTags(message, new Object[]{MuseStringUtils.FormatCodes.Grey, MuseStringUtils.FormatCodes.Italic});
        return message;
    }

    public static boolean useGraphicalMeters() {
        return config.get("general", "Use Graphical Meters", true).getBoolean(true);
    }

    public static double baseMaxHeat() {
        return config.get("general", "Base Heat Cap", 50.0).getDouble(50.0);
    }

    public static boolean allowConflictingKeybinds() {
        return config.get("general", "Allow Conflicting Keybinds", true).getBoolean(true);
    }

    public static boolean useCustomFonts() {
        return config.get("Font", "Use Custom Font Engine", true).getBoolean(true);
    }

    public static boolean useSounds() {
        return config.get("general", "Use Sounds", true).getBoolean(true);
    }

    public static double fontDetail() {
        return config.get("Font", "Font Detail Multiplier", 4).getDouble(4.0);
    }

    public static String fontURI() {
        return config.get("Font", "Font URI", "/mods/mmmPowersuits/fonts/cra.ttf").getString();
    }

    public static String fontName() {
        return config.get("Font", "Native Font Name (Overrides URI)", "").getString();
    }

    public static boolean fontAntiAliasing() {
        return config.get("Font", "Font Anti-Aliasing", false).getBoolean(false);
    }

    public static int glowMultiplier() {
        return config.get("Graphics", "Bloom Multiplier", 3).getInt(3);
    }

    public static boolean useShaders() {
        return config.get("Graphics", "Use Pixel/Vertex Shaders", true).getBoolean(true);
    }

    public static void setConfigFolderBase(File folder) {
        configFolder = new File(folder.getAbsolutePath() + "/machinemuse");
    }

    static {
        canUseShaders = false;
    }

    public static enum Guis {
        GuiTinkerTable,
        GuiSuitManager,
        GuiPortableCrafting;

    }
}

