/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.frame;

import java.util.List;
import net.machinemuse.general.geometry.Colour;
import net.machinemuse.general.geometry.DrawableMuseRect;
import net.machinemuse.general.geometry.MusePoint2D;
import net.machinemuse.general.gui.frame.IGuiFrame;
import net.machinemuse.utils.MuseMathUtils;
import net.machinemuse.utils.render.MuseRenderer;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ScrollableFrame
implements IGuiFrame {
    protected int totalsize;
    protected int currentscrollpixels;
    protected int buttonsize = 5;
    protected boolean scrollbarPicked = false;
    protected boolean scrolldownPicked = false;
    protected boolean scrollupPicked = false;
    protected int lastdWheel = Mouse.getDWheel();
    protected DrawableMuseRect border;

    public ScrollableFrame(MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour) {
        this.border = new DrawableMuseRect(topleft, bottomright, borderColour, insideColour);
    }

    protected double getScrollAmount() {
        return 8.0;
    }

    @Override
    public void update(double x, double y) {
        if (this.border.containsPoint(x, y)) {
            int dscroll = (this.lastdWheel - Mouse.getDWheel()) / 15;
            this.lastdWheel = Mouse.getDWheel();
            this.currentscrollpixels = (int)MuseMathUtils.clampDouble(this.currentscrollpixels + dscroll, 0.0, this.getMaxScrollPixels());
            if (Mouse.isButtonDown((int)0)) {
                if (y - this.border.top() < (double)this.buttonsize && this.currentscrollpixels > 0) {
                    dscroll = (int)((double)dscroll - this.getScrollAmount());
                } else if (this.border.bottom() - y < (double)this.buttonsize) {
                    dscroll = (int)((double)dscroll + this.getScrollAmount());
                }
            }
        }
    }

    public void preDraw() {
        this.border.draw();
        MuseRenderer.glowOn();
        MuseRenderer.texturelessOn();
        GL11.glBegin((int)4);
        Colour.LIGHTBLUE.doGL();
        if ((double)this.currentscrollpixels + this.border.height() < (double)this.totalsize) {
            GL11.glVertex3d((double)(this.border.left() + this.border.width() / 2.0), (double)this.border.bottom(), (double)1.0);
            GL11.glVertex3d((double)(this.border.left() + this.border.width() / 2.0 + 2.0), (double)(this.border.bottom() - 4.0), (double)1.0);
            GL11.glVertex3d((double)(this.border.left() + this.border.width() / 2.0 - 2.0), (double)(this.border.bottom() - 4.0), (double)1.0);
        }
        if (this.currentscrollpixels > 0) {
            GL11.glVertex3d((double)(this.border.left() + this.border.width() / 2.0), (double)this.border.top(), (double)1.0);
            GL11.glVertex3d((double)(this.border.left() + this.border.width() / 2.0 - 2.0), (double)(this.border.top() + 4.0), (double)1.0);
            GL11.glVertex3d((double)(this.border.left() + this.border.width() / 2.0 + 2.0), (double)(this.border.top() + 4.0), (double)1.0);
        }
        Colour.WHITE.doGL();
        GL11.glEnd();
        MuseRenderer.texturelessOff();
        MuseRenderer.scissorsOn(this.border.left() + 4.0, this.border.top() + 4.0, this.border.width() - 8.0, this.border.height() - 8.0);
    }

    public void postDraw() {
        MuseRenderer.scissorsOff();
        MuseRenderer.glowOff();
    }

    @Override
    public void draw() {
        this.preDraw();
        this.postDraw();
    }

    @Override
    public void onMouseDown(double x, double y, int button) {
    }

    @Override
    public void onMouseUp(double x, double y, int button) {
    }

    public int getMaxScrollPixels() {
        return (int)Math.max((double)this.totalsize - this.border.height(), 0.0);
    }

    @Override
    public List getToolTip(int x, int y) {
        return null;
    }
}

