/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.clickable;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.machinemuse.general.geometry.Colour;
import net.machinemuse.general.geometry.MusePoint2D;
import net.machinemuse.general.gui.clickable.ClickableButton;
import net.machinemuse.general.gui.clickable.ClickableModule;
import net.machinemuse.general.gui.clickable.IClickable;
import net.machinemuse.powersuits.network.packets.MusePacketToggleRequest;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.render.MuseRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;
import org.lwjgl.input.Keyboard;

public class ClickableKeybinding
extends ClickableButton {
    protected List boundModules;
    protected KeyBinding keybind;
    protected boolean toggleval;
    protected boolean toggled;
    protected boolean free;

    public ClickableKeybinding(KeyBinding keybind, MusePoint2D position, boolean free) {
        super(ClickableKeybinding.parseName(keybind), position, true);
        this.keybind = keybind;
        this.position = position;
        this.boundModules = new ArrayList();
        this.enabled = free;
    }

    public boolean isToggled() {
        return this.toggled;
    }

    public void doToggleTick() {
        this.doToggleIf(this.keybind.field_74513_e);
    }

    public void doToggleIf(boolean value) {
        if (value && !this.toggled) {
            this.toggleModules();
        }
        this.toggled = value;
    }

    public void toggleModules() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        for (ClickableModule module : this.boundModules) {
            String valstring;
            String string = valstring = this.toggleval ? " on" : " off";
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                player.func_70006_a("Toggled " + module.getModule().getDataName() + valstring);
            }
            MuseItemUtils.toggleModuleForPlayer((EntityPlayer)player, module.getModule().getDataName(), this.toggleval);
            MusePacketToggleRequest toggleRequest = new MusePacketToggleRequest((Player)player, module.getModule().getDataName(), this.toggleval);
            player.field_71174_a.func_72552_c((Packet)toggleRequest.getPacket250());
        }
        this.toggleval = !this.toggleval;
    }

    public static String parseName(KeyBinding keybind) {
        if (keybind.field_74512_d < 0) {
            return "Mouse" + (keybind.field_74512_d + 100);
        }
        return Keyboard.getKeyName((int)keybind.field_74512_d);
    }

    @Override
    public void draw() {
        super.draw();
        for (ClickableModule module : this.boundModules) {
            MuseRenderer.drawLineBetween(this, module, Colour.LIGHTBLUE);
        }
    }

    public KeyBinding getKeyBinding() {
        return this.keybind;
    }

    public List getBoundModules() {
        return this.boundModules;
    }

    public void bindModule(ClickableModule module) {
        if (!this.boundModules.contains(module)) {
            this.boundModules.add(module);
        }
    }

    public void unbindModule(ClickableModule module) {
        this.boundModules.remove(module);
    }

    public void unbindFarModules() {
        Iterator iterator = this.boundModules.iterator();
        while (iterator.hasNext()) {
            ClickableModule module = (ClickableModule)iterator.next();
            int maxDistance = this.getTargetDistance() * 2;
            double distanceSq = module.getPosition().distanceSq(this.getPosition());
            if (!(distanceSq > (double)(maxDistance * maxDistance))) continue;
            iterator.remove();
        }
    }

    public int getTargetDistance() {
        int targetDistance = 16;
        if (this.boundModules.size() > 6) {
            targetDistance += (this.boundModules.size() - 6) * 3;
        }
        return targetDistance;
    }

    public void attractBoundModules(IClickable exception) {
        for (ClickableModule module : this.boundModules) {
            if (module == exception) continue;
            MusePoint2D euclideanDistance = module.getPosition().minus(this.getPosition());
            MusePoint2D directionVector = euclideanDistance.normalize();
            MusePoint2D tangentTarget = directionVector.times(this.getTargetDistance()).plus(this.getPosition());
            MusePoint2D midpointTangent = module.getPosition().midpoint(tangentTarget);
            module.move(midpointTangent.x(), midpointTangent.y());
        }
    }

    public boolean equals(ClickableKeybinding other) {
        return other.keybind.field_74512_d == this.keybind.field_74512_d;
    }
}

