/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui;

import net.machinemuse.general.geometry.Colour;
import net.machinemuse.utils.render.MuseRenderer;
import net.minecraft.block.Block;
import net.minecraft.util.Icon;
import org.lwjgl.opengl.GL11;

public class HeatMeter {
    int xsize = 8;
    int ysize = 32;

    public void draw(double xpos, double ypos, double value) {
        MuseRenderer.pushTexture("/terrain.png");
        MuseRenderer.blendingOn();
        MuseRenderer.on2D();
        Icon icon = Block.field_71938_D.func_71858_a(0, 0);
        this.drawFluid(xpos, ypos, value, icon);
        this.drawGlass(xpos, ypos);
        MuseRenderer.off2D();
        MuseRenderer.blendingOff();
        MuseRenderer.popTexture();
    }

    public void drawFluid(double xpos, double ypos, double value, Icon icon) {
        double bottomY = ypos + (double)this.ysize;
        double topY = ypos + (double)this.ysize * (1.0 - value);
        GL11.glPushMatrix();
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        while (bottomY - 8.0 > topY) {
            MuseRenderer.drawIconAt(xpos * 2.0, (bottomY - 8.0) * 2.0, icon, Colour.WHITE);
            bottomY -= 8.0;
        }
        MuseRenderer.drawIconPartial(xpos * 2.0, (bottomY - 8.0) * 2.0, icon, Colour.WHITE, 0.0, (topY - bottomY + 8.0) * 2.0, 16.0, 16.0);
        GL11.glPopMatrix();
    }

    public void drawGlass(double xpos, double ypos) {
        MuseRenderer.pushTexture("/mods/mmmPowersuits/textures/gui/glass.png");
        GL11.glBegin((int)7);
        GL11.glTexCoord2d((double)0.0, (double)0.0);
        GL11.glVertex2d((double)xpos, (double)ypos);
        GL11.glTexCoord2d((double)0.0, (double)1.0);
        GL11.glVertex2d((double)xpos, (double)(ypos + (double)this.ysize));
        GL11.glTexCoord2d((double)1.0, (double)1.0);
        GL11.glVertex2d((double)(xpos + (double)this.xsize), (double)(ypos + (double)this.ysize));
        GL11.glTexCoord2d((double)1.0, (double)0.0);
        GL11.glVertex2d((double)(xpos + (double)this.xsize), (double)ypos);
        GL11.glEnd();
        MuseRenderer.popTexture();
    }
}

