/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.geometry;

public class MusePoint2D {
    protected double x;
    protected double y;

    public MusePoint2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public MusePoint2D(MusePoint2D p) {
        this(p.x, p.y);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public MusePoint2D plus(MusePoint2D b) {
        return new MusePoint2D(this.x() + b.x(), this.y() + b.y());
    }

    public MusePoint2D minus(MusePoint2D b) {
        return new MusePoint2D(this.x() - b.x(), this.y() - b.y());
    }

    public MusePoint2D times(double scalefactor) {
        return new MusePoint2D(this.x() * scalefactor, this.y() * scalefactor);
    }

    public boolean equals(MusePoint2D other) {
        return this.x() == other.x() && this.y() == other.y();
    }

    public double distance() {
        return Math.sqrt(this.x() * this.x() + this.y() * this.y());
    }

    public double distanceTo(MusePoint2D position) {
        return Math.sqrt(this.distanceSq(position));
    }

    public double distanceSq(MusePoint2D position) {
        double xdist = position.x() - this.x();
        double ydist = position.y() - this.y();
        return xdist * xdist + ydist * ydist;
    }

    public MusePoint2D normalize() {
        double distance = this.distance();
        return new MusePoint2D(this.x() / distance, this.y() / distance);
    }

    public MusePoint2D midpoint(MusePoint2D target) {
        return new MusePoint2D((this.x() + target.x()) / 2.0, (this.y() + target.y()) / 2.0);
    }

    public MusePoint2D copy() {
        return new MusePoint2D(this.x(), this.y());
    }
}

