/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.machinemuse.general.MuseLogger;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;

public class NBTTagAccessor
extends NBTTagCompound {
    public static Method mTagAccessor;

    public static Method getTagAccessor() throws NoSuchMethodException, SecurityException {
        if (mTagAccessor == null) {
            try {
                mTagAccessor = NBTTagCompound.class.getDeclaredMethod("getTagMap", NBTTagCompound.class);
                mTagAccessor.setAccessible(true);
                return mTagAccessor;
            }
            catch (NoSuchMethodException e) {
                mTagAccessor = NBTTagCompound.class.getDeclaredMethod("a", NBTTagCompound.class);
                mTagAccessor.setAccessible(true);
                return mTagAccessor;
            }
        }
        return mTagAccessor;
    }

    public static Map getMap(NBTTagCompound nbt) {
        try {
            return (Map)NBTTagAccessor.getTagAccessor().invoke((Object)nbt, nbt);
        }
        catch (Exception e) {
            e.printStackTrace();
            MuseLogger.logError("Unable to access nbt tag map!");
            return null;
        }
    }

    public static List getIntValues(NBTTagCompound nbt) {
        ArrayList<NBTTagInt> a = new ArrayList<NBTTagInt>(nbt.func_74758_c().size());
        for (Object o : nbt.func_74758_c()) {
            if (!(o instanceof NBTTagInt)) continue;
            a.add((NBTTagInt)o);
        }
        return a;
    }

    public static List getValues(NBTTagCompound nbt) {
        ArrayList<NBTTagCompound> a = new ArrayList<NBTTagCompound>(nbt.func_74758_c().size());
        for (Object o : nbt.func_74758_c()) {
            if (!(o instanceof NBTTagCompound)) continue;
            a.add((NBTTagCompound)o);
        }
        return a;
    }
}

